<?php
// rrhh_home/asistencia/inc/layout_top.php
declare(strict_types=1);

/** @var mysqli $con */
$user = require_gestor_login();

$estadoInfo = get_estado_actual($con, (int)$user['idempleado']);
$_SESSION['gestor_estado'] = (string)($estadoInfo['estado'] ?? '');

$currentPage = basename($_SERVER['PHP_SELF'] ?? '');
require_working_or_scan($user, $currentPage);

$counts = get_header_counts($con, (int)$user['gestor_id'], (int)$user['idempleado']);

$estado = (string)($_SESSION['gestor_estado'] ?? '');
$estadoLabel = estado_es($estado);

$locked = ($estado !== 'WORKING');
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Asistencia | Gestores</title>
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">

  <!-- AdminLTE 2 (CDN) -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.4.1/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/2.4.18/css/AdminLTE.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/2.4.18/css/skins/skin-blue.min.css">

  <style>
    /* Mobile friendly */
    .content-wrapper{ padding-bottom:60px; }
    .navbar-nav>.user-menu>.dropdown-menu>li.user-header{ height:auto; }
    .user-image-circle{
      width:28px; height:28px; border-radius:50%;
      object-fit:cover; border:2px solid rgba(255,255,255,.7);
    }
    .lock-overlay{
      position:fixed; inset:0; background:rgba(0,0,0,.65); z-index:9999;
      display:flex; align-items:center; justify-content:center; padding:18px;
    }
    .lock-card{
      background:#fff; border-radius:14px; max-width:520px; width:100%;
      padding:18px; box-shadow:0 12px 40px rgba(0,0,0,.35);
    }
    .lock-title{ font-weight:900; margin:0 0 8px; }
    .lock-state{
      display:inline-block; padding:6px 10px; border-radius:999px;
      background:#f3f4f6; border:1px solid #e5e7eb; font-weight:800;
    }
    .lock-actions{ margin-top:12px; display:flex; gap:10px; flex-wrap:wrap; }
    .lock-actions .btn{ border-radius:10px; font-weight:800; }
  </style>
</head>

<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">

  <header class="main-header">
    <a href="dashboard.php" class="logo">
      <span class="logo-mini"><b>G</b></span>
      <span class="logo-lg"><b>Gestores</b> Asistencia</span>
    </a>

    <nav class="navbar navbar-static-top" role="navigation">
      <a href="#" class="sidebar-toggle" data-toggle="push-menu" role="button">
        <span class="sr-only">Toggle navigation</span>
      </a>

      <div class="navbar-custom-menu">
        <ul class="nav navbar-nav">

          <!-- Bandeja / Chat -->
          <li class="dropdown messages-menu">
            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
              <i class="fa fa-inbox"></i>
              <span class="label label-success"><?= (int)$counts['msg_count'] ?></span>
            </a>
            <ul class="dropdown-menu">
              <li class="header">Mensajes: <?= (int)$counts['msg_count'] ?></li>
              <li>
                <ul class="menu">
                  <?php if (empty($counts['msgs'])): ?>
                    <li><a href="#"><i class="fa fa-comment-o text-muted"></i> Sin mensajes</a></li>
                  <?php else: ?>
                    <?php foreach ($counts['msgs'] as $m): ?>
                      <li>
                        <a href="chat.php">
                          <h4 style="margin:0;font-weight:800;"><?= htmlspecialchars($m['from']) ?>
                            <small><i class="fa fa-clock-o"></i> <?= htmlspecialchars($m['time']) ?></small>
                          </h4>
                          <p style="margin:0;"><?= htmlspecialchars($m['text']) ?></p>
                        </a>
                      </li>
                    <?php endforeach; ?>
                  <?php endif; ?>
                </ul>
              </li>
              <li class="footer"><a href="chat.php">Abrir Chat</a></li>
            </ul>
          </li>

          <!-- Notificaciones -->
          <li class="dropdown notifications-menu">
            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
              <i class="fa fa-bell-o"></i>
              <span class="label label-warning"><?= (int)$counts['notif_count'] ?></span>
            </a>
            <ul class="dropdown-menu">
              <li class="header">Notificaciones: <?= (int)$counts['notif_count'] ?></li>
              <li>
                <ul class="menu">
                  <?php if (empty($counts['notifs'])): ?>
                    <li><a href="#"><i class="fa fa-info-circle text-muted"></i> Sin notificaciones</a></li>
                  <?php else: ?>
                    <?php foreach ($counts['notifs'] as $n): ?>
                      <li>
                        <a href="recordatorios.php">
                          <i class="fa fa-bell text-aqua"></i>
                          <b><?= htmlspecialchars($n['title']) ?></b> — <?= htmlspecialchars($n['text']) ?>
                          <small class="text-muted" style="display:block;"><?= htmlspecialchars($n['time']) ?></small>
                        </a>
                      </li>
                    <?php endforeach; ?>
                  <?php endif; ?>
                </ul>
              </li>
              <li class="footer"><a href="recordatorios.php">Ver Recordatorios</a></li>
            </ul>
          </li>

          <!-- Usuario -->
          <li class="dropdown user user-menu">
            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
              <img src="https://via.placeholder.com/80x80.png?text=U" class="user-image user-image-circle" alt="User">
              <span class="hidden-xs"><?= htmlspecialchars($user['nombre']) ?></span>
            </a>
            <ul class="dropdown-menu">
              <li class="user-header">
                <img src="https://via.placeholder.com/120x120.png?text=U" class="img-circle" alt="User">
                <p style="margin-top:10px;">
                  <?= htmlspecialchars($user['nombre']) ?><br>
                  <small>Estado: <b><?= htmlspecialchars($estadoLabel) ?></b></small><br>
                  <?php if (!empty($estadoInfo['fecha_hora'])): ?>
                    <small>Último: <?= htmlspecialchars($estadoInfo['fecha_hora']) ?></small>
                  <?php endif; ?>
                </p>
              </li>
              <li class="user-footer">
                <div class="pull-left">
                  <a href="dashboard.php" class="btn btn-default btn-flat">Dashboard</a>
                </div>
                <div class="pull-right">
                  <a href="logout.php" class="btn btn-default btn-flat">Salir</a>
                </div>
              </li>
            </ul>
          </li>

        </ul>
      </div>
    </nav>
  </header>

  <!-- Sidebar -->
  <aside class="main-sidebar">
    <section class="sidebar">

      <div class="user-panel">
        <div class="pull-left image">
          <img src="https://via.placeholder.com/120x120.png?text=U" class="img-circle" alt="User">
        </div>
        <div class="pull-left info">
          <p style="margin-bottom:2px;"><?= htmlspecialchars($user['nombre']) ?></p>
          <a href="#"><i class="fa fa-circle text-success"></i> <?= htmlspecialchars($estadoLabel) ?></a>
        </div>
      </div>

      <ul class="sidebar-menu" data-widget="tree">
        <li class="header">MENÚ</li>

        <?php if (!$locked): ?>
          <li><a href="dashboard.php"><i class="fa fa-dashboard"></i> <span>Dashboard</span></a></li>
        <?php endif; ?>

        <li class="treeview active">
          <a href="#"><i class="fa fa-qrcode"></i> <span>Asistencia/QR</span>
            <span class="pull-right-container"><i class="fa fa-angle-left pull-right"></i></span>
          </a>
          <ul class="treeview-menu">
            <li><a href="calendario.php"><i class="fa fa-calendar"></i> Calendario</a></li>
                        
            <li><a href="scan.php"><i class="fa fa-camera"></i> Escaner QR</a></li>
            
            <li><a href="scan_extra.php"><i class="fa fa-camera"></i> Escaner Extras QR</a></li>
            <?php if (!$locked): ?>
              <li><a href="historial.php"><i class="fa fa-list"></i> Historial</a></li>
                            <li>
  <a href="ficha_personal.php"><i class="fa fa-id-card"></i> <span>Ficha personal</span></a>
</li>

              



            <?php endif; ?>
          </ul>
        </li>

        <?php if (!$locked): ?>
          <li class="treeview">
            <a href="#"><i class="fa fa-wrench"></i> <span>Herramientas</span>
              <span class="pull-right-container"><i class="fa fa-angle-left pull-right"></i></span>
            </a>
            <ul class="treeview-menu">
              <li><a href="convertidor_pdf.php"><i class="fa fa-file-pdf-o"></i> Convertidor PDF</a></li>
            </ul>
          </li>

          <li><a href="recordatorios.php"><i class="fa fa-bell"></i> <span>Recordatorios</span></a></li>
          <li><a href="chat.php"><i class="fa fa-comments"></i> <span>Chat</span></a></li>
        <?php endif; ?>

        <li><a href="logout.php"><i class="fa fa-sign-out"></i> <span>Salir</span></a></li>
      </ul>

    </section>
  </aside>

  <!-- Content -->
  <div class="content-wrapper">
    <section class="content">

<?php if ($locked && $currentPage !== 'scan.php'): ?>
  <div class="alert alert-warning">
    <b>Panel bloqueado:</b> debes escanear y quedar en estado <b>TRABAJANDO</b>.
  </div>
<?php endif; ?>

<?php if ($locked && $currentPage === 'scan.php' && isset($_GET['locked'])): ?>
  <div class="alert alert-info">
    Estabas en <b><?= htmlspecialchars($estadoLabel) ?></b>. Escanea para volver a <b>TRABAJANDO</b>.
  </div>
<?php endif; ?>

<?php if ($locked): ?>
  <!-- Overlay: bloquea interacción hasta marcar WORKING -->
  <div class="lock-overlay">
    <div class="lock-card">
      <h3 class="lock-title"><i class="fa fa-lock"></i> Panel bloqueado</h3>
      <div>Tu estado actual es: <span class="lock-state"><?= htmlspecialchars($estadoLabel) ?></span></div>
      <div style="margin-top:8px;color:#6b7280;">
        Para habilitar el panel debes escanear el QR y quedar en <b>TRABAJANDO</b>.
      </div>
      <div class="lock-actions">
        <a class="btn btn-primary" href="scan.php"><i class="fa fa-qrcode"></i> Ir a escanear</a>
        <a class="btn btn-default" href="logout.php"><i class="fa fa-sign-out"></i> Salir</a>
      </div>
    </div>
  </div>
<?php endif; ?>
