<?php
declare(strict_types=1);
require_once __DIR__ . '/inc/bootstrap.php';
$user = require_gestor_login();
require_working_or_scan($user, basename($_SERVER['SCRIPT_NAME']));

include __DIR__ . '/inc/layout_top.php';

$manual_ok = (int)($_GET['manual_ok'] ?? 0);
?>
<?php if ($manual_ok === 1): ?>
  <div class="alert alert-success" style="border-radius:12px; font-weight:900;">
    ✅ Ingreso manual exitoso.
  </div>
<?php elseif ($manual_ok === 2): ?>
  <div class="alert alert-success" style="border-radius:12px; font-weight:900;">
    ✅ Reanudación manual exitosa.
  </div>
<?php endif; ?>

<div class="box">
  <div class="box-header with-border">
    <h3 class="box-title"><i class="fa fa-dashboard"></i> Dashboard</h3>
  </div>
  <div class="box-body">
    <p><b>Bienvenido</b>, <?= htmlspecialchars($user['nombre']) ?>.</p>
    <p>Aquí pondremos KPIs rápidos (hoy: entradas/salidas, pausas, horas trabajadas, etc.).</p>
  </div>
</div>
<?php include __DIR__ . '/inc/layout_bottom.php'; ?>
