<?php
// rrhh_home/asistencia/calendario.php
// Calendario mensual: Ausencias + Retrasos + Horas Extra (Planilla)
// + Totales del mes arriba (de calendario_api.php)
// PHP 8.1.33

declare(strict_types=1);
require_once __DIR__ . '/inc/bootstrap.php';
$user = require_gestor_login();
require_working_or_scan($user, basename($_SERVER['SCRIPT_NAME']));

include __DIR__ . '/inc/layout_top.php';
?>
<style>
  .cal-toolbar{
    display:flex; gap:10px; flex-wrap:wrap; align-items:stretch; margin-bottom:10px;
  }
  .panel-pill{
    background:#fff; border:1px solid #e5e7eb; border-radius:12px; padding:10px 12px;
    display:flex; gap:10px; align-items:center;
  }
  .chip{
    display:inline-flex; align-items:center; justify-content:center;
    padding:6px 10px; border-radius:999px; font-weight:900; font-size:12px;
    border:1px solid rgba(0,0,0,.08); white-space:nowrap;
  }
  .chip-aus{ background:#fee2e2; color:#991b1b; border-color:#fecaca; }
  .chip-ret{ background:#dbeafe; color:#1e40af; border-color:#bfdbfe; }
  .chip-ot { background:#fef9c3; color:#854d0e; border-color:#fde68a; }

  .toggle-col{
    display:flex; flex-direction:column; gap:8px; min-width:170px;
  }
  .toggle-row{
    display:flex; align-items:center; justify-content:space-between;
    gap:10px; padding:10px 12px; border:1px solid #e5e7eb; border-radius:12px; background:#fff;
  }
  .toggle-left{
    display:flex; flex-direction:column; gap:6px;
  }
  .toggle-label{ font-weight:900; margin:0; }
  .toggle-check{ margin:0; font-weight:900; }
  .mini-note{ margin-top:10px; font-size:12px; color:#6b7280; font-weight:800; }

  /* “tags” dentro del calendario */
  .fc-tag{
    display:inline-block;
    padding:2px 6px;
    border-radius:999px;
    font-size:11px;
    font-weight:900;
    line-height:1.3;
    border:1px solid rgba(0,0,0,.08);
    white-space:nowrap;
    overflow:hidden;
    text-overflow:ellipsis;
    max-width:100%;
  }
  .fc-tag-aus{ background:#fee2e2; color:#991b1b; border-color:#fecaca; }
  .fc-tag-ret{ background:#dbeafe; color:#1e40af; border-color:#bfdbfe; }
  .fc-tag-ot { background:#fef9c3; color:#854d0e; border-color:#fde68a; }

  #calendarWrap{
    background:#fff; border:1px solid #e5e7eb; border-radius:12px; padding:12px;
  }
</style>

<div class="box">
  <div class="box-header with-border">
    <h3 class="box-title"><i class="fa fa-calendar"></i> Calendario | Ausencias, Retrasos y Horas Extra</h3>
  </div>
  <div class="box-body">

    <div class="cal-toolbar">
      <!-- Mes -->
      <div class="panel-pill" style="min-width:240px;">
        <div style="font-weight:900;">Mes:</div>
        <input type="month" id="monthPicker" class="form-control" style="width:200px;">
      </div>

      <!-- Toggles con TOT arriba -->
      <div class="toggle-col">
        <div class="toggle-row">
          <div class="toggle-left">
            <div class="chip chip-aus">AUSENCIA: <span id="totAus">0</span>h</div>
            <label class="toggle-check"><input type="checkbox" id="chkAus" checked> Mostrar Ausencias</label>
          </div>
        </div>

        <div class="toggle-row">
          <div class="toggle-left">
            <div class="chip chip-ret">RETRASO: <span id="totRet">0</span>h</div>
            <label class="toggle-check"><input type="checkbox" id="chkRet" checked> Mostrar Retrasos</label>
          </div>
        </div>

        <div class="toggle-row">
          <div class="toggle-left">
            <div class="chip chip-ot">OT: <span id="totOT">0</span>h</div>
            <label class="toggle-check"><input type="checkbox" id="chkOT" checked> Mostrar Horas Extra</label>
          </div>
        </div>
      </div>

      <!-- Nota -->
      <div class="panel-pill" style="flex:1; min-width:240px;">
        <span style="color:#6b7280; font-weight:800;">
          Tip: clic en un tag para ver detalle.
        </span>
      </div>
    </div>

    <div id="calendarWrap">
      <div id="calendar"></div>
    </div>

    <div class="mini-note">
      <b>Fuentes (igual que tus editores):</b>
      Horas Extra = <code>extras_mes</code> + <code>extras_detalle</code> |
      Ausencias/Retrasos = <code>ausencias_mes</code> + <code>ausencias_detalle</code>
    </div>

  </div>
</div>

<!-- Modal detalle -->
<div class="modal fade" id="evModal" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content" style="border-radius:12px;">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span>&times;</span></button>
        <h4 class="modal-title" id="evTitle" style="font-weight:900;">Detalle</h4>
      </div>
      <div class="modal-body" id="evBody"></div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
      </div>
    </div>
  </div>
</div>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.5/main.min.css">
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.5/main.min.js"></script>

<script>
(function(){
  const monthPicker = document.getElementById('monthPicker');
  const chkAus = document.getElementById('chkAus');
  const chkRet = document.getElementById('chkRet');
  const chkOT  = document.getElementById('chkOT');

  const totAus = document.getElementById('totAus');
  const totRet = document.getElementById('totRet');
  const totOT  = document.getElementById('totOT');

  const now = new Date();
  const y = now.getFullYear();
  const m = String(now.getMonth()+1).padStart(2,'0');
  monthPicker.value = `${y}-${m}`;

  function getMonthStartEnd(yyyyMM){
    const [yy, mm] = yyyyMM.split('-').map(x=>parseInt(x,10));
    const start = new Date(yy, mm-1, 1);
    const end   = new Date(yy, mm, 0);
    const fmt = (d)=> `${d.getFullYear()}-${String(d.getMonth()+1).padStart(2,'0')}-${String(d.getDate()).padStart(2,'0')}`;
    return {start: fmt(start), end: fmt(end)};
  }

  function setTotals(t){
    const a = (t && typeof t.ausencias_h !== 'undefined') ? t.ausencias_h : 0;
    const r = (t && typeof t.retrasos_h  !== 'undefined') ? t.retrasos_h  : 0;
    const o = (t && typeof t.ot_h        !== 'undefined') ? t.ot_h        : 0;

    totAus.textContent = String(a);
    totRet.textContent = String(r);
    totOT.textContent  = String(o);
  }

  const calEl = document.getElementById('calendar');
  const calendar = new FullCalendar.Calendar(calEl, {
    initialView: 'dayGridMonth',
    height: 'auto',
    firstDay: 1,
    headerToolbar: { left: '', center: 'title', right: '' },

    events: async function(info, successCallback, failureCallback){
      try{
        const mm = monthPicker.value || `${y}-${m}`;
        const rng = getMonthStartEnd(mm);

        const u = `calendario_api.php?start=${encodeURIComponent(rng.start)}&end=${encodeURIComponent(rng.end)}`;
        const r = await fetch(u, {cache:'no-store'});
        const j = await r.json();
        if (!j || !j.ok) throw new Error(j?.msg || 'API error');

        // ✅ Totales arriba (siempre del mes, aunque filtres la vista)
        setTotals(j.totals || null);

        // filtros cliente para pintar eventos
        const showAus = chkAus.checked;
        const showRet = chkRet.checked;
        const showOT  = chkOT.checked;

        const evs = (j.events || []).filter(ev=>{
          const tipo = ev?.extendedProps?.tipo || '';
          if (tipo === 'AUSENCIA') return showAus;
          if (tipo === 'RETRASO') return showRet;
          if (tipo === 'OT') return showOT;
          return true;
        });

        successCallback(evs);
      }catch(e){
        setTotals(null);
        failureCallback(e);
      }
    },

    eventContent: function(arg){
      const tipo = arg.event.extendedProps?.tipo || '';
      const t = (arg.event.title || '').trim();

      let cls = 'fc-tag fc-tag-aus';
      if (tipo === 'OT') cls = 'fc-tag fc-tag-ot';
      if (tipo === 'RETRASO') cls = 'fc-tag fc-tag-ret';

      return { html: `<span class="${cls}" title="${t.replace(/"/g,'&quot;')}">${t}</span>` };
    },

    eventClick: function(info){
      info.jsEvent.preventDefault();

      const ev = info.event;
      const tipo = ev.extendedProps?.tipo || '';
      const fecha = ev.startStr ? ev.startStr.substring(0,10) : '--';
      const det = ev.extendedProps?.detalle || '';

      let title = 'Detalle';
      if (tipo === 'OT') title = '⏱ Horas Extra (Planilla)';
      if (tipo === 'AUSENCIA') title = '⛔ Ausencia (Planilla)';
      if (tipo === 'RETRASO') title = '⏰ Retraso (Planilla)';

      document.getElementById('evTitle').innerText = title;
      document.getElementById('evBody').innerHTML = `
        <div style="font-weight:900;margin-bottom:6px;">${ev.title}</div>
        <div><b>Fecha:</b> ${fecha}</div>
        ${det ? `<div style="margin-top:8px;"><b>Detalle:</b><br>${det}</div>` : ''}
      `;

      $('#evModal').modal('show');
    }
  });

  calendar.render();

  function refetchAll(){
    const mm = monthPicker.value;
    if (mm) {
      const [yy, mo] = mm.split('-').map(x=>parseInt(x,10));
      calendar.gotoDate(new Date(yy, mo-1, 1));
    }
    calendar.refetchEvents();
  }

  monthPicker.addEventListener('change', refetchAll);
  chkAus.addEventListener('change', ()=>calendar.refetchEvents());
  chkRet.addEventListener('change', ()=>calendar.refetchEvents());
  chkOT.addEventListener('change', ()=>calendar.refetchEvents());

})();
</script>

<?php include __DIR__ . '/inc/layout_bottom.php'; ?>
