<?php
header('Content-Type: text/html; charset=UTF-8');
mb_internal_encoding('UTF-8');
// ajax/speed.php — genera/consume datos para pruebas de velocidad
// Uso:
//  GET ?dir=down&n=1048576  -> responde con n bytes ('0') para medir DESCARGA
//  POST ?dir=up             -> consume cuerpo y responde "OK" para medir SUBIDA

// Headers comunes
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
header('Expires: 0');

$dir = isset($_GET['dir']) ? $_GET['dir'] : 'down';

if ($dir === 'up') {
  // Solo lee el cuerpo para que el cliente haga upload real
  // (PHP ya lo habrá recibido en php://input); devolvemos algo corto
  header('Content-Type: text/plain; charset=UTF-8');
  echo "OK";
  exit;
}

// DESCARGA
$len = isset($_GET['n']) ? (int)$_GET['n'] : 1048576; // 1 MB por defecto
if ($len < 1024)   $len = 1024;
if ($len > 5242880) $len = 5242880; // tope 5 MB para no abusar

header('Content-Type: application/octet-stream');
// Evita compresión en algunos servers
header('Content-Encoding: none');
header('Content-Length: ' . $len);

// Genera $len bytes sin ocupar memoria masiva
$chunk = str_repeat('0', 8192);
$sent = 0;
while ($sent < $len) {
  $toSend = min(8192, $len - $sent);
  echo substr($chunk, 0, $toSend);
  $sent += $toSend;
  // flush para streaming real
  if (function_exists('fastcgi_finish_request')) { /* noop aquí */ }
  @ob_flush(); @flush();
}
