<?php
// public_html/colegio/colegio10/rrhh_home/ajax/proveedor_colegioAjax.php
declare(strict_types=1);

if (session_status() === PHP_SESSION_NONE) session_start();

ini_set('display_errors','0');
error_reporting(E_ALL);

/* ========= Conexión ========= */
require_once __DIR__.'/../dbcon.php';                 // estás en /ajax → sube un nivel
if (isset($con) && $con instanceof mysqli) {
  mysqli_set_charset($con, 'utf8mb4');               // fuerza UTF-8 en la conexión
}

/* ========= Modelo ========= */
require_once __DIR__.'/../model/proveedor_colegio.php';
$objCategoria = new Categoria();

/* ========= Router ========= */
$op = $_GET["op"] ?? '';

switch ($op) {

  case 'SaveOrUpdate':
    // Respuesta en TEXTO (igual que lo tenías)
    $fecha          = $_POST["txtfecha"]        ?? '';
    $quienreporta   = $_POST["txtquienreporta"] ?? '';
    $cliente        = $_POST["txtcliente"]      ?? '';
    $txtusuariodpto = $_POST["txtusuariodpto"]  ?? '';
    $email          = $_POST["txtemail"]        ?? '';
    $mensaje        = $_POST["txtmensaje"]      ?? '';
    $telefono       = $_POST["txttelefono"]     ?? '';

    if (empty($_POST["txtIdCategoria"])) {
      if ($objCategoria->Registrar($fecha, $quienreporta, $txtusuariodpto, $mensaje)) {
        echo "Requerimiento Creado Exitosamente";
      } else {
        echo "ERROR:El Requerimiento no se ha podido crear.";
      }
    } else {
      $idCategoria = $_POST["txtIdCategoria"];
      if ($objCategoria->Modificar($idCategoria, $fecha, $quienreporta, $txtusuariodpto, $mensaje)) {
        echo "Requerimiento modificado exitosamente";
      } else {
        echo "Informacion del Requerimiento no ha podido ser actualizada.";
      }
    }
  break;

  case 'delete':
    $id = $_POST["id"] ?? '';
    $result = $objCategoria->Eliminar($id);
    echo $result ? "Eliminado Exitosamente" : "No fue Eliminado";
  break;

  case 'list':
    // Solo aquí respondemos JSON
    header('Content-Type: application/json; charset=UTF-8');

    // Carga helper estricto (no borra nada, escapa controles y convierte a UTF-8)
    require_once __DIR__.'/../libs/json_utf8_safe_strict.php';

    $query_Tipo = $objCategoria->Listar();
    if (!$query_Tipo) {
      // Si el modelo falló, devolvemos un JSON de error (evita la página en blanco)
      echo json_utf8_strict([
        'ok'    => false,
        'error' => 'Listar() devolvió null/false. Revisa el modelo o la consulta.'
      ]);
      exit;
    }

    $data = [];
    $i = 1;
    while ($reg = $query_Tipo->fetch_object()) {
      // Convertimos a string para evitar nulls que rompan el JSON
      $id    = isset($reg->id) ? (string)$reg->id : '';
      $tipo  = isset($reg->tipo) ? (string)$reg->tipo : '';
      $idreq = isset($reg->idrequerimiento) ? (string)$reg->idrequerimiento : '';

      $data[] = [
        "1" => (string)$i,
        "2" => (string)($reg->nombre ?? ''),
        "3" => (string)($reg->representante ?? ''),
        "4" => (string)($reg->posicion ?? ''),
        "5" => (string)($reg->telefono ?? ''),
        "6" => (string)($reg->email ?? ''),
        "7" =>
          '<a href="edit_proveedor.php?id='.$id.'" class="btn btn-warning" data-toggle="tooltip" title="Edit"><i class="fa fa-edit"></i></a>'
          .' <a href="add_eliminarproveedor.php?id='.$id.'&tipo='.$tipo.'&idrequerimiento='.$idreq.'" class="btn btn-danger" data-toggle="tooltip" title="Delete" onclick="return confirm_delete(\'Are you sure you want to delete this record?\');"><i class="fa fa-trash"></i></a>'
      ];
      $i++;
    }

    $results = [
      "sEcho" => 1,
      "iTotalRecords" => count($data),
      "iTotalDisplayRecords" => count($data),
      "aaData" => $data,
      "ok" => true
    ];

    // JSON seguro que conserva tildes/ñ y muestra cualquier byte raro sin romper
    echo json_utf8_strict($results);  // (usa JSON_UNESCAPED_UNICODE|JSON_INVALID_UTF8_SUBSTITUTE)
  break;

  default:
    // Opcional: respuesta de cortesía si no viene 'op'
    header('Content-Type: application/json; charset=UTF-8');
    if (!function_exists('json_utf8_strict')) {
      echo json_encode(['ok'=>false,'error'=>'Operación no especificada (op)'], JSON_UNESCAPED_UNICODE);
    } else {
      echo json_utf8_strict(['ok'=>false,'error'=>'Operación no especificada (op)']);
    }
}

	