<?php
// ajax/logout.php
declare(strict_types=1);

session_start();

$_SESSION = [];

if (ini_get('session.use_cookies')) {
  $params = session_get_cookie_params();
  setcookie(
    session_name(),
    '',
    time() - 42000,
    $params['path'] ?? '/',
    $params['domain'] ?? '',
    (bool)($params['secure'] ?? false),
    (bool)($params['httponly'] ?? true)
  );
}

session_destroy();

header('Content-Type: application/json; charset=utf-8');
echo json_encode(['ok' => true]);
