<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

session_start();
if (!isset($_SESSION["idusuario"])) { http_response_code(401); echo "No autenticado."; exit; }

$esSuper = (isset($_SESSION["superadmin"]) && $_SESSION["superadmin"] === "S");
$tieneRRHH = (isset($_SESSION["permisos"]) && is_array($_SESSION["permisos"]) && in_array("RRHH", $_SESSION["permisos"]));
if (!$esSuper && !$tieneRRHH) { http_response_code(403); echo "No autorizado para descargar archivos."; exit; }

if (!class_exists('ZipArchive')) {
  http_response_code(500); echo "ZipArchive no disponible en el servidor."; exit;
}

require_once __DIR__ . '/../config/rrhh_docs_config.php';
require_once __DIR__ . '/../model/Documentos.php';

$doc = new Documentos();

// --- IDs recibidos ---
$ids = isset($_POST['ids']) ? $_POST['ids'] : array();
if (!is_array($ids) || !count($ids)) { http_response_code(400); echo "No se recibieron IDs válidos."; exit; }

// Limpiar IDs a enteros
$cleanIds = array();
foreach ($ids as $v) {
  $iv = intval($v);
  if ($iv > 0) $cleanIds[] = $iv;
}
if (!count($cleanIds)) { http_response_code(400); echo "IDs inválidos."; exit; }

// Obtener mapa id=>ruta (puede traer rutas o URLs)
$map = $doc->obtenerRutasPorIds($cleanIds);

// --- Preparación ZIP ---
$zipFilename = 'documentos_seleccionados_' . date('Ymd_His') . '.zip';
$tmpZip = tempnam(sys_get_temp_dir(), 'zip');
if ($tmpZip === false) { http_response_code(500); echo "No se pudo crear el archivo temporal."; exit; }

$zip = new ZipArchive();
if ($zip->open($tmpZip, ZipArchive::OVERWRITE)!==true){
  @unlink($tmpZip);
  http_response_code(500); echo "No se pudo crear el ZIP."; exit;
}

// Base permitida (carpeta raíz de documentos)
$baseRel = rtrim(RRHH_DOCS_DIR, '/\\') . '/'; // ej: "Files/documentos_rrhh/"
$baseAbs = realpath(dirname(__DIR__) . '/' . $baseRel);
if ($baseAbs === false) {
  // Intentar crearla si no existe
  $tryMake = dirname(__DIR__) . '/' . $baseRel;
  if (!is_dir($tryMake)) @mkdir($tryMake, 0775, true);
  $baseAbs = realpath($tryMake);
}
if ($baseAbs === false) {
  $zip->close();
  @unlink($tmpZip);
  http_response_code(500); echo "No existe la carpeta base de documentos."; exit;
}

// Helper: sanitizar nombre/ASCII simple (Zip en PHP 5.6 a veces tiene issues con UTF-8)
function safe_name($name) {
  $name = basename($name);
  // reemplazar caracteres no seguros
  $name = preg_replace('/[^A-Za-z0-9._-]/', '_', $name);
  if ($name === '' || $name === '.' || $name === '..') $name = 'file';
  return $name;
}

// --- Agregar archivos locales válidos ---
$agregados = 0;
foreach ($map as $id => $path) {
  if (!$path) continue;

  // Ignorar URLs (solo locales)
  if (preg_match('#^https?://#i', $path)) {
    continue;
  }

  // Resolver ruta absoluta
  // Si el path ya es absoluto, usarlo; si es relativo, unir a base del proyecto
  $candidate = $path;
  if (!file_exists($candidate)) {
    $candidate = dirname(__DIR__) . '/' . ltrim($path, '/\\');
  }

  // Normalizar y validar que esté bajo baseAbs
  $real = realpath($candidate);
  if ($real === false || !is_file($real) || !is_readable($real)) {
    // último intento: si nos pasaron solo el nombre, buscar en baseAbs
    $candidate2 = $baseAbs . DIRECTORY_SEPARATOR . basename($candidate);
    $real2 = realpath($candidate2);
    if ($real2 === false || !is_file($real2) || !is_readable($real2)) {
      continue;
    }
    $real = $real2;
  }

  // Validar que el archivo esté dentro de la carpeta permitida (evitar traversal)
  $realBase = rtrim($baseAbs, DIRECTORY_SEPARATOR) . DIRECTORY_SEPARATOR;
  $realNorm = rtrim($real, DIRECTORY_SEPARATOR);
  if (strpos($realNorm, $realBase) !== 0) {
    // fuera de carpeta Files/documentos_rrhh/
    continue;
  }

  // Nombre dentro del ZIP (evitar colisiones): id_basename.ext
  $zipName = $id . '_' . safe_name(basename($real));

  // Agregar al zip
  $zip->addFile($real, $zipName);
  $agregados++;
}

$zip->close();

if ($agregados === 0){
  @unlink($tmpZip);
  http_response_code(404); echo "No se encontraron archivos locales para los IDs enviados."; exit;
}

// --- Enviar ZIP ---
ignore_user_abort(true);
set_time_limit(0);

// Limpiar buffers para no corromper binario
if (function_exists('ob_get_level')) {
  while (ob_get_level() > 0) { ob_end_clean(); }
}

header('Content-Type: application/zip');
header('Content-Disposition: attachment; filename="'.$zipFilename.'"');
header('Content-Length: ' . filesize($tmpZip));
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: public');

$fp = fopen($tmpZip, 'rb');
if ($fp) {
  while (!feof($fp)) {
    echo fread($fp, 8192);
  }
  fclose($fp);
} else {
  // Fallback
  readfile($tmpZip);
}

@unlink($tmpZip);
exit;
