<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

session_start();
date_default_timezone_set('America/Costa_Rica');

if (!isset($_SESSION["idusuario"])) { http_response_code(401); echo "No autenticado."; exit; }

require_once __DIR__ . '/../config/rrhh_docs_config.php';
require_once __DIR__ . '/../model/Documentos.php';

$doc = new Documentos();

// ------- Datos del POST -------
$id   = isset($_POST['id']) ? intval($_POST['id']) : 0;
$fd   = isset($_POST['fecha_documento']) ? $_POST['fecha_documento'] : null; // usado para subcarpeta
$desc = isset($_POST['descripcion']) ? trim($_POST['descripcion']) : null;
$fi   = isset($_POST['fecha_inicio']) ? $_POST['fecha_inicio'] : null;
$fv   = isset($_POST['fecha_vencimiento']) ? $_POST['fecha_vencimiento'] : null;
$dp   = (isset($_POST['dias_programados']) && is_numeric($_POST['dias_programados'])) ? intval($_POST['dias_programados']) : 30;
$link = isset($_POST['link']) ? trim($_POST['link']) : '';
$categoria_id = (isset($_POST['categoria_id']) && $_POST['categoria_id']!=='') ? intval($_POST['categoria_id']) : null;

// ===== Helpers =====
function _clampv($v,$min,$max){ return max($min, min($max, $v)); }
function _parse_crop_list($json){ $d=json_decode($json,true); return is_array($d)?$d:[]; }
function _mes_anio_es_desde_fecha($fechaYmd){
  static $meses = [1=>'Enero','Febrero','Marzo','Abril','Mayo','Junio','Julio','Agosto','Septiembre','Octubre','Noviembre','Diciembre'];
  $t = strtotime($fechaYmd ?: 'now'); if ($t === false) $t = time();
  return $meses[intval(date('n',$t))] . '-' . date('Y',$t);
}

// Imagick: añade una imagen (con crop/rotate) como página PDF
function _imagick_add_image_page($doc, $tmp, $crop=null){
  $img = new Imagick();
  $img->readImage($tmp);
  $img->setImageColorspace(Imagick::COLORSPACE_SRGB);
  if (method_exists($img,'setImageAlphaChannel')) $img->setImageAlphaChannel(Imagick::ALPHACHANNEL_REMOVE);

  if (is_array($crop) && isset($crop['rotate']) && abs((float)$crop['rotate'])>0.01) {
    $img->rotateImage(new ImagickPixel('white'), (float)$crop['rotate']);
  }
  if (is_array($crop) && !empty($crop['width']) && !empty($crop['height'])) {
    $w=$img->getImageWidth(); $h=$img->getImageHeight();
    $x=_clampv((int)($crop['x']??0),0,$w); $y=_clampv((int)($crop['y']??0),0,$h);
    $cw=_clampv((int)$crop['width'],1,$w); $ch=_clampv((int)$crop['height'],1,$h);
    if ($x+$cw>$w) $cw=$w-$x; if ($y+$ch>$h) $ch=$h-$y;
    if ($cw>1 && $ch>1){ $img->cropImage($cw,$ch,$x,$y); $img->setImagePage(0,0,0,0); }
  }

  // Reducción prudente
  $maxW=2500; $maxH=3500;
  $w=$img->getImageWidth(); $h=$img->getImageHeight();
  if ($w>$maxW || $h>$maxH) { $img->thumbnailImage($maxW,$maxH,true,true); }

  $img->setImageUnits(Imagick::RESOLUTION_PIXELSPERINCH);
  $img->setImageResolution(150,150);
  $img->setImageFormat('pdf');

  $doc->addImage($img);
  $img->clear(); $img->destroy();
  return true;
}

// GD: imagen → bytes JPEG (para fallback sin Imagick)
function _gd_image_to_jpeg_bytes($tmp, $ext, $crop=null){
  switch($ext){
    case 'jpg':case 'jpeg': $im=@imagecreatefromjpeg($tmp); break;
    case 'png': $im=@imagecreatefrompng($tmp); break;
    case 'gif': $im=@imagecreatefromgif($tmp); break;
    default: return null;
  }
  if(!$im) return null;
  $w=imagesx($im); $h=imagesy($im);

  if (is_array($crop) && !empty($crop['width']) && !empty($crop['height'])){
    $x=_clampv((int)($crop['x']??0),0,$w); $y=_clampv((int)($crop['y']??0),0,$h);
    $cw=_clampv((int)$crop['width'],1,$w); $ch=_clampv((int)$crop['height'],1,$h);
    if ($x+$cw>$w) $cw=$w-$x; if ($y+$ch>$h) $ch=$h-$y;
    $dst=imagecreatetruecolor($cw,$ch);
    imagecopyresampled($dst,$im,0,0,$x,$y,$cw,$ch,$cw,$ch);
    imagedestroy($im); $im=$dst; $w=$cw; $h=$ch;
  }

  @imagefilter($im, IMG_FILTER_CONTRAST, -10);
  @imagefilter($im, IMG_FILTER_BRIGHTNESS, 5);

  $maxW=2500; $maxH=3500;
  if ($w>$maxW || $h>$maxH){
    $ratio=min($maxW/$w,$maxH/$h);
    $nw=(int)round($w*$ratio); $nh=(int)round($h*$ratio);
    $res=imagecreatetruecolor($nw,$nh);
    imagecopyresampled($res,$im,0,0,0,0,$nw,$nh,$w,$h);
    imagedestroy($im); $im=$res; $w=$nw; $h=$nh;
  }

  ob_start(); imagejpeg($im,null,80); $data=ob_get_clean();
  imagedestroy($im);
  return ['data'=>$data,'w'=>$w,'h'=>$h];
}

// GD: multipágina simple
function _build_multi_pdf_from_jpegs($pages, $targetPdf){
  $unit=72; $a4w=8.27*$unit; $a4h=11.69*$unit; $dpi=150.0;
  $pdf="%PDF-1.3\n"; $ofs=array(); $objNum=1;
  $ofs[] = strlen($pdf);
  $pdf .= ($objNum)." 0 obj<< /Type /Catalog /Pages 2 0 R >>endobj\n";
  $catalogObj=$objNum; $objNum++;
  $pagesObj=$objNum; $objNum++; $kids=array();
  foreach($pages as $pg){
    $w=$pg['w']; $h=$pg['h']; $imgData=$pg['data'];
    $imgWpt=($w/$dpi)*72.0; $imgHpt=($h/$dpi)*72.0;
    $scale=min($a4w*0.92/$imgWpt,$a4h*0.92/$imgHpt); if($scale<=0)$scale=1;
    $dw=$imgWpt*$scale; $dh=$imgHpt*$scale;
    $x=($a4w-$dw)/2; $y=($a4h-$dh)/2;

    $imgObj=$objNum++; $ofs[] = strlen($pdf);
    $pdf.=$imgObj." 0 obj<< /Type /XObject /Subtype /Image /Width ".intval($w)." /Height ".intval($h)." /ColorSpace /DeviceRGB /BitsPerComponent 8 /Filter /DCTDecode /Length ".strlen($imgData)." >>stream\n".$imgData."\nendstream\nendobj\n";

    $stream="q\n".sprintf('%.2f 0 0 %.2f %.2f %.2f cm',$dw,$dh,$x,$y)."\n/Im0 Do\nQ\n";
    $cntObj=$objNum++; $ofs[] = strlen($pdf);
    $pdf.=$cntObj." 0 obj<< /Length ".strlen($stream)." >>stream\n".$stream."endstream\nendobj\n";

    $pageObj=$objNum++; $ofs[] = strlen($pdf);
    $pdf.=$pageObj." 0 obj<< /Type /Page /Parent ".$pagesObj." 0 R /MediaBox [0 0 ".sprintf('%.2f %.2f',$a4w,$a4h)."] /Resources << /XObject << /Im0 ".$imgObj." 0 R >> /ProcSet [/PDF /ImageC] >> /Contents ".$cntObj." 0 R >>endobj\n";
    $kids[]=$pageObj." 0 R";
  }
  $ofs[] = strlen($pdf);
  $pdf.=$pagesObj." 0 obj<< /Type /Pages /Count ".count($kids)." /Kids [ ".implode(' ',$kids)." ] >>endobj\n";
  $xrefPos=strlen($pdf);
  $pdf.="xref\n0 ".($objNum)."\n0000000000 65535 f \n";
  foreach($ofs as $o){ $pdf.=sprintf("%010d 00000 n \n",$o); }
  $pdf.="trailer<< /Size ".($objNum)." /Root ".$catalogObj." 0 R >>\nstartxref\n".$xrefPos."\n%%EOF";
  return (bool)file_put_contents($targetPdf,$pdf);
}

// ------- Validaciones -------
$errs = array();
if (!$fd)  $errs[] = "Falta fecha_documento";
if (!$desc)$errs[] = "Falta descripcion";
if (!$fi)  $errs[] = "Falta fecha_inicio";
if (!$fv)  $errs[] = "Falta fecha_vencimiento";
if ($fv && $fi && strtotime($fv) < strtotime($fi)) $errs[] = "vencimiento no puede ser antes que inicio";

// detectar archivo
$hasFile = false;
if (isset($_FILES['archivo'])) {
  if (is_array($_FILES['archivo']['tmp_name'])) {
    foreach($_FILES['archivo']['tmp_name'] as $t){ if($t!='') { $hasFile=true; break; } }
  } else {
    $hasFile = ($_FILES['archivo']['tmp_name']!='');
  }
}
$hasLink = ($link !== '');

// Para alta
if ($id === 0){
  if ($hasFile && $hasLink) $errs[] = "Indica solo archivo o solo link (no ambos).";
  if (!$hasFile && !$hasLink) $errs[] = "Debes indicar un archivo o un link.";
}
if ($hasLink && !preg_match('#^https?://#i', $link)) { $errs[] = "El link debe empezar con http:// o https://"; }

if (count($errs)){ http_response_code(400); echo implode("\n", $errs); exit; }

// ------- Subcarpeta por mes-año -------
$subCarpeta = _mes_anio_es_desde_fecha($fd);

// ------- Resolver ruta/URL -------
$ruta = null;
if ($id > 0 && !$hasFile && !$hasLink){
  $act = $doc->obtenerPorId($id);
  if (!$act){ http_response_code(404); echo "Documento no encontrado."; exit; }
  $ruta = $act['imagen1'];
}

// ------- Config permitidos / tamaño -------
$allowed = array();
foreach (explode(',', RRHH_ALLOWED_EXT) as $e) { $e = trim(strtolower($e)); if ($e!=='') $allowed[] = $e; }
if (!in_array('pdf',$allowed,true)) $allowed[] = 'pdf'; // ← asegurar PDF permitido
$max = RRHH_MAX_SIZE;

// ===== Carpeta base + subcarpeta
$baseDirFs = rtrim(dirname(__DIR__) . '/' . RRHH_DOCS_DIR, '/\\') . '/';
$baseDirDb = rtrim(RRHH_DOCS_DIR, '/\\') . '/';
$dirFs = $baseDirFs . $subCarpeta . '/';
$dirDb = $baseDirDb . $subCarpeta . '/';
if (!is_dir($dirFs)) { @mkdir($dirFs, 0775, true); }

// ===== Proceso de subida/union
if ($hasFile){
  // normaliza arrays
  if (is_array($_FILES['archivo']['name'])) {
    $names = $_FILES['archivo']['name'];
    $tmps  = $_FILES['archivo']['tmp_name'];
    $sizes = $_FILES['archivo']['size'];
  } else {
    $names = [$_FILES['archivo']['name']];
    $tmps  = [$_FILES['archivo']['tmp_name']];
    $sizes = [$_FILES['archivo']['size']];
  }

  $crop_list = _parse_crop_list($_POST['crop_json_list'] ?? '[]');

  // nombre final pdf
  $safePdf   = 'rrhh_'.date('Ymd_His').'_'.mt_rand(1000,9999).'.pdf';
  $targetPdf = $dirFs . $safePdf;

  $useImagick = class_exists('Imagick');

  if ($useImagick){
    $docPdf = new Imagick();
    $added = 0;

    foreach($names as $i=>$origName){
      if (!$origName) continue;
      if (!isset($tmps[$i]) || $tmps[$i]=='') continue;
      if ((int)$sizes[$i] > $max){ http_response_code(400); echo "Archivo supera tamaño máximo."; exit; }

      $ext = strtolower(pathinfo($origName, PATHINFO_EXTENSION));
      if (!in_array($ext,$allowed,true)){ http_response_code(400); echo "Extensión no permitida: ".$ext; exit; }

      $tmp = $tmps[$i];

      if ($ext === 'pdf'){
        // ← añade TODAS las páginas del PDF
        try { $docPdf->readImage($tmp); $added++; } catch(Exception $e){}
      } else {
        // imágenes (con crop/rotate)
        if (_imagick_add_image_page($docPdf, $tmp, $crop_list[$i] ?? null)) $added++;
      }
    }

    if ($added === 0){ http_response_code(400); echo "No se encontraron archivos válidos."; exit; }

    $docPdf->setImageFormat('pdf');
    foreach($docPdf as $p){
      $p->setImageCompression(Imagick::COMPRESSION_JPEG);
      $p->setImageCompressionQuality(80);
      $p->setImageUnits(Imagick::RESOLUTION_PIXELSPERINCH);
      $p->setImageResolution(150,150);
    }
    $docPdf->writeImages($targetPdf, true);
    $docPdf->clear(); $docPdf->destroy();

    if (!file_exists($targetPdf)){ http_response_code(500); echo "No se pudo guardar el PDF."; exit; }
    $ruta = $dirDb . basename($targetPdf);

  } else {
    // Sin Imagick: limitación
    $pdfCount=0; $pdfIdx=-1;
    foreach($names as $i=>$origName){
      $ext = strtolower(pathinfo($origName, PATHINFO_EXTENSION));
      if ($ext==='pdf'){ $pdfCount++; $pdfIdx=$i; }
    }
    if ($pdfCount>1){
      http_response_code(400);
      echo "Para fusionar varios PDFs se requiere la extensión Imagick en el servidor.";
      exit;
    }
    if ($pdfCount===1){
      if (!isset($tmps[$pdfIdx]) || $tmps[$pdfIdx]==''){ http_response_code(400); echo "PDF inválido."; exit; }
      if ((int)$sizes[$pdfIdx] > $max){ http_response_code(400); echo "Archivo supera tamaño máximo."; exit; }
      $ext = strtolower(pathinfo($names[$pdfIdx], PATHINFO_EXTENSION));
      if (!in_array($ext,$allowed,true)){ http_response_code(400); echo "Extensión no permitida: ".$ext; exit; }

      if (!move_uploaded_file($tmps[$pdfIdx], $targetPdf)){
        if (!@copy($tmps[$pdfIdx], $targetPdf)){ http_response_code(500); echo "No se pudo mover el PDF."; exit; }
      }
      $ruta = $dirDb . basename($targetPdf);

    } else {
      // Solo imágenes: multipágina GD
      $pages=[];
      foreach($names as $i=>$origName){
        if (!isset($tmps[$i]) || $tmps[$i]=='') continue;
        if ((int)$sizes[$i] > $max){ http_response_code(400); echo "Archivo supera tamaño máximo."; exit; }
        $ext = strtolower(pathinfo($origName, PATHINFO_EXTENSION));
        if (!in_array($ext,$allowed,true)){ http_response_code(400); echo "Extensión no permitida: ".$ext; exit; }
        if (!in_array($ext,['jpg','jpeg','png','gif'])) continue;

        $gd = _gd_image_to_jpeg_bytes($tmps[$i], $ext, $crop_list[$i] ?? null);
        if ($gd && isset($gd['data'])){ $pages[]=['data'=>$gd['data'],'w'=>$gd['w'],'h'=>$gd['h']]; }
      }
      if (empty($pages)){ http_response_code(400); echo "No se encontraron imágenes válidas para crear el PDF."; exit; }
      if (!_build_multi_pdf_from_jpegs($pages, $targetPdf)){ http_response_code(500); echo "Falló al crear el PDF."; exit; }
      $ruta = $dirDb . basename($targetPdf);
    }
  }

} elseif ($hasLink) {
  $ruta = $link;
}

// ------- Compat con modelos con/sin categoría -------
function method_arity($className, $methodName){
  if (!method_exists($className, $methodName)) return 0;
  $rm = new ReflectionMethod($className, $methodName);
  return $rm->getNumberOfParameters();
}
$arity_insertar   = method_arity('Documentos', 'insertar');   // viejo: 6 | nuevo: 7
$arity_actualizar = method_arity('Documentos', 'actualizar'); // viejo: 7 | nuevo: 8

// ------- Guardar -------
if ($id > 0){
  if ($arity_actualizar >= 8){
    $doc->actualizar($id, $fd, $desc, $categoria_id, $fi, $fv, $ruta, $dp);
  } else {
    $doc->actualizar($id, $fd, $desc, $fi, $fv, $ruta, $dp);
  }
} else {
  if ($arity_insertar >= 7){
    $doc->insertar($fd, $desc, $categoria_id, $fi, $fv, $ruta, $dp);
  } else {
    $doc->insertar($fd, $desc, $fi, $fv, $ruta, $dp);
  }
}

header("Location: ../documentos.php");
exit;

