<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

session_start();
header('Content-Type: application/json; charset=utf-8');
// Evitar cacheo de respuestas AJAX
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');

require_once __DIR__ . '/../model/Documentos.php';
$doc = new Documentos();

// Operación solicitada
$op = isset($_GET['op']) ? $_GET['op'] : 'listar';

// Filtros opcionales
$categoria_id = (isset($_GET['categoria_id']) && is_numeric($_GET['categoria_id'])) ? intval($_GET['categoria_id']) : 0;
$umbral       = (isset($_GET['umbral']) && is_numeric($_GET['umbral'])) ? intval($_GET['umbral']) : null;

/** Utils */
function rows_to_array($rs){
  $a = array();
  if ($rs) { while($r = $rs->fetch_assoc()){ $a[] = $r; } }
  return $a;
}
function method_arity($className, $methodName){
  if (!method_exists($className, $methodName)) return 0;
  $rm = new ReflectionMethod($className, $methodName);
  return $rm->getNumberOfParameters();
}
function json_ok($data){
  echo json_encode($data, JSON_UNESCAPED_UNICODE);
  exit;
}
function json_err($code, $msg){
  http_response_code($code);
  echo json_encode(array('ok'=>false, 'error'=>$msg), JSON_UNESCAPED_UNICODE);
  exit;
}

try {
  if ($op === 'listar') {
    // Documentos::listarTodos() — viejo: 0 params | nuevo: 1 param ($categoria_id)
    $arity = method_arity('Documentos', 'listarTodos');
    $rs = ($arity >= 1) ? $doc->listarTodos($categoria_id) : $doc->listarTodos();
    json_ok(array('ok'=>true, 'data'=>rows_to_array($rs)));
  }

  if ($op === 'por_vencer') {
    // Documentos::listarPorVencer() — viejo: 1 param ($umbral) | nuevo: 2 params ($umbral, $categoria_id)
    $arity = method_arity('Documentos', 'listarPorVencer');
    $rs = ($arity >= 2) ? $doc->listarPorVencer($umbral, $categoria_id) : $doc->listarPorVencer($umbral);
    json_ok(array('ok'=>true, 'data'=>rows_to_array($rs)));
  }

  // Operación no reconocida
  json_err(400, 'Operación no válida');

} catch (Exception $e){
  json_err(500, 'Error interno: '.$e->getMessage());
}

