<?php
// ajax/consulta_vacaciones_extra.php
declare(strict_types=1);

if (session_status() === PHP_SESSION_NONE) session_start();

// Desactiva display de errores en producción si quieres
ini_set('display_errors','0');
error_reporting(E_ALL);

/* ========= Conexión ========= */
require_once __DIR__.'/../dbcon.php';   // ajusta la ruta si cambia
if (isset($con) && $con instanceof mysqli) {
  mysqli_set_charset($con, 'utf8mb4'); // fuerza utf8mb4 en la conexión
}
	require_once "../model/consulta_vacaciones.php";
$objArticulo = new Articulo();

/* ========= Helper JSON anti-tildes / bytes raros ========= */
/**
 * Codifica a JSON en UTF-8:
 *  - Conserva tildes/ñ (JSON_UNESCAPED_UNICODE)
 *  - Sustituye bytes inválidos sin romper el JSON (JSON_INVALID_UTF8_SUBSTITUTE)
 *  - Escapa caracteres de control e intenta devolver siempre una cadena válida
 */
function json_utf8_strict($data): string {
  // Normaliza strings recursivamente a UTF-8
  $normalize = function (&$v) use (&$normalize) {
    if (is_string($v)) {
      // Si no es UTF-8 válido, intenta convertir; si falla, lo deja y JSON lo sustituirá
      if (!mb_detect_encoding($v, 'UTF-8', true)) {
        $v = @mb_convert_encoding($v, 'UTF-8', 'auto') ?: $v;
      }
      // Elimina controles no imprimibles (excepto \t \n \r)
      $v = preg_replace('/[\x00-\x08\x0B\x0C\x0E-\x1F\x7F]/u', '', $v);
    } elseif (is_array($v)) {
      foreach ($v as &$vv) $normalize($vv);
    } elseif (is_object($v)) {
      foreach ($v as $k => $vv) $normalize($v->$k);
    }
  };
  $copy = $data;
  $normalize($copy);

  $json = json_encode(
    $copy,
    JSON_UNESCAPED_UNICODE | JSON_INVALID_UTF8_SUBSTITUTE
  );
  if ($json === false) {
    return '{"ok":false,"error":"No se pudo codificar JSON","code":'.json_encode(json_last_error()).'}';
  }
  return $json;
}

/* ========= Router ========= */
$op = $_GET["op"] ?? '';

switch ($op) {

  // ------------------------------------------
  // DIAGNÓSTICO UTF-8 — op=utf8_diag
  // ------------------------------------------
  case 'utf8_diag':
    header('Content-Type: application/json; charset=UTF-8');

    $literal = "ñeñeñe";

    $hex_literal = strtoupper(implode('', array_map(
      fn($c)=>str_pad(dechex(ord($c)),2,'0',STR_PAD_LEFT),
      str_split($literal)
    )));

    $mysql_vars = [];
    if (isset($con) && $con instanceof mysqli) {
      foreach (["character_set_%","collation_%","time_zone"] as $like) {
        if ($rs = $con->query("SHOW VARIABLES LIKE '".$con->real_escape_string($like)."'")) {
          while ($row = $rs->fetch_assoc()) $mysql_vars[$row['Variable_name']] = $row['Value'];
          $rs->free();
        }
      }
    }

    $probe = [
      'sEcho' => 1,
      'iTotalRecords' => 3,
      'iTotalDisplayRecords' => 3,
      'aaData' => [
        ['col' => 'Texto visible', 'val' => $literal],
        ['col' => 'En atributo title', 'val' => '<div title="ñeñeñe">hover</div>'],
        ['col' => 'Escapado HTML', 'val' => esc($literal)],
      ],
    ];

    echo json_utf8_strict([
      'ok' => true,
      'php' => [
        'default_charset' => ini_get('default_charset'),
        'mb_internal'     => function_exists('mb_internal_encoding') ? @mb_internal_encoding() : null,
        'mb_http_output'  => function_exists('mb_http_output') ? @mb_http_output() : null,
      ],
      'mysql' => $mysql_vars,
      'literal' => $literal,
      'literal_hex' => $hex_literal,
      'datatable_probe' => $probe,
    ]);
    exit;

  // ------------------------------------------
  // SAVE / UPDATE

		case 'SaveOrUpdate':			

$idusuario = $_POST["idusuario"];
$idsucursal = $_POST["idsucursal"];

			$idcategoria = $_POST["cboCategoria"];
			$idunidad_medida = $_POST["cboUnidadMedida"];
			$nombre = $_POST["txtNombre"];
			$descripcion = $_POST["txtDescripcion"];
			$venta = $_POST["venta"];
			$costo = $_POST["costo"];
			$imagen = $_FILES["imagenArt"]["tmp_name"];
			$ruta = $_FILES["imagenArt"]["name"];
			
			if(move_uploaded_file($imagen, "../Files/Articulo/".$ruta)){

				if(empty($_POST["txtIdArticulo"])){
					
					if($objArticulo->Registrar($idcategoria, $idunidad_medida, $nombre, $descripcion, $venta, $costo, "Files/Articulo/".$ruta)){
						echo "Articulo Registrado";
					}else{
						echo "Articulo no ha podido ser registado.";
					}
				}else{
					
					$idarticulo = $_POST["txtIdArticulo"];
					if($objArticulo->Modificar($idarticulo, $idcategoria, $idunidad_medida, $nombre, $descripcion, $venta, $costo,  "Files/Articulo/".$ruta)){
						echo "Informacion del Articulo ha sido actualizada";
					}else{
						echo "Informacion del Articulo no ha podido ser actualizada.";
					}
				}
			} else {
				$ruta_img = $_POST["txtRutaImgArt"];
				if(empty($_POST["txtIdArticulo"])){
					
					if($objArticulo->Registrar($idcategoria, $idunidad_medida, $nombre, $descripcion, $venta, $costo, $ruta_img)){
						echo "Articulo Registrado";
					}else{
						echo "Articulo no ha podido ser registado.";
					}
				}else{
					
					$idarticulo = $_POST["txtIdArticulo"];
					if($objArticulo->Modificar($idarticulo, $idcategoria, $idunidad_medida, $nombre, $descripcion, $venta, $costo, $ruta_img)){
						echo "Informacion del Articulo ha sido actualizada";
					}else{
						echo "Informacion del Articulo no ha podido ser actualizada.";
					}
				}
			}

			break;

		case "delete":			
			
			$id = $_POST["id"];
			$result = $objArticulo->Eliminar($id);
			if ($result) {
				echo "Eliminado Exitosamente";
			} else {
				echo "No fue Eliminado";
			}
			break;
		
		case "list":
		    // Siempre JSON UTF-8
    header('Content-Type: application/json; charset=UTF-8');
			$query_Tipo = $objArticulo->Listar($idusuario,$idsucursal);
			$data = Array();
            $i =0;
            $d=$i;
     		while ($reg = $query_Tipo->fetch_object()) {

            $data[] = array(
                "id" => $i,
                "1" => $reg->id,
                "2" => $reg->fecha_documento,
                "3" => $reg->fecha_desde,
                "4" => $reg->fecha_hasta,
                "5" => $reg->empleado,
                "6" => $reg->motivo,
                "7" => $reg->cantidad_dias,
                
"8" => '
<a href="modificar_imagen1_vacaciones.php?id='.$reg->id.'"  >Editar</a><br>
<div class="img-clickable1" 
     data-imagen="'.(!empty($reg->imagen1) ? $reg->imagen1 : 'Files/sin_imagen.png').'" 
     data-id="'.$reg->id.'" 
     style="display:inline-block; cursor:pointer; width:90px; height:90px; border:1px solid #ccc; position:relative; overflow:hidden;">

        '.(!empty($reg->imagen1)
            ? (strtolower(pathinfo($reg->imagen1, PATHINFO_EXTENSION)) === 'pdf'
                ? '<embed src="'.$reg->imagen1.'" type="application/pdf" width="90" height="90" style="object-fit:cover;">'
                : '<img src="'.$reg->imagen1.'" style="width:100%; height:auto;">'
              )
            : '<img src="Files/sin_imagen.png" style="width:100%; height:auto;">'
        ).'

        '.(!empty($reg->imagen1) && strtolower(pathinfo($reg->imagen1, PATHINFO_EXTENSION)) === 'pdf'
            ? '<div style="
                 position:absolute; bottom:4px; left:50%; transform:translateX(-50%);
                 background:rgba(0,0,0,0.6); color:#fff; font-size:10px; padding:2px 4px; border-radius:4px; font-weight:bold;
                 width:100%; text-align:center;
                 cursor:pointer;
             ">Ver PDF</div>'
            : ''
        )
,


                "9" => '<a href="edit_vacaciones.php?id='.$reg->id.'&tipo='.$reg->tipo.'&idrequerimiento='.$reg->idrequerimiento.'" class="btn btn-warning" data-toggle="tooltip" title="Edit"  ><i class="fa fa-edit"></i></a>'.
                        '<a href="add_eliminar_vacaciones.php?id='.$reg->id.'&tipo='.$reg->tipo.'&idrequerimiento='.$reg->idrequerimiento.'" class="btn btn-danger" data-toggle="tooltip" title="Delete" onclick="return confirm_delete(\'Are you sure you want to delete this record?\');"><i class="fa fa-trash"></i></a>'
);
					
				$i++;
			}
        header('Content-Type: application/json; charset=UTF-8');
    echo json_utf8_strict([
      "sEcho" => 1,
      "iTotalRecords"        => count($data),
      "iTotalDisplayRecords" => count($data),
      "aaData"               => $data,
      "ok"                   => true
    ]);
    break;
		case "listArtElegir":
			$query_Tipo = $objArticulo->Listar();
			$data = Array();
            $i = 1;
     		while ($reg = $query_Tipo->fetch_object()) {

     			$data[] = array(
     				"0"=>'<button type="button" class="btn btn-warning" data-toggle="tooltip" title="Agregar al detalle" onclick="Agregar('.$reg->idarticulo.',\''.$reg->nombre.'\',\''.$reg->codigo2.'\',\''.$reg->costo.'\',\''.$reg->venta.'\')" name="optArtBusqueda[]" data-nombre="'.$reg->nombre.'" id="'.$reg->idarticulo.'" value="'.$reg->idarticulo.'" codigo="'.$reg->codigo2.'" value="'.$reg->codigo2.'"costo="'.$reg->costo.'" value="'.$reg->costo.'" venta="'.$reg->venta.'" value="'.$reg->venta.'" ><i class="fa fa-check" ></i> </button>',
     				"1"=>$i,
					"2"=>$reg->categoria,
					"3"=>$reg->unidadMedida,
					"4"=>$reg->nombre,
					"5"=>$reg->descripcion,
					"6"=>'<img width=100px height=100px src="./'.$reg->imagen,
					"7"=>$reg->codigo2,
					"8"=>$reg->costo,
					"9"=>$reg->venta.'"
					/>');
				$i++;
            }
            
            $results = array(
            "sEcho" => 1,
        	"iTotalRecords" => count($data),
        	"iTotalDisplayRecords" => count($data),
            "aaData"=>$data);
			echo json_encode($results);
            
			break;

		case "listCategoria":
	        require_once "../model/Categoria.php";

	        $objCategoria = new Categoria();

	        $query_Categoria = $objCategoria->Listar();

	        while ($reg = $query_Categoria->fetch_object()) {
	            echo '<option value=' . $reg->idcategoria . '>' . $reg->nombre . '</option>';
	        }

	        break;

	    case "listUM":

	    	require_once "../model/Categoria.php";

	        $objCategoria = new Categoria();

	        $query_Categoria = $objCategoria->ListarUM();

	        while ($reg = $query_Categoria->fetch_object()) {
	            echo '<option value=' . $reg->idunidad_medida . '>' . $reg->nombre . '</option>';
	        }

	        break;


	}
	