<?php
declare(strict_types=1);

if (session_status() === PHP_SESSION_NONE) session_start();

/* ===== Charset y conexión ===== */
require_once __DIR__ . '/../dbcon.php';          // asegura utf8mb4 en la conexión
if (isset($con) && $con instanceof mysqli) {
  @mysqli_set_charset($con, 'utf8mb4');
}

/* ===== Modelo ===== */
require_once __DIR__ . '/../model/consulta_formatos.php';
$objArticulo = new Articulo();

/* ===== Helpers seguros ===== */
if (!function_exists('esc')) {
  function esc($v): string { return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }
}
if (!function_exists('is_drive_link')) {
  function is_drive_link($s): bool {
    return is_string($s) && preg_match('#^https?://(docs|drive)\.google\.com/#i', $s) === 1;
  }
}
if (!function_exists('file_ext')) {
  function file_ext($s): string { return strtolower(pathinfo((string)$s, PATHINFO_EXTENSION)); }
}
/** JSON robusto en UTF-8: conserva tildes y sustituye bytes inválidos */
if (!function_exists('json_utf8_strict')) {
  function json_utf8_strict($data): string {
    $normalize = function (&$v) use (&$normalize) {
      if (is_string($v)) {
        if (!mb_detect_encoding($v, 'UTF-8', true)) {
          $v = @mb_convert_encoding($v, 'UTF-8', 'auto') ?: $v;
        }
        $v = preg_replace('/[\x00-\x08\x0B\x0C\x0E-\x1F\x7F]/u', '', $v);
      } elseif (is_array($v)) {
        foreach ($v as &$vv) $normalize($vv);
      } elseif (is_object($v)) {
        foreach ($v as $k => $vv) $normalize($v->$k);
      }
    };
    $copy = $data;
    $normalize($copy);
    $json = json_encode($copy, JSON_UNESCAPED_UNICODE | JSON_INVALID_UTF8_SUBSTITUTE);
    if ($json === false) {
      return '{"ok":false,"error":"No se pudo codificar JSON","code":'.json_encode(json_last_error()).'}';
    }
    return $json;
  }
}

/* ===== Router ===== */
$op = $_GET['op'] ?? '';

switch ($op) {

  case 'SaveOrUpdate':
    // (dejé tu lógica original tal cual)
    $idusuario = $_POST["idusuario"] ?? '';
    $idsucursal = $_POST["idsucursal"] ?? '';

    $idcategoria     = $_POST["cboCategoria"]    ?? '';
    $idunidad_medida = $_POST["cboUnidadMedida"] ?? '';
    $nombre          = $_POST["txtNombre"]       ?? '';
    $descripcion     = $_POST["txtDescripcion"]  ?? '';
    $venta           = $_POST["venta"]           ?? '';
    $costo           = $_POST["costo"]           ?? '';
    $imagen          = $_FILES["imagenArt"]["tmp_name"] ?? '';
    $ruta            = $_FILES["imagenArt"]["name"]     ?? '';

    if ($imagen && $ruta && @move_uploaded_file($imagen, __DIR__."/../Files/Articulo/".$ruta)) {
      if (empty($_POST["txtIdArticulo"])) {
        echo $objArticulo->Registrar($idcategoria,$idunidad_medida,$nombre,$descripcion,$venta,$costo,"Files/Articulo/".$ruta)
          ? "Articulo Registrado" : "Articulo no ha podido ser registado.";
      } else {
        $idarticulo = $_POST["txtIdArticulo"];
        echo $objArticulo->Modificar($idarticulo,$idcategoria,$idunidad_medida,$nombre,$descripcion,$venta,$costo,"Files/Articulo/".$ruta)
          ? "Informacion del Articulo ha sido actualizada" : "Informacion del Articulo no ha podido ser actualizada.";
      }
    } else {
      $ruta_img = $_POST["txtRutaImgArt"] ?? '';
      if (empty($_POST["txtIdArticulo"])) {
        echo $objArticulo->Registrar($idcategoria,$idunidad_medida,$nombre,$descripcion,$venta,$costo,$ruta_img)
          ? "Articulo Registrado" : "Articulo no ha podido ser registado.";
      } else {
        $idarticulo = $_POST["txtIdArticulo"];
        echo $objArticulo->Modificar($idarticulo,$idcategoria,$idunidad_medida,$nombre,$descripcion,$venta,$costo,$ruta_img)
          ? "Informacion del Articulo ha sido actualizada" : "Informacion del Articulo no ha podido ser actualizada.";
      }
    }
    break;

  case 'delete':
    $id = $_POST["id"] ?? '';
    $result = $objArticulo->Eliminar($id);
    echo $result ? "Eliminado Exitosamente" : "No fue Eliminado";
    break;

  case 'list':
    // SIEMPRE JSON UTF-8
    header('Content-Type: application/json; charset=UTF-8');

    // Evita notices si no venían en POST
    $idusuario  = $_GET['idusuario']  ?? $_POST['idusuario']  ?? '';
    $idsucursal = $_GET['idsucursal'] ?? $_POST['idsucursal'] ?? '';

    $rs = $objArticulo->Listar($idusuario, $idsucursal);
    $data = [];
    $i = 0;

    while ($reg = $rs->fetch_object()) {
      $id    = (int)($reg->id ?? 0);
      $fdoc  = (string)($reg->fecha_documento ?? '');
      $desc  = (string)($reg->descripcion ?? '');
      $comm  = (string)($reg->comentario ?? '');
      $raw   = trim((string)($reg->imagen1 ?? ''));
      $tipo  = (string)($reg->tipo ?? '');
      $idreq = (string)($reg->idrequerimiento ?? '');

      $hasVal  = ($raw !== '');
      $isDrive = is_drive_link($raw);
      $ext     = $hasVal ? file_ext($raw) : '';

      $editLink = '<a href="modificar_imagen1_formatos.php?id='.$id.'">Editar</a><br>';

      // Bloque visual del archivo
      if (!$hasVal) {
        $tile = '
          <div class="img-clickable1"
               data-imagen="Files/sin_imagen.png"
               data-id="'.$id.'"
               style="display:inline-block; cursor:pointer; width:90px; height:90px; border:1px solid #ccc; position:relative; overflow:hidden;">
            <img src="Files/sin_imagen.png" style="width:100%; height:auto;">
          </div>';
        $btns = '';
      } elseif ($isDrive) {
        $safe = esc($raw);
        $tile = '
          <div style="display:inline-block; width:90px; height:90px; border:1px solid #ccc; position:relative; overflow:hidden; background:#f5f5f5; text-align:center; line-height:90px; font-size:11px; color:#333;">
            <i class="fa fa-google"></i> Drive
          </div>';
        $btns = '
          <div style="margin-top:6px;">
            <a class="btn btn-xs btn-info" href="'.$safe.'" rel="noopener"><i class="fa fa-external-link"></i> Open</a>
          </div>';
      } else {
        $safe = esc($raw);
        if ($ext === 'pdf') {
          $tile = '
            <div class="img-clickable1"
                 data-imagen="'.$safe.'"
                 data-id="'.$id.'"
                 style="display:inline-block; cursor:pointer; width:90px; height:90px; border:1px solid #ccc; position:relative; overflow:hidden;">
              <embed src="'.$safe.'" type="application/pdf" width="90" height="90" style="object-fit:cover;">
              <div style="position:absolute; bottom:4px; left:50%; transform:translateX(-50%); background:rgba(0,0,0,0.6); color:#fff; font-size:10px; padding:2px 4px; border-radius:4px; font-weight:bold; width:100%; text-align:center; cursor:pointer;">Ver PDF</div>
            </div>';
          $btns = '
            <div style="margin-top:6px;">
              <a class="btn btn-xs btn-info" href="'.$safe.'" rel="noopener"><i class="fa fa-external-link"></i> Open</a>
              <a class="btn btn-xs btn-default" href="'.$safe.'" download><i class="fa fa-download"></i> Download</a>
            </div>';
        } elseif (in_array($ext, ['png','jpg','jpeg','gif','webp'])) {
          $tile = '
            <div class="img-clickable1"
                 data-imagen="'.$safe.'"
                 data-id="'.$id.'"
                 style="display:inline-block; cursor:pointer; width:90px; height:90px; border:1px solid #ccc; position:relative; overflow:hidden;">
              <img src="'.$safe.'" style="width:100%; height:auto;">
            </div>';
          $btns = '
            <div style="margin-top:6px;">
              <a class="btn btn-xs btn-default" href="'.$safe.'" download><i class="fa fa-download"></i> Download</a>
            </div>';
        } else {
          $tile = '
            <div class="img-clickable1"
                 data-imagen="'.$safe.'"
                 data-id="'.$id.'"
                 style="display:inline-block; cursor:pointer; width:90px; height:90px; border:1px solid #ccc; position:relative; overflow:hidden; background:#fafafa; text-align:center;">
              <div style="font-size:28px; color:#666; margin-top:18px;"><i class="fa fa-file-o"></i></div>
              <div style="position:absolute; bottom:2px; left:0; right:0; font-size:10px; color:#555;">.'.esc($ext).'</div>
            </div>';
          $btns = '
            <div style="margin-top:6px;">
              <a class="btn btn-xs btn-default" href="'.$safe.'" download><i class="fa fa-download"></i> Download</a>
            </div>';
        }
      }

      $actions =
        '<a href="edit_formatos.php?id='.$id.'&tipo='.esc($tipo).'&idrequerimiento='.esc($idreq).'" class="btn btn-warning" data-toggle="tooltip" title="Edit"><i class="fa fa-edit"></i></a> '.
        '<a href="add_eliminar_formatos.php?id='.$id.'&tipo='.esc($tipo).'&idrequerimiento='.esc($idreq).'" class="btn btn-danger" data-toggle="tooltip" title="Delete" onclick="return confirm_delete(\'Are you sure you want to delete this record?\');"><i class="fa fa-trash"></i></a>';

      $data[] = [
        "id" => $i,
        "1"  => $id,
        "2"  => esc($fdoc),
        "5"  => esc($desc),
        "6"  => esc($comm),
        "7"  => $editLink . $tile . $btns,
        "8"  => $actions
      ];
      $i++;
    }

    echo json_utf8_strict([
      "sEcho" => 1,
      "aaData" => $data,
      "ok" => true
    ]);
    break;

  case 'listArtElegir':
    $rs = $objArticulo->Listar();
    $data = [];
    $i = 1;
    while ($reg = $rs->fetch_object()) {
      $data[] = [
        "0"=>'<button type="button" class="btn btn-warning" data-toggle="tooltip" title="Agregar al detalle" onclick="Agregar('.esc($reg->idarticulo).',\''.esc($reg->nombre).'\',\''.esc($reg->codigo2).'\',\''.esc($reg->costo).'\',\''.esc($reg->venta).'\')" name="optArtBusqueda[]" data-nombre="'.esc($reg->nombre).'" id="'.esc($reg->idarticulo).'" value="'.esc($reg->idarticulo).'" codigo="'.esc($reg->codigo2).'" costo="'.esc($reg->costo).'" venta="'.esc($reg->venta).'" ><i class="fa fa-check"></i></button>',
        "1"=>$i,
        "2"=>esc($reg->categoria ?? ''),
        "3"=>esc($reg->unidadMedida ?? ''),
        "4"=>esc($reg->nombre ?? ''),
        "5"=>esc($reg->descripcion ?? ''),
        "6"=>'<img width="100" height="100" src="./'.esc($reg->imagen).'">',
        "7"=>esc($reg->codigo2 ?? ''),
        "8"=>esc($reg->costo ?? ''),
        "9"=>esc($reg->venta ?? ''),
      ];
      $i++;
    }
    header('Content-Type: application/json; charset=UTF-8');
    echo json_utf8_strict([
      "sEcho" => 1,
      "iTotalRecords" => count($data),
      "iTotalDisplayRecords" => count($data),
      "aaData" => $data,
      "ok" => true
    ]);
    break;

  case 'listCategoria':
    require_once __DIR__ . '/../model/Categoria.php';
    $objCategoria = new Categoria();
    $rs = $objCategoria->Listar();
    while ($reg = $rs->fetch_object()) {
      echo '<option value="'.esc($reg->idcategoria).'">'.esc($reg->nombre).'</option>';
    }
    break;

  case 'listUM':
    require_once __DIR__ . '/../model/Categoria.php';
    $objCategoria = new Categoria();
    $rs = $objCategoria->ListarUM();
    while ($reg = $rs->fetch_object()) {
      echo '<option value="'.esc($reg->idunidad_medida).'">'.esc($reg->nombre).'</option>';
    }
    break;

  default:
    header('Content-Type: application/json; charset=UTF-8');
    echo json_utf8_strict(['ok'=>false,'error'=>'Operación no especificada (op)']);
    break;
}
