<?php
// ajax/consulta_vacaciones_extra.php
declare(strict_types=1);
$lang = isset($_SESSION['lang']) ? $_SESSION['lang'] : 'en'; // 'es' | 'en'
if (session_status() === PHP_SESSION_NONE) session_start();

// Desactiva display de errores en produccin si quieres
ini_set('display_errors','0');
error_reporting(E_ALL);

/* ========= Conexin ========= */
require_once __DIR__.'/../dbcon.php';   // ajusta la ruta si cambia
if (isset($con) && $con instanceof mysqli) {
  mysqli_set_charset($con, 'utf8mb4'); // fuerza utf8mb4 en la conexin
}
require_once __DIR__."/../model/consulta_empleadosplanilla.php";
$objArticulo = new Articulo();

/* ========= Helpers de respaldo ========= */
if (!function_exists('esc')) {
  function esc($v){
    $s = (string)$v;
    if (!mb_detect_encoding($s, 'UTF-8', true)) {
      $s = @mb_convert_encoding($s, 'UTF-8', 'Windows-1252,ISO-8859-1,UTF-8') ?: $s;
    }
    return htmlspecialchars($s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
  }
}

/* ========= Helper JSON anti-tildes / bytes raros ========= */
/**
 * Codifica a JSON en UTF-8:
 *  - Conserva tildes/09 (JSON_UNESCAPED_UNICODE)
 *  - Sustituye bytes invlidos sin romper el JSON (JSON_INVALID_UTF8_SUBSTITUTE)
 *  - Escapa caracteres de control e intenta devolver siempre una cadena vlida
 */
function json_utf8_strict($data): string {
  // Normaliza strings recursivamente a UTF-8
  $normalize = function (&$v) use (&$normalize) {
    if (is_string($v)) {
      // Si no es UTF-8 vlido, intenta convertir; si falla, lo deja y JSON lo sustituir
      if (!mb_detect_encoding($v, 'UTF-8', true)) {
        $v = @mb_convert_encoding($v, 'UTF-8', 'auto') ?: $v;
      }
      // Elimina controles no imprimibles (excepto \t \n \r)
      $v = preg_replace('/[\x00-\x08\x0B\x0C\x0E-\x1F\x7F]/u', '', $v);
    } elseif (is_array($v)) {
      foreach ($v as &$vv) $normalize($vv);
    } elseif (is_object($v)) {
      foreach ($v as $k => $vv) $normalize($v->$k);
    }
  };
  $copy = $data;
  $normalize($copy);

  $json = json_encode(
    $copy,
    JSON_UNESCAPED_UNICODE | JSON_INVALID_UTF8_SUBSTITUTE
  );
  if ($json === false) {
    return '{"ok":false,"error":"No se pudo codificar JSON","code":'.json_encode(json_last_error()).'}';
  }
  return $json;
}

/* ========= i18n local a este AJAX ========= */
$lang = isset($_SESSION['lang']) ? $_SESSION['lang'] : 'en';
$L = [];
$__file = __DIR__ . '/../includes/lang/' . $lang . '.php';
if (is_file($__file)) {
  $tmp = require $__file;           // debe retornar array
  if (is_array($tmp)) { $L = $tmp; }
}
// Helper local: $tr('clave', ['var'=>'valor'])
$tr = function(string $key, array $vars = []) use (&$L): string {
  $s = isset($L[$key]) ? (string)$L[$key] : $key;
  if ($vars) {
    foreach ($vars as $k => $v) { $s = str_replace('{'.$k.'}', (string)$v, $s); }
  }
  return $s;
};

/* ========= Router ========= */
$op = $_GET["op"] ?? '';

switch ($op) {

  // ------------------------------------------
  // DIAGN07STICO UTF-8  op=utf8_diag
  // ------------------------------------------
  case 'utf8_diag':
    header('Content-Type: application/json; charset=UTF-8');

    $literal = "09e09e09e";

    $hex_literal = strtoupper(implode('', array_map(
      fn($c)=>str_pad(dechex(ord($c)),2,'0',STR_PAD_LEFT),
      str_split($literal)
    )));

    $mysql_vars = [];
    if (isset($con) && $con instanceof mysqli) {
      foreach (["character_set_%","collation_%","time_zone"] as $like) {
        if ($rs = $con->query("SHOW VARIABLES LIKE '".$con->real_escape_string($like)."'")) {
          while ($row = $rs->fetch_assoc()) $mysql_vars[$row['Variable_name']] = $row['Value'];
          $rs->free();
        }
      }
    }

    $probe = [
      'sEcho' => 1,
      'iTotalRecords' => 3,
      'iTotalDisplayRecords' => 3,
      'aaData' => [
        ['col' => 'Texto visible', 'val' => $literal],
        ['col' => 'En atributo title', 'val' => '<div title="09e09e09e">hover</div>'],
        ['col' => 'Escapado HTML', 'val' => esc($literal)],
      ],
    ];

    echo json_utf8_strict([
      'ok' => true,
      'php' => [
        'default_charset' => ini_get('default_charset'),
        'mb_internal'     => function_exists('mb_internal_encoding') ? @mb_internal_encoding() : null,
        'mb_http_output'  => function_exists('mb_http_output') ? @mb_http_output() : null,
      ],
      'mysql' => $mysql_vars,
      'literal' => $literal,
      'literal_hex' => $hex_literal,
      'datatable_probe' => $probe,
    ]);
    exit;

  // ------------------------------------------
  // SAVE / UPDATE
  // ------------------------------------------
  case 'SaveOrUpdate':
    $idusuario  = $_POST['idusuario']  ?? '';
    $idsucursal = $_POST['idsucursal'] ?? '';

    $idcategoria     = $_POST['cboCategoria']    ?? '';
    $idunidad_medida = $_POST['cboUnidadMedida'] ?? '';
    $nombre          = $_POST['txtNombre']       ?? '';
    $descripcion     = $_POST['txtDescripcion']  ?? '';
    $venta           = $_POST['venta']           ?? '';
    $costo           = $_POST['costo']           ?? '';
    $imagenTmp       = $_FILES['imagenArt']['tmp_name'] ?? '';
    $rutaNombre      = $_FILES['imagenArt']['name']     ?? '';

    // Guardado de archivo (si hay)
    $dest = $_POST['txtRutaImgArt'] ?? '';
    if ($imagenTmp && $rutaNombre) {
      $destAbs = __DIR__ . '/../Files/Articulo/' . $rutaNombre;
      if (@move_uploaded_file($imagenTmp, $destAbs)) {
        $dest = 'Files/Articulo/' . $rutaNombre;
      }
    }

    if (empty($_POST['txtIdArticulo'])) {
      $ok = $objArticulo->Registrar($idcategoria, $idunidad_medida, $nombre, $descripcion, $venta, $costo, $dest);
      echo $ok ? 'Articulo Registrado' : 'Articulo no ha podido ser registado.';
    } else {
      $idarticulo = $_POST['txtIdArticulo'];
      $ok = $objArticulo->Modificar($idarticulo, $idcategoria, $idunidad_medida, $nombre, $descripcion, $venta, $costo, $dest);
      echo $ok ? 'Informacion del Articulo ha sido actualizada' : 'Informacion del Articulo no ha podido ser actualizada.';
    }
    break;

  // ------------------------------------------
  // DELETE
  // ------------------------------------------
  case 'delete':
    $id = $_POST['id'] ?? '';
    $result = $objArticulo->Eliminar($id);
    echo $result ? 'Eliminado Exitosamente' : 'No fue Eliminado';
    break;

  // ------------------------------------------
  // LIST (JSON)
  // ------------------------------------------
  case 'list':
    // Siempre JSON UTF-8
    header('Content-Type: application/json; charset=UTF-8');

    $idusuario  = $_GET['idusuario']  ?? $_POST['idusuario']  ?? '';
    $idsucursal = $_GET['idsucursal'] ?? $_POST['idsucursal'] ?? '';

    $query_Tipo = $objArticulo->Listar($idusuario, $idsucursal);
    if (!$query_Tipo) {
      echo json_utf8_strict(['ok'=>false,'error'=>'Listar() devolvi null/false. Revisa el modelo o la consulta.']);
      exit;
    }

    $data = [];
    $i = 1;

    while ($reg = $query_Tipo->fetch_object()) {
      // Fechas
      $year = (int)($reg->year_ingreso ?? 0);
      $mes  = (int)($reg->mes_ingreso  ?? 0);
      $dia  = (int)($reg->dia_ingreso  ?? 0);
      try {
        $fecha_ingreso = new DateTime(sprintf('%04d-%02d-%02d', max(1,$year), max(1,$mes), max(1,$dia)));
      } catch (Throwable $e) {
        $fecha_ingreso = new DateTime('1970-01-01');
      }
      $fecha_ingreso->setTime(0, 0, 0);
      $fecha_actual = (new DateTime())->setTime(0, 0, 0);
      $dias_trabajados = $fecha_ingreso->diff($fecha_actual)->days;

      // Clculos
      $dias_inscapacidad = (float)($reg->dias_inscapacidad ?? 0);
      $sumar             = (float)($reg->sumar ?? 0);
      $restar            = (float)($reg->restar ?? 0);
      $gastados          = (float)($reg->dias_gastados ?? 0);
      $solicitados       = (float)($reg->dias_solicitados ?? 0);

      $dias_vacaciones_base = round($dias_trabajados / 35.0, 6);
      $dias_ins             = round($dias_inscapacidad / 35.0, 6);
      $total_vacaciones     = $dias_vacaciones_base + $sumar - $restar;

      $saldo_calc = $total_vacaciones + $gastados - $dias_ins - $solicitados;
      $dias_restantes = (float)max(0, $saldo_calc);

      // ====== Col 2: tooltip con datos del empleado (traducido) ======
      $titleNombre =
          $tr('ajax.col2.tooltip.title') . "\n\n" .
          $tr('ajax.col2.tooltip.full_name')   . ' = ' . (string)($reg->nombre_completo ?? '') . "\n\n" .
          $tr('ajax.col2.tooltip.id_card')     . ' = ' . (string)($reg->cedula ?? '')          . "\n\n" .
          $tr('ajax.col2.tooltip.category')    . ' = ' . (string)($reg->categoria ?? '')       . "\n\n" .
          $tr('ajax.col2.tooltip.nationality') . ' = ' . (string)($reg->nacionalidad ?? '')    . "\n\n" .
          $tr('ajax.col2.tooltip.emergency')   . ' = ' . (string)($reg->numero_emergencia ?? ''). "\n\n" .
          $tr('ajax.col2.tooltip.marital')     . ' = ' . (string)($reg->estado_civil ?? '')    . "\n\n" .
          $tr('ajax.col2.tooltip.entry')       . ' = ' . $fecha_ingreso->format('Y-m-d');

      $col2 =
        '<div style="text-align:left; color:blue;" data-toggle="tooltip" data-html="true" '.
        'title="'.esc($titleNombre).'">'.
        '<a href="detalle_empleadosplanilla.php?id='.esc($reg->id).'">'.esc($reg->nombre_completo ?? '').'</a>'.
        '</div>';

      // ====== Col 10: tooltip vacaciones (traducido) ======
      $titleVac =
          $tr('ajax.vac.title', ['from'=>$fecha_ingreso->format('Y-m-d')]) . "\n\n" .
          $tr('ajax.vac.accrual') . "\n" .
          $dias_trabajados.' '.$tr('ajax.days').' / 35 = '.$dias_vacaciones_base . "\n\n" .
          $tr('ajax.vac.adjustments') . "\n" .
          $tr('ajax.vac.add').' = '.$sumar . "\n" .
          $tr('ajax.vac.sub').' = '.$restar . "\n\n" .
          $tr('ajax.vac.total_base_adj').' = '.$total_vacaciones . "\n" .
          $tr('ajax.vac.round_down').' = '.floor($total_vacaciones) . "\n\n" .
          $tr('ajax.vac.why35');

      $col10 = '<div style="text-align:center; color:blue;" data-toggle="tooltip" data-html="true" '.
               'title="'.esc($titleVac).'">'.
               floor($total_vacaciones).
               '</div>';

      // ====== Col 11: das adicionales (traducido) ======
      $titleAdic =
          $tr('ajax.addl.title')."\n\n".
          $tr('ajax.addl.holidays').' = '.$total_vacaciones."\n".
          $tr('ajax.addl.additional').' = '.$gastados."\n".
          $tr('ajax.addl.total').' = '.($total_vacaciones + $gastados);

      $col11 = '<div style="text-align:center; color:green;" data-toggle="tooltip" data-html="true" '.
               'title="'.esc($titleAdic).'">'.
               esc($reg->dias_gastados ?? '').
               '</div>';

      // ====== Col 12: incapacidad (traducido) ======
      $titleIns =
          $tr('ajax.disability.title')."\n\n".
          $tr('ajax.disability.days').' = '.floor($dias_inscapacidad)."\n".
          floor($dias_inscapacidad).' '.$tr('ajax.days').' / 35 = '.$dias_ins."\n\n".
          $tr('ajax.disability.convert');

      $col12 = '<div style="text-align:center; color:red;" data-toggle="tooltip" data-html="true" '.
               'title="'.esc($titleIns).'">'.
               number_format((float)$dias_ins, 2, '.', '').' ('.floor($dias_inscapacidad).' '.$tr('ajax.days').')'.
               '</div>';

      // ====== Col 13: usados (traducido) ======
      $titleUsed = $tr('ajax.used.title')."\n\n".
                   $tr('ajax.used.used').' = '.$solicitados;

      $col13 = '<div style="text-align:center; color:red;" data-toggle="tooltip" data-html="true" '.
               'title="'.esc($titleUsed).'">'.
               esc($reg->dias_solicitados ?? '').
               '</div>';

      // ====== Col 14: saldo (traducido) ======
      $titleSaldo =
          $tr('ajax.balance.title')."\n\n".
          $tr('ajax.addl.holidays').' = '.$total_vacaciones."\n".
          $tr('ajax.balance.additional').' = '.$gastados."\n".
          $tr('ajax.balance.disability').' = '.$dias_ins."\n".
          $tr('ajax.used.used').' = '.$solicitados."\n\n".
          $tr('ajax.balance.formula')."\n".
          ' = '.$total_vacaciones.' + '.$gastados.' - '.$dias_ins.' - '.$solicitados."\n\n".
          $tr('ajax.vac.total').' = '.$saldo_calc."\n".
          $tr('ajax.vac.round_down').' = '.floor($saldo_calc);

      $col14 = '<div style="text-align:center; font-weight:bold;" data-toggle="tooltip" data-html="true" '.
               'title="'.esc($titleSaldo).'">'.
               floor($dias_restantes).
               '</div>';

      // ====== Col 15: imagen/pdf (badge traducido) ======
      $img1  = (string)($reg->imagen1 ?? '');
      $isPdf = (strtolower(pathinfo($img1, PATHINFO_EXTENSION)) === 'pdf');
      $imgHtml = $img1 !== ''
        ? ($isPdf
            ? '<embed src="'.esc($img1).'" type="application/pdf" width="90" height="90" style="object-fit:cover;">'
            : '<img src="'.esc($img1).'" style="width:100%; height:auto;">'
          )
        : '<img src="Files/sin_imagen.png" style="width:100%; height:auto;">';

      $pdfBadge = ($img1 !== '' && $isPdf)
        ? '<div style="position:absolute; bottom:4px; left:50%; transform:translateX(-50%); background:rgba(0,0,0,0.6); color:#fff; font-size:10px; padding:2px 4px; border-radius:4px; font-weight:bold; width:100%; text-align:center; cursor:pointer;">'.esc($tr('ajax.badge.pdf')).'</div>'
        : '';

      $col15 =
        '<a href="modificar_imagen1_empleadosplanilla.php?id='.esc($reg->id).'">'.esc($tr('ajax.btn.edit')).'</a><br>'.
        '<div class="img-clickable1" '.
        'data-imagen="'.esc($img1 !== '' ? $img1 : 'Files/sin_imagen.png').'" '.
        'data-id="'.esc($reg->id).'" '.
        'style="display:inline-block; cursor:pointer; width:90px; height:90px; border:1px solid #ccc; position:relative; overflow:hidden;">'.
          $imgHtml . $pdfBadge .
        '</div>';

      // ====== Col 16: botones (traducidos) ======
      $col16 =
        '<a href="detalle_empleadosplanilla.php?id='.esc($reg->id).'&tipo='.esc($reg->tipo ?? '').'&idrequerimiento='.esc($reg->idrequerimiento ?? '').'" class="btn btn-warning" data-toggle="tooltip" title="'.esc($tr('ajax.btn.edit')).'"><i class="fa fa-edit"></i></a> '.
        '<a href="add_eliminar_empleadosplanilla.php?id='.esc($reg->id).'&tipo='.esc($reg->tipo ?? '').'&idrequerimiento='.esc($reg->idrequerimiento ?? '').'" class="btn btn-danger" data-toggle="tooltip" title="'.esc($tr('ajax.btn.delete')).'" onclick="return confirm_delete(\''.esc($tr('ajax.confirm.delete')).'\');"><i class="fa fa-trash"></i></a>';

      // (Prueba e09es)
      $X_test = 'hola 09e 09e09e09e';

      $data[] = [
        'id'  => $i,
        '1'   => (string)($reg->id ?? ''),
        '2'   => $col2,
        '3'   => esc($reg->categoria ?? ''),
        '4'   => esc($reg->nacionalidad ?? ''),
        '5'   => esc($reg->fecha_nacimiento ?? ''),
        '6'   => esc($reg->numero_emergencia ?? ''),
        '7'   => esc($reg->estado_civil ?? ''), 
        '8'   => esc($reg->cedula ?? ''),
        '9'   => $fecha_ingreso->format('Y-m-d'),
        '10'  => $col10,
        '11'  => $col11,
        '12'  => $col12,
        '13'  => $col13,
        '14'  => $col14,
        '15'  => $col15,
        '16'  => $col16,
        'X_test' => esc($X_test),
      ];
      $i++;
    }

    echo json_utf8_strict([
      "sEcho" => 1,
      "iTotalRecords"        => count($data),
      "iTotalDisplayRecords" => count($data),
      "aaData"               => $data,
      "ok"                   => true
    ]);
    break;

  // ------------------------------------------
  // LISTAR ART01CULOS PARA ELEGIR
  // ------------------------------------------
  case 'listArtElegir':
    header('Content-Type: application/json; charset=UTF-8');

    $rs = $objArticulo->Listar();
    $data = [];
    $i = 1;

    while ($reg = $rs->fetch_object()) {
      $btn =
        '<button type="button" class="btn btn-warning" data-toggle="tooltip" title="Agregar al detalle" '.
        'onclick="Agregar('.esc($reg->idarticulo).',\''.esc($reg->nombre).'\',\''.esc($reg->codigo2).'\',\''.esc($reg->costo).'\',\''.esc($reg->venta).'\')" '.
        'name="optArtBusqueda[]" data-nombre="'.esc($reg->nombre).'" id="'.esc($reg->idarticulo).'" '.
        'value="'.esc($reg->idarticulo).'" codigo="'.esc($reg->codigo2).'" costo="'.esc($reg->costo).'" venta="'.esc($reg->venta).'">'.
        '<i class="fa fa-check"></i> </button>';

      $img = '<img width="100" height="100" src="./'.esc($reg->imagen).'">';

      $data[] = [
        '0' => $btn,
        '1' => $i,
        '2' => esc($reg->categoria ?? ''),
        '3' => esc($reg->unidadMedida ?? ''),
        '4' => esc($reg->nombre ?? ''),
        '5' => esc($reg->descripcion ?? ''),
        '6' => $img,
        '7' => esc($reg->codigo2 ?? ''),
        '8' => esc($reg->costo ?? ''),
        '9' => esc($reg->venta ?? ''),
      ];
      $i++;
    }

    echo json_utf8_strict([
      'sEcho' => 1,
      'iTotalRecords'        => count($data),
      'iTotalDisplayRecords' => count($data),
      'aaData'               => $data,
      'ok'                   => true,
    ]);
    break;

  // ------------------------------------------
  // CATEGOR01AS (HTML)
  // ------------------------------------------
  case 'listCategoria':
    require_once __DIR__ . '/../model/Categoria.php';
    $objCategoria = new Categoria();
    $rs = $objCategoria->Listar();
    while ($reg = $rs->fetch_object()) {
      echo '<option value="'.esc($reg->idcategoria).'">'.esc($reg->nombre).'</option>';
    }
    break;

  // ------------------------------------------
  // UNIDADES DE MEDIDA (HTML)
  // ------------------------------------------
  case 'listUM':
    require_once __DIR__ . '/../model/Categoria.php';
    $objCategoria = new Categoria();
    $rs = $objCategoria->ListarUM();
    while ($reg = $rs->fetch_object()) {
      echo '<option value="'.esc($reg->idunidad_medida).'">'.esc($reg->nombre).'</option>';
    }
    break;

  // ------------------------------------------
  // DEFAULT
  // ------------------------------------------
  default:
    header('Content-Type: application/json; charset=UTF-8');
    echo json_utf8_strict(['ok'=>false, 'error'=>'Operacin no especificada (op)']);
    break;
}

