<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once "../dbcon.php";
header('Content-Type: application/json; charset=utf-8');

$op = $_GET["op"] ?? '';

switch ($op) {

  // ===============================
  // LISTAR EMPLEADOS
  // ===============================
  case 'listar':

    $data = [];
    $i = 1;

    $sql = "
      SELECT *
      FROM empleado
      WHERE tipo_usuario = 'Colegio'
      ORDER BY idempleado DESC
    ";

    $result = mysqli_query($con, $sql);

    if (!$result) {
      echo json_encode([
        "sEcho" => 1,
        "iTotalRecords" => 0,
        "iTotalDisplayRecords" => 0,
        "aaData" => [],
        "error" => mysqli_error($con)
      ]);
      exit;
    }

    while ($row = mysqli_fetch_assoc($result)) {

      $foto = !empty($row['foto'])
        ? '<img src="./'.$row['foto'].'" width="40" height="40" class="img-circle img-clickable1" data-imagen="./'.$row['foto'].'">'
        : '<img src="./Files/sin_imagen.png" width="40" height="40" class="img-circle">';

      $data[] = [
        "0" => $i++,
        "1" => $row['idempleado'],
        "2" => $foto,
        "3" => $row['nombre'],
        "4" => $row['apellidos'],
        "5" => $row['email'],
        "6" => $row['telefono'],
        "7" => '
          <a href="editar_empleado.php?id='.$row['idempleado'].'" class="btn btn-warning btn-xs">
            <i class="fa fa-pencil"></i>
          </a>
          <a href="eliminar_empleado.php?id='.$row['idempleado'].'" class="btn btn-danger btn-xs" onclick="eliminarEmpleado('.$row['idempleado'].')">
            <i class="fa fa-trash"></i>
          </a>
        '
      ];
    }

    echo json_encode([
      "sEcho" => 1,
      "iTotalRecords" => count($data),
      "iTotalDisplayRecords" => count($data),
      "aaData" => $data
    ]);
    break;

  // ===============================
  // ELIMINAR EMPLEADO
  // ===============================
  case 'delete':

    $idempleado = intval($_POST['idempleado'] ?? 0);

    if ($idempleado <= 0) {
      echo json_encode(["error" => "ID inválido"]);
      exit;
    }

    // 1️⃣ eliminar usuario asociado
    mysqli_query(
      $con,
      "DELETE FROM usuario WHERE idempleado = $idempleado"
    );

    // 2️⃣ eliminar empleado
    if (mysqli_query(
      $con,
      "DELETE FROM empleado WHERE idempleado = $idempleado"
    )) {
      echo json_encode(["success" => "Empleado eliminado correctamente"]);
    } else {
      echo json_encode(["error" => mysqli_error($con)]);
    }

    break;

  default:
    echo json_encode(["error" => "Operación no válida"]);
    break;
}
