<?php
// ajax/consulta_documentosgenerales_empleadosplanilla.php
// UTF-8 robusto para DataTables / PHP 8.1
declare(strict_types=1);

if (session_status() === PHP_SESSION_NONE) session_start();

ini_set('display_errors','0');
error_reporting(E_ALL);

/* ========= Conexión ========= */
require_once __DIR__.'/../dbcon.php';
if (isset($con) && $con instanceof mysqli) {
  mysqli_set_charset($con, 'utf8mb4');
}

require_once __DIR__ . "/../model/consulta_documentosgenerales_empleadosplanilla.php";
$objArticulo = new Articulo();

/* ========= Helpers UTF-8 ========= */
/** Normaliza a UTF-8 y limpia controles no imprimibles */
if (!function_exists('norm')) {
  function norm($v): string {
    $s = (string)$v;
    if (!mb_detect_encoding($s, 'UTF-8', true)) {
      $s = @mb_convert_encoding($s, 'UTF-8', 'Windows-1252,ISO-8859-1,UTF-8') ?: $s;
    }
    return preg_replace('/[\x00-\x08\x0B\x0C\x0E-\x1F\x7F]/u', '', $s);
  }
}
/** Escapado HTML seguro + sustitución de bytes inválidos */
if (!function_exists('esc')) {
  function esc($v): string {
    return htmlspecialchars(norm($v), ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
  }
}
/** JSON que conserva tildes/ñ y sustituye bytes inválidos */
if (!function_exists('json_utf8_strict')) {
  function json_utf8_strict($data): string {
    $normalize = function (&$v) use (&$normalize) {
      if (is_string($v)) {
        $v = norm($v);
      } elseif (is_array($v)) {
        foreach ($v as &$vv) $normalize($vv);
      } elseif (is_object($v)) {
        foreach ($v as $k => &$vv) $normalize($vv);
      }
    };
    $copy = $data; $normalize($copy);
    return json_encode($copy, JSON_UNESCAPED_UNICODE | JSON_INVALID_UTF8_SUBSTITUTE);
  }
}

/* ========= Router ========= */
$op = $_GET["op"] ?? '';

switch ($op) {

  case 'SaveOrUpdate':
    $idusuario       = $_POST["idusuario"]       ?? '';
    $idsucursal      = $_POST["idsucursal"]      ?? '';
    $idcategoria     = $_POST["cboCategoria"]    ?? '';
    $idunidad_medida = $_POST["cboUnidadMedida"] ?? '';
    $nombre          = $_POST["txtNombre"]       ?? '';
    $descripcion     = $_POST["txtDescripcion"]  ?? '';
    $venta           = $_POST["venta"]           ?? '';
    $costo           = $_POST["costo"]           ?? '';
    $imagen          = $_FILES["imagenArt"]["tmp_name"] ?? '';
    $ruta            = $_FILES["imagenArt"]["name"]     ?? '';

    if ($imagen && $ruta && @move_uploaded_file($imagen, "../Files/Articulo/".$ruta)) {
      if (empty($_POST["txtIdArticulo"])) {
        echo $objArticulo->Registrar($idcategoria,$idunidad_medida,$nombre,$descripcion,$venta,$costo,"Files/Articulo/".$ruta)
          ? "Articulo Registrado" : "Articulo no ha podido ser registado.";
      } else {
        $idarticulo = $_POST["txtIdArticulo"];
        echo $objArticulo->Modificar($idarticulo,$idcategoria,$idunidad_medida,$nombre,$descripcion,$venta,$costo,"Files/Articulo/".$ruta)
          ? "Informacion del Articulo ha sido actualizada" : "Informacion del Articulo no ha podido ser actualizada.";
      }
    } else {
      $ruta_img = $_POST["txtRutaImgArt"] ?? '';
      if (empty($_POST["txtIdArticulo"])) {
        echo $objArticulo->Registrar($idcategoria,$idunidad_medida,$nombre,$descripcion,$venta,$costo,$ruta_img)
          ? "Articulo Registrado" : "Articulo no ha podido ser registado.";
      } else {
        $idarticulo = $_POST["txtIdArticulo"];
        echo $objArticulo->Modificar($idarticulo,$idcategoria,$idunidad_medida,$nombre,$descripcion,$venta,$costo,$ruta_img)
          ? "Informacion del Articulo ha sido actualizada" : "Informacion del Articulo no ha podido ser actualizada.";
      }
    }
    break;

  case "delete":
    $id = $_POST["id"] ?? '';
    echo $objArticulo->Eliminar($id) ? "Eliminado Exitosamente" : "No fue Eliminado";
    break;

  case "list":
    header('Content-Type: application/json; charset=UTF-8');

    // Si tu modelo lo requiere:
    $idusuario  = $_GET['idusuario']  ?? $_POST['idusuario']  ?? '';
    $idsucursal = $_GET['idsucursal'] ?? $_POST['idsucursal'] ?? '';

    $rs = $objArticulo->Listar($idusuario,$idsucursal);
    $data = [];
    $i = 0;

    while ($reg = $rs->fetch_object()) {
      $id              = norm($reg->id ?? '');
      $fecha_documento = norm($reg->fecha_documento ?? '');
      $categoria       = norm($reg->categoria ?? '');
      $descripcion     = norm($reg->descripcion ?? '');
      $comentario      = norm($reg->comentario ?? '');
      $img1            = (string)($reg->imagen1 ?? '');

      $imgHtml = !empty($img1)
        ? (strtolower(pathinfo($img1, PATHINFO_EXTENSION)) === 'pdf'
            ? '<embed src="'.esc($img1).'" type="application/pdf" width="90" height="90" style="object-fit:cover;">'
            : '<img src="'.esc($img1).'" style="width:100%; height:auto;">'
          )
        : '<img src="Files/sin_imagen.png" style="width:100%; height:auto;">';

      $pdfBadge = (!empty($img1) && strtolower(pathinfo($img1, PATHINFO_EXTENSION)) === 'pdf')
        ? '<div style="position:absolute; bottom:4px; left:50%; transform:translateX(-50%); background:rgba(0,0,0,0.6); color:#fff; font-size:10px; padding:2px 4px; border-radius:4px; font-weight:bold; width:100%; text-align:center; cursor:pointer;">Ver PDF</div>'
        : '';

      $data[] = [
        "id" => $i,
        "1"  => $id,
        "2"  => $fecha_documento,
        "3"  => $categoria,
        // Ojo: tu código original no tenía "4"
        "5"  => $descripcion,
        "6"  => $comentario,
        "7"  => '
<a href="modificar_imagen1_documentosgenerales_empleadosplanilla.php?id='.esc($id).'">Editar</a><br>
<div class="img-clickable1"
     data-imagen="'.esc(!empty($img1) ? $img1 : 'Files/sin_imagen.png').'"
     data-id="'.esc($id).'"
     style="display:inline-block; cursor:pointer; width:90px; height:90px; border:1px solid #ccc; position:relative; overflow:hidden;">'
        .$imgHtml.$pdfBadge.
'</div>',
        "8"  => '<a href="edit_documentosgenerales_empleadosplanilla.php?id='.esc($id).'&tipo='.esc($reg->tipo ?? '').'&idrequerimiento='.esc($reg->idrequerimiento ?? '').'" class="btn btn-warning" data-toggle="tooltip" title="Edit"><i class="fa fa-edit"></i></a>'
              . '<a href="add_eliminar_documentosgenerales_empleadosplanilla.php?id='.esc($id).'&tipo='.esc($reg->tipo ?? '').'&idrequerimiento='.esc($reg->idrequerimiento ?? '').'" class="btn btn-danger" data-toggle="tooltip" title="Delete" onclick="return confirm_delete(\'Are you sure you want to delete this record?\');"><i class="fa fa-trash"></i></a>',
      ];
      $i++;
    }

    echo json_utf8_strict([
      "sEcho" => 1,
      "iTotalRecords"        => count($data),
      "iTotalDisplayRecords" => count($data),
      "aaData"               => $data,
      "ok"                   => true
    ]);
    break;

  case "listArtElegir":
    header('Content-Type: application/json; charset=UTF-8');

    $rs = $objArticulo->Listar();
    $data = [];
    $i = 1;
    while ($reg = $rs->fetch_object()) {
      $data[] = [
        "0" => '<button type="button" class="btn btn-warning" data-toggle="tooltip" title="Agregar al detalle" onclick="Agregar('.esc($reg->idarticulo).',\''.esc($reg->nombre).'\',\''.esc($reg->codigo2).'\',\''.esc($reg->costo).'\',\''.esc($reg->venta).'\')" name="optArtBusqueda[]" data-nombre="'.esc($reg->nombre).'" id="'.esc($reg->idarticulo).'" value="'.esc($reg->idarticulo).'" codigo="'.esc($reg->codigo2).'" costo="'.esc($reg->costo).'" venta="'.esc($reg->venta).'"><i class="fa fa-check"></i></button>',
        "1" => $i,
        "2" => esc($reg->categoria ?? ''),
        "3" => esc($reg->unidadMedida ?? ''),
        "4" => esc($reg->nombre ?? ''),
        "5" => esc($reg->descripcion ?? ''),
        "6" => '<img width="100" height="100" src="./'.esc($reg->imagen).'">',
        "7" => esc($reg->codigo2 ?? ''),
        "8" => esc($reg->costo ?? ''),
        "9" => esc($reg->venta ?? ''),
      ];
      $i++;
    }

    echo json_utf8_strict([
      "sEcho" => 1,
      "iTotalRecords"        => count($data),
      "iTotalDisplayRecords" => count($data),
      "aaData"               => $data,
      "ok"                   => true
    ]);
    break;

  case "listCategoria":
    header('Content-Type: text/html; charset=UTF-8');
    require_once __DIR__."/../model/Categoria.php";
    $objCategoria = new Categoria();
    $rs = $objCategoria->Listar();
    while ($reg = $rs->fetch_object()) {
      echo '<option value="'.esc($reg->idcategoria).'">'.esc($reg->nombre).'</option>';
    }
    break;

  case "listUM":
    header('Content-Type: text/html; charset=UTF-8');
    require_once __DIR__."/../model/Categoria.php";
    $objCategoria = new Categoria();
    $rs = $objCategoria->ListarUM();
    while ($reg = $rs->fetch_object()) {
      echo '<option value="'.esc($reg->idunidad_medida).'">'.esc($reg->nombre).'</option>';
    }
    break;
}
