<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
session_start();
header('Content-Type: application/json; charset=utf-8');
require_once __DIR__ . '/../model/Categorias.php';
$cat = new Categorias();
$op = isset($_GET['op']) ? $_GET['op'] : 'listar';

function rows_to_array($rs){ $a=array(); if($rs){ while($r=$rs->fetch_assoc()){ $a[]=$r; } } return $a; }

if ($op==='listar'){ echo json_encode(array('ok'=>true,'data'=>rows_to_array($cat->listar()))); exit; }

if ($op==='select'){
  $rs = $cat->listar(); $out=array();
  if($rs){ while($r=$rs->fetch_assoc()){ $out[] = array('id'=>(int)$r['id'], 'text'=>$r['nombre']); } }
  echo json_encode($out); exit;
}

if ($op==='guardar'){
  $id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
  $nombre = isset($_POST['nombre']) ? trim($_POST['nombre']) : '';
  $descripcion = isset($_POST['descripcion']) ? trim($_POST['descripcion']) : '';
  if ($nombre===''){ http_response_code(400); echo json_encode(array('ok'=>false,'error'=>'Nombre requerido')); exit; }
  $ok = ($id>0) ? $cat->actualizar($id,$nombre,$descripcion) : $cat->crear($nombre,$descripcion);
  echo json_encode(array('ok'=>$ok?true:false)); exit;
}

if ($op==='eliminar'){
  $id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
  if ($id<=0){ http_response_code(400); echo json_encode(array('ok'=>false,'error'=>'ID inválido')); exit; }
  list($ok,$msg) = $cat->eliminar($id);
  if (!$ok){ http_response_code(400); echo json_encode(array('ok'=>false,'error'=>$msg)); exit; }
  echo json_encode(array('ok'=>true)); exit;
}

http_response_code(400);
echo json_encode(array('ok'=>false,'error'=>'Operación no válida'));
