<?php
declare(strict_types=1);

if (session_status() === PHP_SESSION_NONE) session_start();

// Producción: no mostrar errores en pantalla (quedan en error_log)
ini_set('display_errors', '0');
error_reporting(E_ALL);

/* ========= Conexión ========= */
require_once "../model/bandeja_vacaciones.php"; // Modelo
require_once __DIR__ . "/../dbcon.php";         // Conexión mysqli en $con

// Fuerza la sesión MySQL a UTF-8 real aunque el server por defecto sea latin1
if (isset($con) && $con instanceof mysqli) {
  mysqli_set_charset($con, 'utf8mb4');
  @ $con->query("SET NAMES utf8mb4 COLLATE utf8mb4_unicode_ci");
}

// Charset base PHP (opcional pero recomendable)
if (function_exists('mb_internal_encoding')) { @mb_internal_encoding('UTF-8'); }
if (function_exists('mb_http_output'))       { @mb_http_output('UTF-8'); }

/* ========= Helpers de salida seguros ========= */

/**
 * Escapa HTML tolerando bytes inválidos.
 * - Normaliza a UTF-8 cuando vienen en ISO-8859-1/Win-1252
 * - ENT_SUBSTITUTE evita que htmlspecialchars devuelva cadena vacía en PHP 8
 */
if (!function_exists('esc')) {
  function esc($v): string {
    if (!is_string($v)) $v = (string)$v;
    if (!mb_check_encoding($v, 'UTF-8')) {
      $v = @mb_convert_encoding($v, 'UTF-8', 'UTF-8, ISO-8859-1, Windows-1252') ?: $v;
    }
    return htmlspecialchars($v, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
  }
}

/**
 * JSON robusto en UTF-8:
 * - Convierte strings no-UTF8 a UTF-8
 * - Elimina caracteres de control (salto de línea y tab permitidos)
 * - Usa JSON_INVALID_UTF8_SUBSTITUTE para no romper la respuesta
 */
if (!function_exists('json_utf8_strict')) {
  function json_utf8_strict($data): string {
    $normalize = function (&$v) use (&$normalize) {
      if (is_string($v)) {
        if (!mb_detect_encoding($v, 'UTF-8', true)) {
          $v = @mb_convert_encoding($v, 'UTF-8', 'UTF-8, ISO-8859-1, Windows-1252') ?: $v;
        }
        // quita controles no imprimibles excepto \n \t \r
        $v = preg_replace('/[\x00-\x08\x0B\x0C\x0E-\x1F\x7F]/u', '', $v);
      } elseif (is_array($v)) {
        foreach ($v as &$vv) $normalize($vv);
      } elseif (is_object($v)) {
        foreach ($v as $k => $vv) $normalize($v->$k);
      }
    };
    $copy = $data;
    $normalize($copy);

    $json = json_encode($copy, JSON_UNESCAPED_UNICODE | JSON_INVALID_UTF8_SUBSTITUTE);
    if ($json === false) {
      error_log('json_utf8_strict: '.json_last_error_msg());
      http_response_code(500);
      return '{"ok":false,"error":"json_encode failed"}';
    }
    return $json;
  }
}

/* ========= Modelo ========= */
$objArticulo = new Articulo();

/* ========= Router ========= */
$op = $_GET["op"] ?? '';

switch ($op) {

  /* ------------------------------------------
   * SAVE / UPDATE
   * ------------------------------------------ */
  case 'SaveOrUpdate':
    $idusuario  = $_POST["idusuario"]  ?? '';
    $idsucursal = $_POST["idsucursal"] ?? '';

    $idcategoria     = $_POST["cboCategoria"]    ?? '';
    $idunidad_medida = $_POST["cboUnidadMedida"] ?? '';
    $nombre          = $_POST["txtNombre"]       ?? '';
    $descripcion     = $_POST["txtDescripcion"]  ?? '';
    $venta           = $_POST["venta"]           ?? '';
    $costo           = $_POST["costo"]           ?? '';
    $imagenTmp       = $_FILES["imagenArt"]["tmp_name"] ?? '';
    $ruta            = $_FILES["imagenArt"]["name"]     ?? '';

    // Subida opcional
    if ($imagenTmp && $ruta) {
      $destAbs = __DIR__ . "/../Files/Articulo/" . $ruta;
      if (@move_uploaded_file($imagenTmp, $destAbs)) {
        $ruta_guardada = "Files/Articulo/" . $ruta;
      } else {
        $ruta_guardada = $_POST["txtRutaImgArt"] ?? '';
      }
    } else {
      $ruta_guardada = $_POST["txtRutaImgArt"] ?? '';
    }

    if (empty($_POST["txtIdArticulo"])) {
      $ok = $objArticulo->Registrar($idcategoria, $idunidad_medida, $nombre, $descripcion, $venta, $costo, $ruta_guardada);
      echo $ok ? "Articulo Registrado" : "Articulo no ha podido ser registado.";
    } else {
      $idarticulo = $_POST["txtIdArticulo"];
      $ok = $objArticulo->Modificar($idarticulo, $idcategoria, $idunidad_medida, $nombre, $descripcion, $venta, $costo, $ruta_guardada);
      echo $ok ? "Informacion del Articulo ha sido actualizada" : "Informacion del Articulo no ha podido ser actualizada.";
    }
    break;

  /* ------------------------------------------
   * DELETE
   * ------------------------------------------ */
  case "delete":
    $id = $_POST["id"] ?? '';
    $result = $objArticulo->Eliminar($id);
    echo $result ? "Eliminado Exitosamente" : "No fue Eliminado";
    break;

  /* ------------------------------------------
   * LIST (JSON para DataTables)
   * ------------------------------------------ */
  case "list":
    header('Content-Type: application/json; charset=UTF-8');

    // También acepta por POST por si llamas así desde algún lado
    $idusuario  = $_GET['idusuario']  ?? $_POST['idusuario']  ?? '';
    $idsucursal = $_GET['idsucursal'] ?? $_POST['idsucursal'] ?? '';

    $query_Tipo = $objArticulo->Listar($idusuario, $idsucursal);
    if (!$query_Tipo) {
      echo json_utf8_strict([
        "ok" => false,
        "error" => "Listar() devolvió null/false. Revisa el modelo/consulta."
      ]);
      exit;
    }

    $data = [];
    $i = 0;

    while ($reg = $query_Tipo->fetch_object()) {
      // id de formulario (si tu consulta lo trae como alias)
      $fv_id = isset($reg->idformulario) ? (int)$reg->idformulario : 0;

      $previewUrl = $fv_id
        ? "https://jportales.com/colegio/colegio10/rrhh_home/formulario_vacaciones_imprimir_sinboton.php?id=" . rawurlencode((string)$fv_id)
        : "";

      $thumbHtml =
        '<div class="doc-thumb" data-url="'.esc($previewUrl).'" data-id="'.esc((string)$fv_id).'" title="Abrir preview">'.
          '<div class="thumb-viewport">'.
            '<iframe class="thumb-frame" src="'.esc($previewUrl).'" loading="lazy" referrerpolicy="no-referrer" sandbox="allow-same-origin allow-forms allow-scripts"></iframe>'.
          '</div>'.
          '<div class="thumb-overlay">'.
            '<span class="thumb-badge">FV #'.esc((string)($reg->id ?? '')).'</span>'.
            '<button type="button" class="btn btn-xs btn-default ver-doc">Preview</button>'.
          '</div>'.
        '</div>';

      $btnScan =
        '<a href="scan_vacacion.php?id='.esc((string)($reg->id ?? '')).'" class="btn btn-success" title="Escanear / Subir PDF">'.
          '<i class="fa fa-edit"></i>'.
        '</a>';

      $data[] = [
        "id" => $i,
        "1"  => (string)($reg->id ?? ''),
        "2"  => (string)($reg->fecha_documento ?? ''),
        "3"  => (string)($reg->fecha_desde ?? ''),
        "4"  => (string)($reg->fecha_hasta ?? ''),
        "5"  => esc((string)($reg->empleado ?? '')),          // <- escapado seguro
        "6"  => esc((string)($reg->motivo ?? '')),            // <- escapado seguro
        "7"  => (string)($reg->cantidad_dias ?? ''),
        "8"  => $thumbHtml,                                   // HTML ya escapado adentro
        "9"  => esc((string)($reg->tipo_ausencia ?? '')),
        "10"  => $btnScan
      ];
      $i++;
    }

    $results = [
      "sEcho" => 1,
      "iTotalRecords"        => count($data),
      "iTotalDisplayRecords" => count($data),
      "aaData"               => $data
    ];

    echo json_utf8_strict($results);
    break;

  /* ------------------------------------------
   * LISTAR ARTÍCULOS PARA ELEGIR (JSON con HTML)
   * ------------------------------------------ */
  case "listArtElegir":
    header('Content-Type: application/json; charset=UTF-8');

    $query_Tipo = $objArticulo->Listar();
    $data = [];
    $i = 1;

    while ($reg = $query_Tipo->fetch_object()) {
      $btn =
        '<button type="button" class="btn btn-warning" data-toggle="tooltip" title="Agregar al detalle" '.
        'onclick="Agregar('.esc((string)$reg->idarticulo).',\''.esc((string)$reg->nombre).'\',\''.esc((string)$reg->codigo2).'\',\''.esc((string)$reg->costo).'\',\''.esc((string)$reg->venta).'\')" '.
        'name="optArtBusqueda[]" data-nombre="'.esc((string)$reg->nombre).'" id="'.esc((string)$reg->idarticulo).'" '.
        'value="'.esc((string)$reg->idarticulo).'" codigo="'.esc((string)$reg->codigo2).'" costo="'.esc((string)$reg->costo).'" venta="'.esc((string)$reg->venta).'">'.
        '<i class="fa fa-check"></i></button>';

      $img = '<img width="100" height="100" src="./'.esc((string)$reg->imagen).'">';

      $data[] = [
        "0" => $btn,
        "1" => $i,
        "2" => esc((string)$reg->categoria),
        "3" => esc((string)$reg->unidadMedida),
        "4" => esc((string)$reg->nombre),
        "5" => esc((string)$reg->descripcion),
        "6" => $img,
        "7" => esc((string)$reg->codigo2),
        "8" => esc((string)$reg->costo),
        "9" => esc((string)$reg->venta)
      ];
      $i++;
    }

    echo json_utf8_strict([
      "sEcho" => 1,
      "iTotalRecords"        => count($data),
      "iTotalDisplayRecords" => count($data),
      "aaData"               => $data
    ]);
    break;

  /* ------------------------------------------
   * listCategoria / listUM (HTML)
   * ------------------------------------------ */
  case "listCategoria":
    require_once "../model/Categoria.php";
    $objCategoria = new Categoria();
    $query_Categoria = $objCategoria->Listar();
    while ($reg = $query_Categoria->fetch_object()) {
      echo '<option value="'.esc((string)$reg->idcategoria).'">'.esc((string)$reg->nombre).'</option>';
    }
    break;

  case "listUM":
    require_once "../model/Categoria.php";
    $objCategoria = new Categoria();
    $query_Categoria = $objCategoria->ListarUM();
    while ($reg = $query_Categoria->fetch_object()) {
      echo '<option value="'.esc((string)$reg->idunidad_medida).'">'.esc((string)$reg->nombre).'</option>';
    }
    break;
}
