<?php
// ajax/ai_widget_submit.php
header('Content-Type: application/json; charset=utf-8');
mb_internal_encoding('UTF-8');

// --- Read POST ---
$q   = isset($_POST['q'])   ? trim($_POST['q'])   : '';
$url = isset($_POST['url']) ? trim($_POST['url']) : '';

if ($q === '') {
  echo json_encode(['ok' => false, 'error' => 'empty_question']);
  exit;
}

// --- Prepare email ---
$to      = 'jportales@bscr.ed.cr';
$subject = 'AI Widget question';
$body    = "Question: " . $q . "\nURL: " . $url . "\nDate: " . date('Y-m-d H:i:s');
$headers = "MIME-Version: 1.0\r\n";
$headers .= "Content-type: text/plain; charset=UTF-8\r\n";
$headers .= "From: noreply@{$_SERVER['SERVER_NAME']}\r\n";

// Try sending
$sent = @mail($to, $subject, $body, $headers);

// --- Optional server auto-reply (fallback if no local match) ---
$reply = "Thanks! I've forwarded your question. You'll receive guidance shortly.";

// Return JSON (never HTML)
echo json_encode(['ok' => (bool)$sent, 'reply' => $reply]);
