<?php
// rrhh_home/ajax/UsuarioAjax.php — Diagnóstico + handlers de panel (PHP 8.1)
declare(strict_types=1);
if (session_status() === PHP_SESSION_NONE) session_start();

ini_set('display_errors', '0'); // no mezclar warnings con JSON
error_reporting(E_ALL);

function out($arr, int $code=200): void {
  if (!headers_sent()) {
    header('Content-Type: application/json; charset=UTF-8');
    http_response_code($code);
  }
  echo json_encode($arr, JSON_UNESCAPED_UNICODE);
  exit;
}
function loge(string $m): void { error_log("[UsuarioAjax] ".$m); }

try {
  $op = $_GET['op'] ?? $_POST['op'] ?? '';
  if ($op === 'ping') out(['ok'=>true,'time'=>date('c')]);

  // Carga modelo cuando hace falta (login); para panel solo usamos sesión
  $modelPath = __DIR__ . '/../model/Usuario.php';
  $haveModel = file_exists($modelPath);
  if (in_array($op, ['IngresarSistema'], true)) {
    if (!$haveModel) { loge("No existe Usuario.php en $modelPath"); out(['ok'=>false,'err'=>'NO_MODEL','msg'=>'Falta model/Usuario.php'], 500); }
    require_once $modelPath;
    if (!class_exists('Usuario') && !class_exists('usuario')) { loge("Clase Usuario/usuario no encontrada"); out(['ok'=>false,'err'=>'NO_CLASS','msg'=>'Clase Usuario no encontrada'], 500); }
  }

  switch ($op) {
    /* ===========================
     * LOGIN
     * =========================== */
    case 'IngresarSistema': {
      $cls = class_exists('Usuario') ? 'Usuario' : 'usuario';
      /** @var object $objusuario */
      $objusuario = new $cls();

      $user = $_REQUEST['user'] ?? '';
      $pass = $_REQUEST['pass'] ?? '';
      if ($user === '' || $pass === '') out(['ok'=>false,'msg'=>'Faltan credenciales'], 400);

      // Algunos modelos ya incluyen la conexión; si no, intenta cargarla:
      $conxPath = __DIR__ . '/../model/Conexion.php';
      if (file_exists($conxPath)) require_once $conxPath;

      if (!method_exists($objusuario, 'Ingresar_Sistema')) { loge("Método Ingresar_Sistema no existe"); out(['ok'=>false,'err'=>'NO_METHOD','msg'=>'Falta método Ingresar_Sistema'], 500); }

      // Mantener MD5 por compatibilidad con DB legacy
      $q = $objusuario->Ingresar_Sistema($user, md5($pass));
      if (!$q) { loge("Ingresar_Sistema devolvió null/false"); out(null); } // frontend trata null como login inválido

      $u = @($q->fetch_object());
      // Devuelve el objeto tal cual espera tu front
      if (!headers_sent()) header('Content-Type: application/json; charset=UTF-8');
      echo json_encode($u, JSON_UNESCAPED_UNICODE);

      if ($u) {
        // Fija la sesión
        $_SESSION["idusuario"]             = $u->idusuario ?? '';
        $_SESSION["idempleado"]            = $u->idempleado ?? '';
        $_SESSION["empleado"]              = $u->empleado ?? '';
        $_SESSION["tipo_documento"]        = $u->tipo_documento ?? '';
        $_SESSION["tipo_usuario"]          = $u->tipo_usuario ?? '';
        $_SESSION["num_documento"]         = $u->num_documento ?? '';
        $_SESSION["direccion"]             = $u->direccion ?? '';
        $_SESSION["telefono"]              = $u->telefono ?? '';
        $_SESSION["foto"]                  = $u->foto ?? '';
        $_SESSION["logo"]                  = $u->logo ?? '';
        $_SESSION["email"]                 = $u->email ?? '';
        $_SESSION["login"]                 = $u->login ?? '';
        $_SESSION["razon_social"]          = $u->razon_social ?? '';
        $_SESSION["mnu_almacen"]           = $u->mnu_almacen ?? 0;
        $_SESSION["mnu_compras"]           = $u->mnu_compras ?? 0;
        $_SESSION["mnu_ventas"]            = $u->mnu_ventas ?? 0;
        $_SESSION["mnu_mantenimiento"]     = $u->mnu_mantenimiento ?? 0;
        $_SESSION["mnu_seguridad"]         = $u->mnu_seguridad ?? 0;
        $_SESSION["mnu_consulta_compras"]  = $u->mnu_consulta_compras ?? 0;
        $_SESSION["mnu_consulta_ventas"]   = $u->mnu_consulta_ventas ?? 0;
        $_SESSION["mnu_admin"]             = $u->mnu_admin ?? 0;
        $_SESSION["superadmin"]            = $u->superadmin ?? '';
      }
      exit;
    }

    /* ===========================
     * ENTRAR AL PANEL (desde acceder.php)
     * =========================== */
    case 'IngresarPanel': {
      if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        http_response_code(405);
        header('Content-Type: text/plain; charset=UTF-8');
        echo 'Use POST';
        exit;
      }

      $keys = [
        'idusuario','idsucursal','idempleado','empleado','tipo_documento','tipo_usuario',
        'num_documento','direccion','telefono','foto','logo','email','login','razon_social',
        'mnu_almacen','mnu_compras','mnu_ventas','mnu_mantenimiento','mnu_seguridad',
        'mnu_consulta_compras','mnu_consulta_ventas','mnu_admin'
      ];
      foreach ($keys as $k) { $_POST[$k] = $_POST[$k] ?? ''; }

      if (session_status() === PHP_SESSION_NONE) session_start();
      $_SESSION['idusuario']             = $_POST['idusuario'];
      $_SESSION['idsucursal']            = $_POST['idsucursal'];
      $_SESSION['idempleado']            = $_POST['idempleado'];
      $_SESSION['empleado']              = $_POST['empleado'];
      $_SESSION['tipo_documento']        = $_POST['tipo_documento'];
      $_SESSION['tipo_usuario']          = $_POST['tipo_usuario'];
      $_SESSION['num_documento']         = $_POST['num_documento'];
      $_SESSION['direccion']             = $_POST['direccion'];
      $_SESSION['telefono']              = $_POST['telefono'];
      $_SESSION['foto']                  = $_POST['foto'];
      $_SESSION['logo']                  = $_POST['logo'];
      $_SESSION['email']                 = $_POST['email'];
      $_SESSION['login']                 = $_POST['login'];
      $_SESSION['razon_social']          = $_POST['razon_social'];
      $_SESSION['mnu_almacen']           = $_POST['mnu_almacen'];
      $_SESSION['mnu_compras']           = $_POST['mnu_compras'];
      $_SESSION['mnu_ventas']            = $_POST['mnu_ventas'];
      $_SESSION['mnu_mantenimiento']     = $_POST['mnu_mantenimiento'];
      $_SESSION['mnu_seguridad']         = $_POST['mnu_seguridad'];
      $_SESSION['mnu_consulta_compras']  = $_POST['mnu_consulta_compras'];
      $_SESSION['mnu_consulta_ventas']   = $_POST['mnu_consulta_ventas'];
      $_SESSION['mnu_admin']             = $_POST['mnu_admin'];

      header('Content-Type: text/plain; charset=UTF-8');
      echo 'OK';
      exit;
    }

    /* ===========================
     * ENTRAR COMO SUPERADMIN
     * =========================== */
    case 'IngresarPanelSuperAdmin': {
      if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        http_response_code(405);
        header('Content-Type: text/plain; charset=UTF-8');
        echo 'Use POST';
        exit;
      }

      $keys = [
        'idempleado','idusuario','idsucursal','estadoAdmin','empleado','tipo_documento',
        'direccion','telefono','foto','email','login','mnu_almacen','mnu_compras','mnu_ventas',
        'mnu_mantenimiento','mnu_seguridad','mnu_consulta_compras','mnu_consulta_ventas','mnu_admin','logo'
      ];
      foreach ($keys as $k) { $_POST[$k] = $_POST[$k] ?? ''; }

      if (session_status() === PHP_SESSION_NONE) session_start();
      $_SESSION['idempleado']            = $_POST['idempleado'];
      $_SESSION['idusuario']             = $_POST['idusuario'];
      $_SESSION['idsucursal']            = $_POST['idsucursal'];
      $_SESSION['superadmin']            = $_POST['estadoAdmin'];
      $_SESSION['empleado']              = $_POST['empleado'];
      $_SESSION['tipo_documento']        = $_POST['tipo_documento'];
      $_SESSION['direccion']             = $_POST['direccion'];
      $_SESSION['telefono']              = $_POST['telefono'];
      $_SESSION['foto']                  = $_POST['foto'];
      $_SESSION['email']                 = $_POST['email'];
      $_SESSION['login']                 = $_POST['login'];
      $_SESSION['mnu_almacen']           = $_POST['mnu_almacen'];
      $_SESSION['mnu_compras']           = $_POST['mnu_compras'];
      $_SESSION['mnu_ventas']            = $_POST['mnu_ventas'];
      $_SESSION['mnu_mantenimiento']     = $_POST['mnu_mantenimiento'];
      $_SESSION['mnu_seguridad']         = $_POST['mnu_seguridad'];
      $_SESSION['mnu_consulta_compras']  = $_POST['mnu_consulta_compras'];
      $_SESSION['mnu_consulta_ventas']   = $_POST['mnu_consulta_ventas'];
      $_SESSION['mnu_admin']             = $_POST['mnu_admin'];
      $_SESSION['logo']                  = $_POST['logo'];

      header('Content-Type: text/plain; charset=UTF-8');
      echo 'OK';
      exit;
    }

    /* ===========================
     * SALIR
     * =========================== */
    case 'Salir': {
      $_SESSION = [];
      if (ini_get('session.use_cookies')) {
        $p = session_get_cookie_params();
        setcookie(session_name(), '', time()-42000, $p['path'], $p['domain'], $p['secure'], $p['httponly']);
      }
      session_destroy();
      header('Location: ../');
      exit;
    }

    default:
      out(['ok'=>false,'msg'=>'Operación inválida'], 400);
  }
} catch (Throwable $e) {
  loge("EXCEPTION: ".$e->getMessage()." @ ".$e->getFile().":".$e->getLine());
  out(['ok'=>false,'err'=>'EXC','msg'=>'Error de servidor'], 500);
}
