<?php
// ajax/LoginEvidenciaAjax.php
declare(strict_types=1);

session_start();
header('Content-Type: application/json; charset=utf-8');
date_default_timezone_set('America/Costa_Rica');

function fail(int $code, string $msg): void {
  http_response_code($code);
  echo json_encode(['ok' => false, 'msg' => $msg], JSON_UNESCAPED_UNICODE);
  exit;
}

if (!isset($_SESSION['idusuario']) || (int)$_SESSION['idusuario'] <= 0) {
  fail(401, 'No autorizado (sin sesión)');
}

require_once __DIR__ . '/../dbcon.php';
if (!isset($con) || !($con instanceof mysqli)) {
  fail(500, 'dbcon.php no creó $con (mysqli)');
}
mysqli_set_charset($con, 'utf8mb4');

$idusuario = (int)$_SESSION['idusuario'];

$lat = isset($_POST['lat']) ? (float)$_POST['lat'] : null;
$lng = isset($_POST['lng']) ? (float)$_POST['lng'] : null;
$acc = isset($_POST['accuracy']) ? (int)$_POST['accuracy'] : null;

$ip = $_SERVER['REMOTE_ADDR'] ?? null;
$ua = $_SERVER['HTTP_USER_AGENT'] ?? null;
$ua = $ua ? mb_substr($ua, 0, 255, 'UTF-8') : null;

if (!isset($_FILES['photo'])) fail(400, 'Falta archivo photo');
if ($_FILES['photo']['error'] !== UPLOAD_ERR_OK) fail(400, 'Error upload: ' . (string)$_FILES['photo']['error']);

$size = (int)($_FILES['photo']['size'] ?? 0);
if ($size <= 0) fail(400, 'Archivo vacío');
if ($size > 2 * 1024 * 1024) fail(400, 'Foto muy pesada (máx 2MB)');

// Detectar mime (con fallback si finfo no está)
$mime = '';
if (class_exists('finfo')) {
  $finfo = new finfo(FILEINFO_MIME_TYPE);
  $mime = (string)$finfo->file($_FILES['photo']['tmp_name']);
} else {
  $mime = (string)($_FILES['photo']['type'] ?? '');
}

if (!in_array($mime, ['image/jpeg','image/png'], true)) {
  fail(400, 'Formato inválido: ' . $mime . ' (use JPG/PNG)');
}

$baseFiles = realpath(__DIR__ . '/../Files');
if ($baseFiles === false) fail(500, 'No existe carpeta Files/');

$targetDir = $baseFiles . DIRECTORY_SEPARATOR . 'login_evidencias';
if (!is_dir($targetDir)) {
  if (!@mkdir($targetDir, 0755, true)) {
    fail(500, 'No se pudo crear Files/login_evidencias/');
  }
}
if (!is_writable($targetDir)) {
  fail(500, 'Carpeta no escribible: Files/login_evidencias/');
}

$ext = ($mime === 'image/png') ? 'png' : 'jpg';
$filename = 'login_' . $idusuario . '_' . date('Ymd_His') . '_' . bin2hex(random_bytes(4)) . '.' . $ext;

$destAbs = $targetDir . DIRECTORY_SEPARATOR . $filename;
if (!move_uploaded_file($_FILES['photo']['tmp_name'], $destAbs)) {
  fail(500, 'No se pudo mover el archivo a destino (permisos?)');
}

$photoPath = 'Files/login_evidencias/' . $filename;

$sql = "INSERT INTO login_evidencias (idusuario, lat, lng, accuracy_m, ip, user_agent, photo_path)
        VALUES (?, ?, ?, ?, ?, ?, ?)";
$stmt = mysqli_prepare($con, $sql);
if (!$stmt) {
  fail(500, 'SQL prepare error: ' . mysqli_error($con));
}

$latParam = $lat;
$lngParam = $lng;
$accParam = $acc;

mysqli_stmt_bind_param($stmt, 'iddisss',
  $idusuario, $latParam, $lngParam, $accParam, $ip, $ua, $photoPath
);

if (!mysqli_stmt_execute($stmt)) {
  $err = mysqli_stmt_error($stmt);
  mysqli_stmt_close($stmt);
  fail(500, 'SQL execute error: ' . $err);
}
mysqli_stmt_close($stmt);

echo json_encode(['ok' => true, 'photo_path' => $photoPath], JSON_UNESCAPED_UNICODE);
