<?php
// ajax/HomeRRHHAjax.php
session_start();
date_default_timezone_set('America/Costa_Rica');

// DEBUG
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// No cache
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');

require_once "../model/HomeRRHH.php"; // define $db (mysqli) y la clase HomeRRHH
$home = new HomeRRHH();

// Asegurar acceso a $db (mysqli)
global $db;
if (!($db instanceof mysqli)) {
  http_response_code(500);
  echo "No hay conexión a base de datos (mysqli).";
  exit;
}

$op = isset($_GET["op"]) ? $_GET["op"] : "";

switch ($op) {

  /* ===========================================================
   * VACACIONES — SOLO con ingreso_vacaciones (status='1')
   * (Tu SQL exacto; se filtra por rango y categoría opcional)
   * =========================================================== */
  case 'vacaciones_mes_with_days':
    $start = isset($_GET['start']) ? $_GET['start'] : null; // YYYY-MM-DD
    $end   = isset($_GET['end'])   ? $_GET['end']   : null; // exclusivo en FC
    $cat   = isset($_GET['category']) ? trim($_GET['category']) : '';

    if (!$start || !$end) {
      // mes actual
      $y = isset($_GET['y']) ? intval($_GET['y']) : intval(date('Y'));
      $m = isset($_GET['m']) ? intval($_GET['m']) : intval(date('n'));
      $inicio = sprintf('%04d-%02d-01', $y, $m);
      $fin    = date('Y-m-t', strtotime($inicio));
    } else {
      $inicio = $start;
      $fin    = date('Y-m-d', strtotime($end . ' -1 day')); // inclusivo
    }

    $inicio_esc = $db->real_escape_string($inicio);
    $fin_esc    = $db->real_escape_string($fin);
    $cat_esc    = $db->real_escape_string($cat);

    $whereCat = ($cat !== '') ? " AND e.categoria = '{$cat_esc}' " : "";

    $sql = "
        SELECT
          v.id,
          v.idempleado,
          e.nombre_completo,
          e.categoria,
          v.fecha_desde,
          v.fecha_hasta,
          v.cantidad_dias,
          'vacaciones' AS tipo
        FROM ingreso_vacaciones v
        INNER JOIN empleados_planilla e ON e.id = v.idempleado
        WHERE v.status='1' AND v.fecha_desde <= '{$fin_esc}'
          AND v.fecha_hasta >= '{$inicio_esc}'
          {$whereCat}
        ORDER BY v.fecha_desde ASC, v.id ASC
    ";

    $res = $db->query($sql);
    if (!$res) {
      http_response_code(500);
      header('Content-Type: text/plain; charset=utf-8');
      echo "Error en consulta: " . $db->error;
      exit;
    }

    $events = array();
    while ($r = $res->fetch_object()) {
      // FullCalendar usa end exclusivo
      $end_exclusivo = date('Y-m-d', strtotime($r->fecha_hasta . ' +1 day'));

      $events[] = array(
        'id'             => (int)$r->id,
        'title'          => $r->nombre_completo . " (" . $r->categoria . ")",
        'start'          => $r->fecha_desde,
        'end'            => $end_exclusivo,
        'categoria'      => $r->categoria,
        'cantidad_dias'  => is_null($r->cantidad_dias) ? null : (int)$r->cantidad_dias,
        'type'           => 'vacaciones',
        'fecha_desde'    => $r->fecha_desde,
        'fecha_hasta'    => $r->fecha_hasta,
        'idempleado'     => (int)$r->idempleado
      );
    }

    header('Content-Type: application/json; charset=utf-8');
    echo json_encode($events);
  break;

  /* ===========================================================
   * Compat: versión simple (por si algo viejo lo llama)
   * =========================================================== */
  case 'vacaciones_mes':
    $start = isset($_GET['start']) ? $_GET['start'] : null;
    $end   = isset($_GET['end'])   ? $_GET['end']   : null;
    $cat   = isset($_GET['category']) ? trim($_GET['category']) : '';

    if (!$start || !$end) {
      $y = isset($_GET['y']) ? intval($_GET['y']) : intval(date('Y'));
      $m = isset($_GET['m']) ? intval($_GET['m']) : intval(date('n'));
      $inicio = sprintf('%04d-%02d-01', $y, $m);
      $fin    = date('Y-m-t', strtotime($inicio));
    } else {
      $inicio = $start;
      $fin    = date('Y-m-d', strtotime($end . ' -1 day'));
    }

    $inicio_esc = $db->real_escape_string($inicio);
    $fin_esc    = $db->real_escape_string($fin);
    $cat_esc    = $db->real_escape_string($cat);
    $whereCat   = ($cat !== '') ? " AND e.categoria = '{$cat_esc}' " : "";

    $sql = "
      SELECT
        v.id,
        v.idempleado,
        e.nombre_completo,
        e.categoria,
        v.fecha_desde,
        v.fecha_hasta,
        v.cantidad_dias,
        'vacaciones' AS tipo
      FROM ingreso_vacaciones v
      INNER JOIN empleados_planilla e ON e.id = v.idempleado
      WHERE v.status='1' AND v.fecha_desde <= '{$fin_esc}'
        AND v.fecha_hasta >= '{$inicio_esc}'
        {$whereCat}
      ORDER BY v.fecha_desde ASC, v.id ASC
    ";
    $res = $db->query($sql);

    $events = array();
    if ($res) {
      while ($r = $res->fetch_object()) {
        $end_exclusivo = date('Y-m-d', strtotime($r->fecha_hasta . ' +1 day'));
        $events[] = array(
          'id'        => (int)$r->id,
          'title'     => $r->nombre_completo . " (" . $r->categoria . ")",
          'start'     => $r->fecha_desde,
          'end'       => $end_exclusivo,
          'categoria' => $r->categoria,
          'type'      => 'vacaciones'
        );
      }
    }

    header('Content-Type: application/json; charset=utf-8');
    echo json_encode($events);
  break;

  /* ===========================================================
   * INCAPACIDADES — botón dedicado
   * =========================================================== */
  case 'incapacidades_mes_with_days':
    $start = isset($_GET['start']) ? $_GET['start'] : null;
    $end   = isset($_GET['end'])   ? $_GET['end']   : null;
    $cat   = isset($_GET['category']) ? trim($_GET['category']) : '';

    if (!$start || !$end) {
      $y = isset($_GET['y']) ? intval($_GET['y']) : intval(date('Y'));
      $m = isset($_GET['m']) ? intval($_GET['m']) : intval(date('n'));
      $inicio = sprintf('%04d-%02d-01', $y, $m);
      $fin    = date('Y-m-t', strtotime($inicio));
    } else {
      $inicio = $start;
      $fin    = date('Y-m-d', strtotime($end . ' -1 day'));
    }

    $inicio_esc = $db->real_escape_string($inicio);
    $fin_esc    = $db->real_escape_string($fin);
    $cat_esc    = $db->real_escape_string($cat);

    // Ajusta nombres de columnas según tu tabla real
    $whereCat = ($cat !== '') ? " AND e.categoria = '{$cat_esc}' " : "";

    $sql = "
      SELECT
        i.id,
        i.idempleado,
        e.nombre_completo,
        e.categoria,
        i.fecha_desde,
        i.fecha_hasta,
        i.dias_calculo AS cantidad_dias
      FROM ingreso_inscapacidad i
      INNER JOIN empleados_planilla e ON e.id = i.idempleado
      WHERE i.fecha_desde <= '{$fin_esc}' AND i.fecha_hasta >= '{$inicio_esc}'
      {$whereCat}
      ORDER BY i.fecha_desde ASC, i.id ASC
    ";

    $res = $db->query($sql);
    if (!$res) {
      http_response_code(500);
      header('Content-Type: text/plain; charset=utf-8');
      echo "Error en consulta (incapacidades): " . $db->error;
      exit;
    }

    $events = array();
    while ($r = $res->fetch_object()) {
      $end_exclusivo = date('Y-m-d', strtotime($r->fecha_hasta . ' +1 day'));
      $events[] = array(
        'id'            => (int)$r->id,
        'title'         => $r->nombre_completo . " (" . $r->categoria . ")",
        'start'         => $r->fecha_desde,
        'end'           => $end_exclusivo,
        'categoria'     => $r->categoria,
        'cantidad_dias' => is_null($r->cantidad_dias) ? null : (int)$r->cantidad_dias,
        'type'          => 'incapacidad',
        'fecha_desde'   => $r->fecha_desde,
        'fecha_hasta'   => $r->fecha_hasta,
        'idempleado'    => (int)$r->idempleado
      );
    }

    header('Content-Type: application/json; charset=utf-8');
    echo json_encode($events);
  break;

  /* ===========================================================
   * Próximas 50 semanas
   * =========================================================== */
  case 'proximas_50':
    $dias = isset($_GET['dias']) ? intval($_GET['dias']) : 365;
    $lista = $home->ProximosCincuentaSemanas($dias);
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode($lista);
  break;

  /* ===========================================================
   * Top saldos
   * =========================================================== */
  case 'top_saldos':
    $n = isset($_GET['n']) ? intval($_GET['n']) : 10;
    $top = $home->TopSaldoVacaciones($n);
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode($top);
  break;

  default:
    http_response_code(400);
    echo "Operación no válida";
  break;
}
