<?php
// add_modificar_imagen1_formatos.php
// Sube 1 archivo (imagen o PDF) y lo guarda en Files/Formatos/<Mes-Año>/nombre_unico.ext
// Actualiza ingreso_formatos.imagen1 con la ruta relativa resultante.

ini_set('display_errors','1'); // ponlo en 0 en producción
ini_set('display_startup_errors','1');
error_reporting(E_ALL);

if (session_status() !== PHP_SESSION_ACTIVE) session_start();
date_default_timezone_set('America/Costa_Rica');

require_once __DIR__ . '/dbcon.php';

// ---------- Utilidades ----------
function month_name_es($m){
  static $N = [1=>'Enero','Febrero','Marzo','Abril','Mayo','Junio','Julio','Agosto','Septiembre','Octubre','Noviembre','Diciembre'];
  $mi = (int)$m; return $N[$mi] ?? 'Desconocido';
}
function month_folder_from_date($datestr){
  // Espera Y-m-d; si no cuadra, usa hoy
  if (!$datestr || !preg_match('/^\d{4}-\d{2}-\d{2}$/', $datestr)) $datestr = date('Y-m-d');
  [$Y,$m] = explode('-', substr($datestr,0,7));
  return month_name_es((int)$m) . '-' . $Y; // p.ej. "Octubre-2025"
}
function safe_filename($name){
  // Limpia nombre base, preserva extensión
  $ext = strtolower(pathinfo($name, PATHINFO_EXTENSION));
  $base = pathinfo($name, PATHINFO_FILENAME);
  $base = preg_replace('/[^A-Za-z0-9_\-\.]+/','_', $base);
  $base = trim($base, '_');
  if ($base === '') $base = 'archivo';
  return [$base, $ext];
}
function unique_target($dir, $base, $ext){
  $ts = date('Ymd_His');
  $rnd = mt_rand(1000,9999);
  $fname = "{$base}_{$ts}_{$rnd}." . $ext;
  return rtrim($dir,'/') . '/' . $fname;
}

// ---------- Entradas ----------
$idrecibido = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($idrecibido <= 0) {
  die('ID inválido.');
}

$idsucursal = isset($_SESSION['idsucursal']) ? $_SESSION['idsucursal'] : null;

// Recoge (si vienen) para elegir la subcarpeta por fecha del documento
$fecha_documento = isset($_POST['fecha']) ? trim($_POST['fecha']) : ''; // esperado Y-m-d

// (El resto de campos que recibes, los dejamos tal cual por si los usas más adelante)
$idempleado        = $_POST["idempleado"]        ?? null;
$area              = $_POST["area"]              ?? null;
$responsabilidad1  = $_POST["responsabilidad"]   ?? '';
$responsabilidad2  = $_POST["responsabilidad2"]  ?? '';
$responsabilidad   = $responsabilidad1 . ' | ' . $responsabilidad2;
$correo            = $_POST["correo"]            ?? '';
$descripcion       = $_POST["descripcion"]       ?? '';
$prioridad         = $_POST["prioridad"]         ?? '';
$final             = $_POST["final"]             ?? '';
$tipo_presupuesto  = $_POST["tipo_presupuesto"]  ?? '';
$departamento      = $_POST["departamento"]      ?? '';
$comentario        = $_POST["comentario"]        ?? '';
$status_interno    = $_POST["status_interno"]    ?? '';
$archivo_texto     = $_POST["archivo"]           ?? ''; // solo texto, no archivo

// ---------- Carpeta base + subcarpeta Mes-Año ----------
$BASE_DIR_REL = "Files/Formatos";               // relativo al docroot del sitio
$SUB          = month_folder_from_date($fecha_documento);
$TARGET_DIR   = rtrim($BASE_DIR_REL,'/') . '/' . $SUB;  // p.ej. Files/Formatos/Octubre-2025

// Asegura carpeta (en base al DOCUMENT_ROOT si es ruta relativa)
$docroot = rtrim($_SERVER['DOCUMENT_ROOT'] ?? __DIR__, '/');
$absTargetDir = (strpos($TARGET_DIR,'/')===0) ? $TARGET_DIR : $docroot . '/' . $TARGET_DIR;
if (!is_dir($absTargetDir)) {
  if (!@mkdir($absTargetDir, 0775, true)) {
    die('No se pudo crear la carpeta de destino: ' . htmlspecialchars($TARGET_DIR));
  }
}

// ---------- Subida de archivo ----------
$campo = 'imagen1'; // name del input file
$nuevoPathRel = ''; // lo que guardaremos en BD
$hayArchivo = isset($_FILES[$campo]) && is_array($_FILES[$campo]) && !empty($_FILES[$campo]['name']);

if ($hayArchivo) {
  $name = $_FILES[$campo]['name'];
  $tmp  = $_FILES[$campo]['tmp_name'];
  $size = (int)$_FILES[$campo]['size'];
  $err  = (int)$_FILES[$campo]['error'];

  if ($err !== UPLOAD_ERR_OK || $size <= 0 || !is_uploaded_file($tmp)) {
    die('Error al subir el archivo.');
  }

  // Detecta tipo: permitimos imágenes y PDF
  $extReal = strtolower(pathinfo($name, PATHINFO_EXTENSION));
  $permitidos = ['jpg','jpeg','png','gif','webp','bmp','pdf'];
  if (!in_array($extReal, $permitidos, true)) {
    die('Tipo de archivo no permitido. Solo imágenes o PDF.');
  }

  // Validación extra para imágenes (si no es PDF)
  if ($extReal !== 'pdf') {
    $info = @getimagesize($tmp);
    if ($info === false) {
      die('El archivo no es una imagen válida.');
    }
  }

  // Límite de tamaño (ajusta a tus políticas)
  if ($size > 50*1024*1024) { // 50 MB
    die('El archivo es demasiado grande (máx. 50MB).');
  }

  // Genera nombre único
  [$base, $ext] = safe_filename($name);
  if ($ext === '') $ext = $extReal;
  $absTargetFile = unique_target($absTargetDir, $base, $ext);

  // Mueve
  if (!@move_uploaded_file($tmp, $absTargetFile)) {
    // Fallback a copy si el hosting bloquea move_uploaded_file
    if (!@copy($tmp, $absTargetFile)) {
      die('No se pudo guardar el archivo en destino.');
    }
  }

  // Ruta relativa para BD (desde docroot)
  $nuevoPathRel = $TARGET_DIR . '/' . basename($absTargetFile);
}

// ---------- Si no se subió nada, NO cambiamos la ruta; si sí, actualizamos ----------
if ($nuevoPathRel !== '') {
  $nuevoPathEsc = mysqli_real_escape_string($con, $nuevoPathRel);

  // (Opcional) Borrar archivo anterior si pertenece a Files/Formatos/
  $rsOld = mysqli_query($con, "SELECT imagen1 FROM ingreso_formatos WHERE id=$idrecibido LIMIT 1") or die(mysqli_error($con));
  if ($rsOld && ($rowOld = mysqli_fetch_assoc($rsOld))) {
    $oldRel = trim($rowOld['imagen1'] ?? '');
    if ($oldRel !== '') {
      $absOld = (strpos($oldRel,'/')===0) ? $oldRel : $docroot . '/' . ltrim($oldRel,'/');
      $absBase = realpath($docroot . '/' . $BASE_DIR_REL);
      $absOldR = @realpath($absOld);
      if ($absBase && $absOldR && strpos($absOldR, $absBase) === 0 && file_exists($absOldR)) {
        @unlink($absOldR);
      }
    }
  }

  mysqli_query($con, "UPDATE ingreso_formatos SET imagen1='$nuevoPathEsc' WHERE id=$idrecibido") or die(mysqli_error($con));
}

// ---------- Redirección ----------
echo "<script>document.location='consulta_formatos.php?id=consulta_formatos.php'</script>";
exit;
