<?php
// add_modificar_imagen1_documentosgenerales_empleadosplanilla.php
// Reemplaza el archivo actual por uno nuevo construido a partir de múltiples adjuntos (con crop/rotate)
// Ahora guarda en subcarpetas por Mes-Año: Files/documentosgenerales_empleadosplanilla/Octubre-2025/...

ini_set('display_errors','1'); // 0 en producción
ini_set('display_startup_errors','1');
error_reporting(E_ALL);

// Recursos prudentes
ini_set('memory_limit','1024M');
set_time_limit(180);

if (session_status() !== PHP_SESSION_ACTIVE) session_start();
date_default_timezone_set('America/Costa_Rica');

require_once __DIR__ . '/dbcon.php';

$idsucursal = isset($_SESSION['idsucursal']) ? $_SESSION['idsucursal'] : '';
$idrecibido = isset($_GET['id']) ? (int)$_GET['id'] : 0;

// ======== Entradas del formulario ========
$idempleado       = isset($_POST["idempleado"]) ? $_POST["idempleado"] : '';
$crop_json_list   = isset($_POST["crop_json_list"]) ? $_POST["crop_json_list"] : "[]"; // recortes por archivo

// ======== Helpers ========
function _parse_crop_list($json){ $d=json_decode($json,true); return is_array($d)?$d:[]; }
function _clampv($v,$min,$max){ return max($min, min($max, (int)$v)); }

// ---- Meses en español (Título Capitalizado) ----
function month_name_es($m){
  static $N = [1=>'Enero','Febrero','Marzo','Abril','Mayo','Junio','Julio','Agosto','Septiembre','Octubre','Noviembre','Diciembre'];
  $mi = (int)$m;
  return isset($N[$mi]) ? $N[$mi] : 'Desconocido';
}

// ---- Construir nombre de carpeta "Mes-Año" desde Y-m-d (o hoy si vacío) ----
function month_folder_from_date($datestr){
  if (!$datestr || !preg_match('/^\d{4}-\d{2}-\d{2}$/', $datestr)) {
    $datestr = date('Y-m-d');
  }
  [$Y,$m,$d] = explode('-', $datestr);
  return month_name_es((int)$m) . '-' . $Y;
}

// Limitar Imagick (si existe)
if (class_exists('Imagick')) {
  try {
    $rl = new Imagick();
    $rl->setResourceLimit(Imagick::RESOURCETYPE_MEMORY, 256);
    $rl->setResourceLimit(Imagick::RESOURCETYPE_MAP, 256);
    $rl->clear(); $rl->destroy();
  } catch(Exception $e){}
}

// Añadir una imagen (con crop/rotate) como página PDF en un documento Imagick
function _imagick_add_image_page($doc, $tmp, $crop=null){
  $img = new Imagick();
  $img->readImage($tmp);

  if (is_array($crop) && isset($crop['rotate']) && abs((float)$crop['rotate']) > 0.01) {
    $img->rotateImage(new ImagickPixel('white'), (float)$crop['rotate']);
  }
  if (is_array($crop) && !empty($crop['width']) && !empty($crop['height'])) {
    $iw=$img->getImageWidth(); $ih=$img->getImageHeight();
    $x=_clampv($crop['x']??0, 0, $iw-1);
    $y=_clampv($crop['y']??0, 0, $ih-1);
    $cw=_clampv($crop['width'], 1, $iw);
    $ch=_clampv($crop['height'],1, $ih);
    if ($x+$cw>$iw) $cw=$iw-$x;
    if ($y+$ch>$ih) $ch=$ih-$y;
    if ($cw>1 && $ch>1) { $img->cropImage($cw,$ch,$x,$y); $img->setImagePage(0,0,0,0); }
  }

  // Downscale si es enorme
  $MAX_PX = 40_000_000;
  $iw=$img->getImageWidth(); $ih=$img->getImageHeight();
  if (($iw*$ih) > $MAX_PX) { $img->sampleImage(3000, 3000, true); }

  if (method_exists($img,'setImageAlphaChannel')) {
    $img->setImageAlphaChannel(Imagick::ALPHACHANNEL_REMOVE);
  }
  $img->setImageColorspace(Imagick::COLORSPACE_SRGB);

  // Tamaño razonable
  $maxW=2500; $maxH=3500;
  $iw=$img->getImageWidth(); $ih=$img->getImageHeight();
  if ($iw>$maxW || $ih>$maxH) { $img->thumbnailImage($maxW,$maxH,true,true); }

  $img->setImageFormat('pdf');
  $img->setImageCompression(Imagick::COMPRESSION_JPEG);
  $img->setImageCompressionQuality(80);
  $img->setImageUnits(Imagick::RESOLUTION_PIXELSPERINCH);
  $img->setImageResolution(150,150);

  $doc->addImage($img);
  $img->clear(); $img->destroy();
  return true;
}

// GD → JPEG bytes (con crop/rotate). Devuelve ['data'=>..., 'w'=>, 'h'=>] o null
function _gd_image_to_jpeg_bytes($tmp, $ext, $crop=null){
  $info = @getimagesize($tmp);
  if (!$info) return null;
  $wI = (int)$info[0]; $hI = (int)$info[1];
  $MAX_PX = 40_000_000;
  if (($wI*$hI)>$MAX_PX) return null;

  switch($ext){
    case 'jpg':case 'jpeg': $im=@imagecreatefromjpeg($tmp); break;
    case 'png': $im=@imagecreatefrompng($tmp); break;
    case 'gif': $im=@imagecreatefromgif($tmp); break;
    case 'webp': $im=@imagecreatefromwebp($tmp); $ext='jpeg'; break; // convertiremos a JPEG
    default: return null;
  }
  if(!$im) return null;

  if (is_array($crop) && isset($crop['rotate']) && abs((float)$crop['rotate'])>0.01) {
    $bg=imagecolorallocate($im,255,255,255);
    $rot=imagerotate($im, -(float)$crop['rotate'], $bg);
    if($rot){ imagedestroy($im); $im=$rot; }
  }

  $w=imagesx($im); $h=imagesy($im);
  if (is_array($crop) && !empty($crop['width']) && !empty($crop['height'])){
    $x=_clampv($crop['x']??0, 0, $w-1);
    $y=_clampv($crop['y']??0, 0, $h-1);
    $cw=_clampv($crop['width'], 1, $w);
    $ch=_clampv($crop['height'],1, $h);
    if ($x+$cw>$w) $cw=$w-$x;
    if ($y+$ch>$h) $ch=$h-$y;
    if ($cw>1 && $ch>1){
      $dst=imagecreatetruecolor($cw,$ch);
      imagecopyresampled($dst,$im,0,0,$x,$y,$cw,$ch,$cw,$ch);
      imagedestroy($im); $im=$dst; $w=$cw; $h=$ch;
    }
  }

  $maxW=2500; $maxH=3500;
  if ($w>$maxW || $h>$maxH){
    $ratio=min($maxW/$w,$maxH/$h);
    $nw=(int)round($w*$ratio); $nh=(int)round($h*$ratio);
    $res=imagecreatetruecolor($nw,$nh);
    imagecopyresampled($res,$im,0,0,0,0,$nw,$nh,$w,$h);
    imagedestroy($im); $im=$res; $w=$nw; $h=$nh;
  }

  ob_start(); imagejpeg($im,null,80); $data=ob_get_clean();
  imagedestroy($im);
  if(function_exists('gc_collect_cycles')) gc_collect_cycles();

  return ['data'=>$data,'w'=>$w,'h'=>$h];
}

// PDF simple multipágina desde JPEG bytes (sin librerías externas)
function _build_multi_pdf_from_jpegs($pages, $targetPdf){
  $unit=72; $a4w=8.27*$unit; $a4h=11.69*$unit; $dpi=150.0;
  $pdf="%PDF-1.3\n"; $ofs=array(); $objNum=1;
  $ofs[] = strlen($pdf);
  $pdf .= ($objNum)." 0 obj<< /Type /Catalog /Pages 2 0 R >>endobj\n";
  $catalogObj=$objNum; $objNum++;
  $pagesObj=$objNum; $objNum++; $kids=array();
  foreach($pages as $pg){
    $w=$pg['w']; $h=$pg['h']; $imgData=$pg['data'];
    $imgWpt=($w/$dpi)*72.0; $imgHpt=($h/$dpi)*72.0;
    $scale=min(($a4w*0.92)/$imgWpt, ($a4h*0.92)/$imgHpt); if($scale<=0)$scale=1;
    $dw=$imgWpt*$scale; $dh=$imgHpt*$scale;
    $x=($a4w-$dw)/2; $y=($a4h-$dh)/2;

    $imgObj=$objNum++; $ofs[] = strlen($pdf);
    $pdf.=$imgObj." 0 obj<< /Type /XObject /Subtype /Image /Width ".intval($w)." /Height ".intval($h)." /ColorSpace /DeviceRGB /BitsPerComponent 8 /Filter /DCTDecode /Length ".strlen($imgData)." >>stream\n".$imgData."\nendstream\nendobj\n";

    $stream="q\n".sprintf('%.2f 0 0 %.2f %.2f %.2f cm',$dw,$dh,$x,$y)."\n/Im0 Do\nQ\n";
    $cntObj=$objNum++; $ofs[] = strlen($pdf);
    $pdf.=$cntObj." 0 obj<< /Length ".strlen($stream)." >>stream\n".$stream."endstream\nendobj\n";

    $pageObj=$objNum++; $ofs[] = strlen($pdf);
    $pdf.=$pageObj." 0 obj<< /Type /Page /Parent ".$pagesObj." 0 R /MediaBox [0 0 ".sprintf('%.2f %.2f',$a4w,$a4h)."] /Resources << /XObject << /Im0 ".$imgObj." 0 R >> /ProcSet [/PDF /ImageC] >> /Contents ".$cntObj." 0 R >>endobj\n";

    $kids[]=$pageObj." 0 R";
  }
  $ofs[] = strlen($pdf);
  $pdf.=$pagesObj." 0 obj<< /Type /Pages /Count ".count($kids)." /Kids [ ".implode(' ',$kids)." ] >>endobj\n";

  $xrefPos=strlen($pdf);
  $pdf.="xref\n0 ".($objNum)."\n0000000000 65535 f \n";
  foreach($ofs as $o){ $pdf.=sprintf("%010d 00000 n \n",$o); }
  $pdf.="trailer<< /Size ".($objNum)." /Root ".$catalogObj." 0 R >>\nstartxref\n".$xrefPos."\n%%EOF";
  return (bool)file_put_contents($targetPdf,$pdf);
}

/**
 * Convierte $_FILES['imagen1'] → UN PDF final (respeta recortes por índice).
 * Si hay PDFs, concatena (Imagick) o toma el primero (GD simple).
 * Devuelve ruta del PDF o '' si no hay adjuntos válidos.
 */
function construirPDFAdjunto($target_dir, $fieldName = 'imagen1', $crop_json_list = '[]'){
  if (!isset($_FILES[$fieldName])) return '';
  $isMultiple = is_array($_FILES[$fieldName]['name']);
  $names = $isMultiple ? $_FILES[$fieldName]['name'] : [ $_FILES[$fieldName]['name'] ];
  $tmps  = $isMultiple ? $_FILES[$fieldName]['tmp_name'] : [ $_FILES[$fieldName]['tmp_name'] ];
  $sizes = $isMultiple ? $_FILES[$fieldName]['size'] : [ $_FILES[$fieldName]['size'] ];
  $crops = _parse_crop_list($crop_json_list);

  $hasAny = false;
  foreach ($names as $i=>$n) {
    if (!empty($n) && (int)$sizes[$i] > 0 && is_uploaded_file($tmps[$i])) { $hasAny = true; break; }
  }
  if (!$hasAny) return '';

  if (!is_dir($target_dir)) { @mkdir($target_dir, 0775, true); }
  $safePdf   = 'vac_'.date('Ymd_His').'_'.mt_rand(1000,9999).'.pdf';
  $targetPdf = rtrim($target_dir,'/').'/'.$safePdf;

  $useImagick = class_exists('Imagick');

  if ($useImagick){
    $doc = new Imagick();
    $added = 0;
    foreach($names as $i=>$origName){
      $tmpPath=$tmps[$i]; $size=(int)$sizes[$i];
      if ($size<=0 || !is_uploaded_file($tmpPath)) continue;
      $ext = strtolower(pathinfo($origName, PATHINFO_EXTENSION));
      $crop = (isset($crops[$i]) && is_array($crops[$i])) ? $crops[$i] : null;

      if ($ext === 'pdf'){
        try{ $doc->readImage($tmpPath); $added++; } catch(Exception $e){}
      } elseif (in_array($ext,['jpg','jpeg','png','gif','webp'])){
        if (_imagick_add_image_page($doc, $tmpPath, $crop)) $added++;
      }
      if (function_exists('gc_collect_cycles')) gc_collect_cycles();
    }

    if ($added > 0){
      $doc->setImageFormat('pdf');
      foreach($doc as $p){
        $p->setImageCompression(Imagick::COMPRESSION_JPEG);
        $p->setImageCompressionQuality(80);
        $p->setImageUnits(Imagick::RESOLUTION_PIXELSPERINCH);
        $p->setImageResolution(150,150);
      }
      $doc->writeImages($targetPdf, true);
      $doc->clear(); $doc->destroy();
      return file_exists($targetPdf) ? $targetPdf : '';
    }
    $doc->clear(); $doc->destroy();
    return '';
  }

  // --- Sin Imagick ---
  $pdfCount = 0; $firstPdfIdx = -1;
  foreach($names as $i=>$origName){
    $ext = strtolower(pathinfo($origName, PATHINFO_EXTENSION));
    if ($ext === 'pdf'){ $pdfCount++; if ($firstPdfIdx<0) $firstPdfIdx=$i; }
  }
  if ($pdfCount > 0){
    $tmpPath=$tmps[$firstPdfIdx];
    if (is_uploaded_file($tmpPath)){
      if (!@move_uploaded_file($tmpPath, $targetPdf)){ @copy($tmpPath, $targetPdf); }
      return file_exists($targetPdf) ? $targetPdf : '';
    }
    return '';
  }

  $pages=[];
  foreach($names as $i=>$origName){
    $tmpPath=$tmps[$i]; $size=(int)$sizes[$i];
    if ($size<=0 || !is_uploaded_file($tmpPath)) continue;
    $ext = strtolower(pathinfo($origName, PATHINFO_EXTENSION));
    if (!in_array($ext,['jpg','jpeg','png','gif','webp'])) continue;
    $crop = (isset($crops[$i]) && is_array($crops[$i])) ? $crops[$i] : null;
    $gd = _gd_image_to_jpeg_bytes($tmpPath, $ext, $crop);
    if ($gd && isset($gd['data'])){ $pages[] = ['data'=>$gd['data'],'w'=>$gd['w'],'h'=>$gd['h']]; }
    if (function_exists('gc_collect_cycles')) gc_collect_cycles();
  }
  if (!empty($pages)) {
    if (_build_multi_pdf_from_jpegs($pages, $targetPdf)) {
      return $targetPdf;
    }
  }
  return '';
}

// ======== 0) Determinar carpeta base Y subcarpeta por Mes-Año ========
$TARGET_DIR_BASE = "Files/Documentosgenerales_empleadosplanilla/";

// Tomamos la fecha_documento del registro (si existe) para decidir la carpeta
$fecha_documento_actual = '';
if ($idrecibido > 0){
  $rsf = mysqli_query($con, "SELECT fecha_documento FROM ingreso_documentosgenerales_empleadosplanilla WHERE id=$idrecibido LIMIT 1") or die(mysqli_error($con));
  if ($rsf && ($rowf = mysqli_fetch_assoc($rsf))) {
    $fecha_documento_actual = trim($rowf['fecha_documento'] ?? '');
  }
}
$subcarpeta = month_folder_from_date($fecha_documento_actual); // p.ej. "Octubre-2025"
$TARGET_DIR = rtrim($TARGET_DIR_BASE, '/').'/'.$subcarpeta.'/';

// ======== 1) Buscar archivo anterior y borrarlo (si hay uno) ========
$oldPath = '';
if ($idrecibido > 0){
  $rs = mysqli_query($con, "SELECT imagen1 FROM ingreso_documentosgenerales_empleadosplanilla WHERE id=$idrecibido LIMIT 1") or die(mysqli_error($con));
  if ($rs && ($row = mysqli_fetch_assoc($rs))) {
    $oldPath = trim($row['imagen1'] ?? '');
  }
  if ($oldPath !== '' && file_exists($oldPath)) {
    // Solo borrar si está dentro de la carpeta base esperada
    $realBase = realpath($TARGET_DIR_BASE); // base, no subcarpeta
    $realOld  = realpath($oldPath);
    if ($realBase && $realOld && strpos($realOld, $realBase) === 0) {
      @unlink($realOld);
    }
  }
}

// ======== 2) Construir nuevo PDF desde los adjuntos (en la subcarpeta) ========
$newPdf = construirPDFAdjunto($TARGET_DIR, 'imagen1', $crop_json_list);

// Si no hubo archivos nuevos válidos, conservamos el viejo (no lo vuelvas a borrar)
if ($newPdf === '') {
  echo "<script>alert('No se adjuntaron archivos válidos.');</script>";
  echo "<script>document.location='consulta_documentosgenerales_empleadosplanilla.php'</script>";
  exit;
}

// ======== 3) Guardar ruta nueva en la BD ========
$newPdfEsc = mysqli_real_escape_string($con, $newPdf);
mysqli_query($con, "UPDATE ingreso_documentosgenerales_empleadosplanilla SET imagen1='$newPdfEsc' WHERE id=$idrecibido") or die(mysqli_error($con));

// ======== 4) Redirección (tu estilo) ========
echo "<script>alert('Image replacement completed.');window.location.href='consulta_documentosgenerales_empleadosplanilla.php';</script>";
exit;
