<?php
// ====== PHP 8.1.33: Enviar todo tal cual y convertir adjuntos a PDF (con recortes) ======
// Ahora guarda en subcarpetas por Mes-Año según fecha_documento.

// Debug en pruebas (pon 0 en producción)
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);

// Recursos (ajusta a tu hosting)
ini_set('memory_limit', '1024M');  // 1GB
set_time_limit(120);               // 2 min

// Sesión una sola vez
if (session_status() !== PHP_SESSION_ACTIVE) {
  session_start();
}

include('dbcon.php');

$idsucursal = isset($_SESSION['idsucursal']) ? $_SESSION['idsucursal'] : '';

// -------- Inputs con defaults (NO se normaliza) --------
$idempleado       = isset($_POST["idempleado"])? $_POST["idempleado"] : "";
$fecha_documento  = isset($_POST["fecha_documento"]) ? $_POST["fecha_documento"] : date('Y-m-d');
$desde            = isset($_POST["desde"]) ? $_POST["desde"] : '';
$hasta            = isset($_POST["hasta"]) ? $_POST["hasta"] : '';
$empleado         = isset($_POST["empleado"]) ? $_POST["empleado"] : '';
$motivo           = isset($_POST["motivo"]) ? $_POST["motivo"] : '';
$cantidad_dias    = isset($_POST["cantidad_dias"]) ? $_POST["cantidad_dias"] : 0;
$feriados_json    = isset($_POST["feriados_json"]) ? $_POST["feriados_json"] : "[]";
$crop_json_list   = isset($_POST["crop_json_list"]) ? $_POST["crop_json_list"] : "[]"; // <<--- RECORTES

// NUEVO: tipo_ausencia (ej: Vacaciones, Permiso, etc.)
$tipo_ausencia    = isset($_POST["tipo_ausencia"]) ? $_POST["tipo_ausencia"] : 'Vacaciones';

$ideliminar = isset($_GET["id"])? $_GET["id"] : "";

date_default_timezone_set('America/Costa_Rica');
$hora_creacion  = date('H:i');
$fecha_creacion = date('Y-m-d');

/* ==================== Utilidades Mes-Año ==================== */
function month_name_es($m){
  static $N = [1=>'Enero','Febrero','Marzo','Abril','Mayo','Junio','Julio','Agosto','Septiembre','Octubre','Noviembre','Diciembre'];
  $mi = (int)$m;
  return isset($N[$mi]) ? $N[$mi] : 'Desconocido';
}
function month_folder_from_date($datestr){
  if (!$datestr || !preg_match('/^\d{4}-\d{2}-\d{2}$/', $datestr)) {
    $datestr = date('Y-m-d');
  }
  [$Y,$m,$d] = explode('-', $datestr);
  return month_name_es((int)$m) . '-' . $Y; // p.ej. "Octubre-2025"
}

/* ==================== FERIADOS ==================== */
function guardarFeriados($con, $idvacacion, $feriados_json, $desde, $hasta){
  $arr = json_decode($feriados_json, true);
  if (!is_array($arr)) return;

  foreach ($arr as $f){
    if (!preg_match('/^\d{4}-\d{2}-\d{2}$/', $f)) continue;
    if ($desde !== '' && $f < $desde) continue;
    if ($hasta !== '' && $f > $hasta) continue;

    $w = (int)date('w', strtotime($f)); // 0=Dom, 6=Sáb
    if ($w === 0 || $w === 6) continue;

    $f_sql = mysqli_real_escape_string($con, $f);
    mysqli_query(
      $con,
      "INSERT IGNORE INTO vacaciones_feriados (idvacacion, fecha)
       VALUES (".intval($idvacacion).", '$f_sql')"
    );
  }
}

/* ==================== Limits Imagick (opcional) ==================== */
if (class_exists('Imagick')) {
  $rl = new Imagick();
  $rl->setResourceLimit(Imagick::RESOURCETYPE_MEMORY, 256);
  $rl->setResourceLimit(Imagick::RESOURCETYPE_MAP, 256);
  $rl->clear(); $rl->destroy();
}

/* ==================== Helpers PDF/Imagen ==================== */
function _parse_crop_list($json){ $d=json_decode($json,true); return is_array($d)?$d:[]; }
function _clampv($v,$min,$max){ return max($min, min($max, (int)$v)); }

// Versión anti-imágenes gigantes (Imagick) + CROP/ROTATE
function _imagick_add_image_page($doc, $tmp, $crop=null){
  $probe = new Imagick(); $probe->pingImage($tmp);
  $w = (int)$probe->getImageWidth(); $h = (int)$probe->getImageHeight();
  $probe->clear(); $probe->destroy();

  $img = new Imagick(); $img->readImage($tmp);

  if (is_array($crop) && isset($crop['rotate']) && abs((float)$crop['rotate']) > 0.01) {
    $img->rotateImage(new ImagickPixel('white'), (float)$crop['rotate']);
  }
  if (is_array($crop) && !empty($crop['width']) && !empty($crop['height'])) {
    $iw=$img->getImageWidth(); $ih=$img->getImageHeight();
    $x=_clampv($crop['x']??0, 0, $iw-1);
    $y=_clampv($crop['y']??0, 0, $ih-1);
    $cw=_clampv($crop['width'], 1, $iw);
    $ch=_clampv($crop['height'],1, $ih);
    if ($x+$cw>$iw) $cw=$iw-$x;
    if ($y+$ch>$ih) $ch=$ih-$y;
    if ($cw>1 && $ch>1) { $img->cropImage($cw,$ch,$x,$y); $img->setImagePage(0,0,0,0); }
  }

  $MAX_PX = 40_000_000;
  $iw=$img->getImageWidth(); $ih=$img->getImageHeight();
  if (($w*$h) === 0) { $w=$iw; $h=$ih; }
  if (($iw*$ih) > $MAX_PX) { $img->sampleImage(3000, 3000, true); }

  if (method_exists($img, 'setImageAlphaChannel')) {
    $img->setImageAlphaChannel(Imagick::ALPHACHANNEL_REMOVE);
  }
  $img->setImageColorspace(Imagick::COLORSPACE_SRGB);

  $maxW=2500; $maxH=3500;
  $iw=$img->getImageWidth(); $ih=$img->getImageHeight();
  if ($iw>$maxW || $ih>$maxH) { $img->thumbnailImage($maxW,$maxH,true,true); }

  $img->setImageFormat('pdf');
  $img->setImageCompression(Imagick::COMPRESSION_JPEG);
  $img->setImageCompressionQuality(80);
  $img->setImageUnits(Imagick::RESOLUTION_PIXELSPERINCH);
  $img->setImageResolution(150,150);

  $doc->addImage($img);
  $img->clear(); $img->destroy();
  return true;
}

// GD: evita imágenes gigantes y libera memoria + CROP/ROTATE básico
function _gd_image_to_jpeg_bytes($tmp, $ext, $crop=null){
  $info = @getimagesize($tmp);
  if (!$info) return null;
  $wI = (int)$info[0]; $hI = (int)$info[1];
  $MAX_PX = 40_000_000;
  if (($wI * $hI) > $MAX_PX) return null;

  switch($ext){
    case 'jpg':case 'jpeg': $im=@imagecreatefromjpeg($tmp); break;
    case 'png': $im=@imagecreatefrompng($tmp); break;
    case 'gif': $im=@imagecreatefromgif($tmp); break;
    default: return null;
  }
  if(!$im) return null;

  if (is_array($crop) && isset($crop['rotate']) && abs((float)$crop['rotate']) > 0.01) {
    $bg = imagecolorallocate($im, 255, 255, 255);
    $rot = imagerotate($im, -(float)$crop['rotate'], $bg);
    if($rot){ imagedestroy($im); $im=$rot; }
  }

  $w=imagesx($im); $h=imagesy($im);
  if (is_array($crop) && !empty($crop['width']) && !empty($crop['height'])){
    $x=_clampv($crop['x']??0, 0, $w-1);
    $y=_clampv($crop['y']??0, 0, $h-1);
    $cw=_clampv($crop['width'], 1, $w);
    $ch=_clampv($crop['height'],1, $h);
    if ($x+$cw>$w) $cw=$w-$x;
    if ($y+$ch>$h) $ch=$h-$y;
    if ($cw>1 && $ch>1){
      $dst=imagecreatetruecolor($cw,$ch);
      imagecopyresampled($dst,$im,0,0,$x,$y,$cw,$ch,$cw,$ch);
      imagedestroy($im); $im=$dst; $w=$cw; $h=$ch;
    }
  }

  $maxW=2500; $maxH=3500;
  if ($w>$maxW || $h>$maxH){
    $ratio=min($maxW/$w,$maxH/$h);
    $nw=(int)round($w*$ratio); $nh=(int)round($h*$ratio);
    $res=imagecreatetruecolor($nw,$nh);
    imagecopyresampled($res,$im,0,0,0,0,$nw,$nh,$w,$h);
    imagedestroy($im); $im=$res; $w=$nw; $h=$nh;
  }

  @imagefilter($im, IMG_FILTER_CONTRAST, -10);
  @imagefilter($im, IMG_FILTER_BRIGHTNESS, 5);

  ob_start(); imagejpeg($im,null,80); $data=ob_get_clean();
  imagedestroy($im);
  if (function_exists('gc_collect_cycles')) gc_collect_cycles();

  return ['data'=>$data,'w'=>$w,'h'=>$h];
}

// Constructor PDF simple (GD → PDF)
function _build_multi_pdf_from_jpegs($pages, $targetPdf){
  $unit=72; $a4w=8.27*$unit; $a4h=11.69*$unit; $dpi=150.0;
  $pdf="%PDF-1.3\n"; $ofs=array(); $objNum=1;
  $ofs[] = strlen($pdf);
  $pdf .= ($objNum)." 0 obj<< /Type /Catalog /Pages 2 0 R >>endobj\n";
  $catalogObj=$objNum; $objNum++;
  $pagesObj=$objNum; $objNum++; $kids=array();
  foreach($pages as $pg){
    $w=$pg['w']; $h=$pg['h']; $imgData=$pg['data'];
    $imgWpt=($w/$dpi)*72.0; $imgHpt=($h/$dpi)*72.0;
    $scale=min($a4w*0.92/$imgWpt,$a4h*0.92/$imgHpt); if($scale<=0)$scale=1;
    $dw=$imgWpt*$scale; $dh=$imgHpt*$scale;
    $x=($a4w-$dw)/2; $y=($a4h-$dh)/2;

    $imgObj=$objNum++; $ofs[] = strlen($pdf);
    $pdf.=$imgObj." 0 obj<< /Type /XObject /Subtype /Image /Width ".intval($w)." /Height ".intval($h)." /ColorSpace /DeviceRGB /BitsPerComponent 8 /Filter /DCTDecode /Length ".strlen($imgData)." >>stream\n".$imgData."\nendstream\nendobj\n";

    $stream="q\n".sprintf('%.2f 0 0 %.2f %.2f %.2f cm',$dw,$dh,$x,$y)."\n/Im0 Do\nQ\n";
    $cntObj=$objNum++; $ofs[] = strlen($pdf);
    $pdf.=$cntObj." 0 obj<< /Length ".strlen($stream)." >>stream\n".$stream."endstream\nendobj\n";

    $pageObj=$objNum++; $ofs[] = strlen($pdf);
    $pdf.=$pageObj." 0 obj<< /Type /Page /Parent ".$pagesObj." 0 R /MediaBox [0 0 ".sprintf('%.2f %.2f',$a4w,$a4h)."] /Resources << /XObject << /Im0 ".$imgObj." 0 R >> /ProcSet [/PDF /ImageC] >> /Contents ".$cntObj." 0 R >>endobj\n";

    $kids[]=$pageObj." 0 R";
  }
  $ofs[] = strlen($pdf);
  $pdf.=$pagesObj." 0 obj<< /Type /Pages /Count ".count($kids)." /Kids [ ".implode(' ',$kids)." ] >>endobj\n";

  $xrefPos=strlen($pdf);
  $pdf.="xref\n0 ".($objNum)."\n0000000000 65535 f \n";
  foreach($ofs as $o){ $pdf.=sprintf("%010d 00000 n \n",$o); }
  $pdf.="trailer<< /Size ".($objNum)." /Root ".$catalogObj." 0 R >>\nstartxref\n".$xrefPos."\n%%EOF";
  return (bool)file_put_contents($targetPdf,$pdf);
}

/**
 * Convierte los archivos de $_FILES['imagen1'] en UN SOLO PDF aplicando CROP/ROTATE por archivo.
 * - Con Imagick: concatena PDFs + imágenes recortadas.
 * - Sin Imagick: 1 PDF → copia; varios PDFs → toma el primero; imágenes → PDF multipágina (GD).
 * Devuelve ruta del PDF final o ''.
 */
function construirPDFAdjunto($target_dir, $fieldName = 'imagen1', $crop_json_list = '[]'){
  if (!isset($_FILES[$fieldName])) return '';

  $isMultiple = is_array($_FILES[$fieldName]['name']);
  $names = $isMultiple ? $_FILES[$fieldName]['name'] : [ $_FILES[$fieldName]['name'] ];
  $tmps  = $isMultiple ? $_FILES[$fieldName]['tmp_name'] : [ $_FILES[$fieldName]['tmp_name'] ];
  $sizes = $isMultiple ? $_FILES[$fieldName]['size'] : [ $_FILES[$fieldName]['size'] ];

  $crops = _parse_crop_list($crop_json_list); // array indexado por i

  $hasAny = false;
  foreach ($names as $i=>$n) {
    if (!empty($n) && (int)$sizes[$i] > 0 && is_uploaded_file($tmps[$i])) { $hasAny = true; break; }
  }
  if (!$hasAny) return '';

  if (!is_dir($target_dir)) { @mkdir($target_dir, 0775, true); }
  $safePdf   = 'vac_'.date('Ymd_His').'_'.mt_rand(1000,9999).'.pdf';
  $targetPdf = rtrim($target_dir,'/').'/'.$safePdf;

  $useImagick = class_exists('Imagick');

  if ($useImagick){
    $doc = new Imagick();
    $added = 0;

    foreach($names as $i=>$origName){
      $tmpPath=$tmps[$i]; $size=(int)$sizes[$i];
      if ($size<=0 || !is_uploaded_file($tmpPath)) continue;

      $ext = strtolower(pathinfo($origName, PATHINFO_EXTENSION));
      $crop = (isset($crops[$i]) && is_array($crops[$i])) ? $crops[$i] : null;

      if ($ext === 'pdf'){
        try{ $doc->readImage($tmpPath); $added++; }catch(Exception $e){}
      } else if (in_array($ext,['jpg','jpeg','png','gif'])){
        if (_imagick_add_image_page($doc, $tmpPath, $crop)) $added++;
      }
      if (function_exists('gc_collect_cycles')) gc_collect_cycles();
    }

    if ($added > 0){
      $doc->setImageFormat('pdf');
      foreach($doc as $p){
        $p->setImageCompression(Imagick::COMPRESSION_JPEG);
        $p->setImageCompressionQuality(80);
        $p->setImageUnits(Imagick::RESOLUTION_PIXELSPERINCH);
        $p->setImageResolution(150,150);
      }
      $doc->writeImages($targetPdf, true);
      $doc->clear(); $doc->destroy();
      return file_exists($targetPdf) ? $targetPdf : '';
    }
    $doc->clear(); $doc->destroy();
    return '';
  }

  // --- Sin Imagick ---
  $pdfCount = 0; $firstPdfIdx = -1;
  foreach($names as $i=>$origName){
    $ext = strtolower(pathinfo($origName, PATHINFO_EXTENSION));
    if ($ext === 'pdf'){ $pdfCount++; if ($firstPdfIdx<0) $firstPdfIdx=$i; }
  }
  if ($pdfCount > 0){
    $tmpPath=$tmps[$firstPdfIdx];
    if (is_uploaded_file($tmpPath)){
      if (!@move_uploaded_file($tmpPath, $targetPdf)){ @copy($tmpPath, $targetPdf); }
      return file_exists($targetPdf) ? $targetPdf : '';
    }
    return '';
  }

  $pages=[];
  foreach($names as $i=>$origName){
    $tmpPath=$tmps[$i]; $size=(int)$sizes[$i];
    if ($size<=0 || !is_uploaded_file($tmpPath)) continue;
    $ext = strtolower(pathinfo($origName, PATHINFO_EXTENSION));
    if (!in_array($ext,['jpg','jpeg','png','gif'])) continue;
    $crop = (isset($crops[$i]) && is_array($crops[$i])) ? $crops[$i] : null;
    $gd = _gd_image_to_jpeg_bytes($tmpPath, $ext, $crop);
    if ($gd && isset($gd['data'])){ $pages[] = ['data'=>$gd['data'],'w'=>$gd['w'],'h'=>$gd['h']]; }
    if (function_exists('gc_collect_cycles')) gc_collect_cycles();
  }
  if (!empty($pages)) {
    if (_build_multi_pdf_from_jpegs($pages, $targetPdf)) {
      return $targetPdf;
    }
  }
  return '';
}

/* ==================== Subcarpeta por Mes-Año (según fecha_documento) ==================== */
$TARGET_DIR_BASE = "Files/Ingreso_vacaciones/";              // carpeta base
$SUBFOLDER       = month_folder_from_date($fecha_documento); // p.ej. "Octubre-2025"
$target_dir      = rtrim($TARGET_DIR_BASE,'/').'/'.$SUBFOLDER.'/';
if (!is_dir($target_dir)) { @mkdir($target_dir, 0775, true); }

/* ==================== Subir/Construir PDF ==================== */
$imagen1 = construirPDFAdjunto($target_dir, 'imagen1', $crop_json_list);  // '' si no hay adjuntos válidos

/* ==================== CONTEXTO ORIGINAL (tu flujo) ==================== */
$impuesto=0;
$q=mysqli_query($con,"SELECT * FROM global") or die(mysqli_error($con));
while($r=mysqli_fetch_array($q)){ $impuesto=$r['porcentaje_impuesto']; }

$q=mysqli_query($con,"SELECT * FROM inventario ORDER BY id ASC") or die(mysqli_error($con));
while($r=mysqli_fetch_array($q)){ $codigox=$r['id']+101; }

if ($idempleado !== '' && $idsucursal !== ''){
  $idempleado_esc = mysqli_real_escape_string($con,$idempleado);
  $idsucursal_esc = mysqli_real_escape_string($con,$idsucursal);
  $q=mysqli_query($con,"SELECT * FROM usuario WHERE idempleado='$idempleado_esc' AND idsucursal='$idsucursal_esc'") or die(mysqli_error($con));
  while($r=mysqli_fetch_array($q)){
    $idusuario=$r['idusuario'];
    $nombre=$r['nombre'];
    $apellidos=$r['apellidos'];
  }
}

if ($ideliminar !== ''){
  $ideliminar_esc = mysqli_real_escape_string($con,$ideliminar);
  mysqli_query($con,"DELETE FROM inventario WHERE id='$ideliminar_esc'") or die(mysqli_error($con));
}

/* ==================== INSERT TAL CUAL ==================== */
$sql = "INSERT INTO ingreso_vacaciones(
  fecha_documento,
  fecha_desde,
  fecha_hasta,
  idempleado,
  motivo,
  cantidad_dias,
  status,
  imagen1,
  tipo_ausencia
) VALUES (
  '".mysqli_real_escape_string($con,$fecha_documento)."',
  '".mysqli_real_escape_string($con,$desde)."',
  '".mysqli_real_escape_string($con,$hasta)."',
  '".mysqli_real_escape_string($con,$empleado)."',
  '".mysqli_real_escape_string($con,$motivo)."',
  '".mysqli_real_escape_string($con,$cantidad_dias)."',
  '1',
  '".mysqli_real_escape_string($con,$imagen1)."',
  '".mysqli_real_escape_string($con,$tipo_ausencia)."'
)";
mysqli_query($con, $sql) or die(mysqli_error($con));

$idvacacion = mysqli_insert_id($con);
guardarFeriados($con, $idvacacion, $feriados_json, $desde, $hasta);

/* ==================== REDIRECCIONES (tu estilo) ==================== */
if (isset($idusuario) && isset($idsucursal)) {
  echo "<script>document.location='consulta_vacaciones.php?idusuario=$idusuario&idsucursal=$idsucursal'</script>";
} else {
  echo "<script>document.location='consulta_vacaciones.php'</script>";
}

$idingreso=0;
$idarticulo=0;
$q=mysqli_query($con,"SELECT * FROM ingreso") or die(mysqli_error($con));
while($r=mysqli_fetch_array($q)){ $idingreso=$r['idingreso']; }
$q=mysqli_query($con,"SELECT * FROM articulo") or die(mysqli_error($con));
while($r=mysqli_fetch_array($q)){ $idarticulo=$r['idarticulo']; }

echo "<script>document.location='paso2.php'</script>";
