<?php
session_start();
require_once 'dbcon.php';

// Fuerza UTF-8 en la conexión
if (isset($con) && $con instanceof mysqli) {
  mysqli_set_charset($con, 'utf8mb4');
}

/* --------- ENTRADAS --------- */
$idempleado      = isset($_POST['idempleado']) ? (int)$_POST['idempleado'] : 0; // NECESARIO
$fecha_documento = $_POST["fecha_documento"] ?? date('Y-m-d');
$descripcion     = $_POST["descripcion"]     ?? '';
$comentario      = $_POST["comentario"]      ?? '';
$drive_url       = isset($_POST['imagen1']) ? trim($_POST['imagen1']) : '';

/* --------- Cálculo subcarpeta Mes-Año --------- */
$ts  = strtotime($fecha_documento ?: 'now');
$mes = (int)date('n', $ts);
$ano = date('Y', $ts);
$meses = [1=>'Enero',2=>'Febrero',3=>'Marzo',4=>'Abril',5=>'Mayo',6=>'Junio',7=>'Julio',8=>'Agosto',9=>'Septiembre',10=>'Octubre',11=>'Noviembre',12=>'Diciembre'];
$subfolder = ($meses[$mes] ?? date('m', $ts)) . '-' . $ano;

/* --------- Rutas base (FS y DB) --------- */
$base_rel = "Files/Formatos";
$target_dir_db = $base_rel . "/" . $subfolder . "/";                 // para la BD
$target_dir_fs = rtrim(__DIR__, '/\\') . "/" . $target_dir_db;       // en disco

// Asegurar carpeta
if (!is_dir($target_dir_fs)) {
  @mkdir($target_dir_fs, 0755, true);
}

/* --------- UPLOAD / LINK --------- */
$allowed_ext = ['pdf','png','jpg','jpeg','gif','doc','docx','xls','xlsx','ppt','pptx','zip','txt'];

$imagen1 = '';
if (!empty($_FILES['imagen1']['name']) && is_uploaded_file($_FILES['imagen1']['tmp_name'])) {
  $original = $_FILES['imagen1']['name'];
  $ext = strtolower(pathinfo($original, PATHINFO_EXTENSION));
  if (!in_array($ext, $allowed_ext)) {
    die("Archivo no permitido (.$ext).");
  }
  if ($_FILES['imagen1']['size'] > 50*1024*1024) {
    die("El archivo excede 50MB.");
  }

  // Nombre único
  $unique  = 'fmt_' . date('Ymd_His') . '_' . mt_rand(1000,9999) . '.' . $ext;
  $dest_fs = $target_dir_fs . $unique;  // ruta en disco
  $dest_db = $target_dir_db . $unique;  // ruta relativa para guardar en BD

  if (!move_uploaded_file($_FILES['imagen1']['tmp_name'], $dest_fs)) {
    die("No se pudo guardar el archivo subido.");
  }
  $imagen1 = $dest_db;

} elseif (!empty($drive_url)) {
  // Acepta enlaces de Google Drive/Docs
  if (!preg_match('#^https?://(docs|drive)\.google\.com/[^ \r\n]+#i', $drive_url)) {
    die("El enlace de Google Drive no es válido.");
  }
  $imagen1 = $drive_url;

} else {
  die("Debes subir un archivo o pegar un enlace de Google Drive.");
}

/* --------- INSERT (incluye idempleado) --------- */
$sql = "INSERT INTO ingreso_formatos
          (fecha_documento, descripcion, comentario, imagen1, idempleado)
        VALUES (?,?,?,?,?)";
$stmt = $con->prepare($sql);
if (!$stmt) {
  die("No se pudo preparar el guardado: ".$con->error);
}
$stmt->bind_param("ssssi", $fecha_documento, $descripcion, $comentario, $imagen1, $idempleado);

if (!$stmt->execute()) {
  die("No se pudo guardar el registro: ".$stmt->error);
}
$stmt->close();

/* --------- REDIRECCIÓN --------- */
echo "<script>document.location='consulta_formatos.php'</script>";
exit;
