<?php
session_start();
// --- DEBUG LOCAL (quítalo en producción) ---
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
ini_set('log_errors', '1');
ini_set('error_reporting', (string)E_ALL);
ini_set('error_log', '/home/jportales/logs/php-error.log');

include('dbcon.php');

$idsucursal = $_SESSION['idsucursal'] ?? '';

$idempleado      = $_POST["idempleado"]      ?? "";
$fecha_documento = $_POST["fecha_documento"] ?? date('Y-m-d'); // ← usaremos esta fecha para la subcarpeta
$descripcion     = $_POST["descripcion"]     ?? "";
$comentario      = $_POST["comentario"]      ?? "";
$empleado        = $_POST["empleado"]        ?? ""; // id colaborador
$categoria       = $_POST["categoria"]       ?? "";
$cantidad_dias   = $_POST["cantidad_dias"]   ?? "";

// ====== Cargas varias (flujo original) ======
$impuesto=0;
$q=mysqli_query($con,"select * from global")or die(mysqli_error($con));
while($r=mysqli_fetch_array($q)){ $impuesto=$r['porcentaje_impuesto']; }
$q=mysqli_query($con,"select * from inventario order by id asc")or die(mysqli_error($con));
while($r=mysqli_fetch_array($q)){ $codigox=$r['id']+101; }

$q=mysqli_query($con,"select * from usuario where idempleado='$idempleado' and idsucursal='$idsucursal' ")or die(mysqli_error($con));
while($r=mysqli_fetch_array($q)){
  $idusuario=$r['idusuario'];
  $nombre   =$r['nombre'];
  $apellidos=$r['apellidos'];
}

$ideliminar = $_GET["id"] ?? "";
$q=mysqli_query($con,"select * from inventario where id='$ideliminar' ")or die(mysqli_error($con));
while($r=mysqli_fetch_array($q)){ $imagen12=$r['imagen1']; }

$idcategoria = 1; $idunidad_medida = 1; $costo = 0; $venta = 0;

date_default_timezone_set('America/Costa_Rica');
$hora_creacion  = date('H:i');
$fecha_creacion = date('Y-m-d');

$idproveedor = 1;

$stock_ingreso = $_POST['stock_ingreso']   ?? "";
$stock_actual  = $stock_ingreso;
$precio_compra = $_POST['precio_compra']   ?? "";
$precio_ventapublico = $_POST['venta']     ?? "";
$codigo        = $_POST['codigo']          ?? "";
$stock_minimo  = $_POST['stock_minimo']    ?? "";
$serie         = $_POST['serie']           ?? "";
$precio_ventadistribuidor = 1;

/* ========= Subcarpeta Mes-Año para Documentos ========= */
function month_name_es($m){
  static $N=[1=>'Enero','Febrero','Marzo','Abril','Mayo','Junio','Julio','Agosto','Septiembre','Octubre','Noviembre','Diciembre'];
  $mi=(int)$m; return $N[$mi] ?? 'Desconocido';
}
function month_folder_from_date($datestr){
  if (!preg_match('/^\d{4}-\d{2}-\d{2}$/', (string)$datestr)) $datestr=date('Y-m-d');
  [$Y,$m]=explode('-', substr($datestr,0,7));
  return month_name_es((int)$m).'-'.$Y; // ej: Octubre-2025
}

$BASE_DIR = "Files/Documentos_empleadosplanilla/";
$SUB_DIR  = month_folder_from_date($fecha_documento);
$target_dir = rtrim($BASE_DIR,'/').'/'.$SUB_DIR.'/';
if (!is_dir($target_dir)) { @mkdir($target_dir, 0775, true); }

/* ================= Helpers ================= */
function _clampv($v,$min,$max){ return max($min, min($max, $v)); }
function _parse_crop_list($json){
  $d=@json_decode($json,true);
  return is_array($d) ? $d : [];
}
function _imagick_add_image_page($doc, $tmp, $ext, $crop){
  $img = new Imagick();
  $img->readImage($tmp);
  if (method_exists($img,'setImageColorspace')) $img->setImageColorspace(Imagick::COLORSPACE_SRGB);
  if (method_exists($img,'setImageAlphaChannel')) $img->setImageAlphaChannel(Imagick::ALPHACHANNEL_REMOVE);

  if ($crop && isset($crop['rotate']) && abs($crop['rotate'])>0.01) {
    $img->rotateImage(new ImagickPixel('white'), (float)$crop['rotate']);
  }
  if ($crop && !empty($crop['width']) && !empty($crop['height'])) {
    $w=$img->getImageWidth(); $h=$img->getImageHeight();
    $x=_clampv((int)($crop['x']??0),0,$w);
    $y=_clampv((int)($crop['y']??0),0,$h);
    $cw=_clampv((int)($crop['width']??0),1,$w);
    $ch=_clampv((int)($crop['height']??0),1,$h);
    if ($x+$cw>$w) $cw=$w-$x; if ($y+$ch>$h) $ch=$h-$y;
    if ($cw>1 && $ch>1) { $img->cropImage($cw,$ch,$x,$y); $img->setImagePage(0,0,0,0); }
  }
  if (method_exists($img,'autoLevelImage')) $img->autoLevelImage();
  if (method_exists($img,'unsharpMaskImage')) $img->unsharpMaskImage(0.8,0.5,1.2,0.05);

  $maxW=2500; $maxH=3500;
  $w=$img->getImageWidth(); $h=$img->getImageHeight();
  if ($w>$maxW || $h>$maxH) { $img->thumbnailImage($maxW,$maxH,true,true); }

  $img->setImageUnits(Imagick::RESOLUTION_PIXELSPERINCH);
  $img->setImageResolution(150,150);
  $img->setImageFormat('pdf');
  $doc->addImage($img);
  return true;
}
function _gd_image_to_jpeg_bytes($tmp, $ext, $crop){
  switch($ext){
    case 'jpg':case 'jpeg': $im=@imagecreatefromjpeg($tmp); break;
    case 'png': $im=@imagecreatefrompng($tmp); break;
    case 'gif': $im=@imagecreatefromgif($tmp); break;
    default: return null;
  }
  if(!$im) return null;
  $w=imagesx($im); $h=imagesy($im);
  if ($crop && !empty($crop['width']) && !empty($crop['height'])){
    $x=_clampv((int)$crop['x'],0,$w);
    $y=_clampv((int)$crop['y'],0,$h);
    $cw=_clampv((int)$crop['width'],1,$w);
    $ch=_clampv((int)$crop['height'],1,$h);
    if ($x+$cw>$w) $cw=$w-$x; if ($y+$ch>$h) $ch=$h-$y;
    $dst=imagecreatetruecolor($cw,$ch);
    imagecopyresampled($dst,$im,0,0,$x,$y,$cw,$ch,$cw,$ch);
    imagedestroy($im); $im=$dst; $w=$cw; $h=$ch;
  }
  @imagefilter($im, IMG_FILTER_CONTRAST, -10);
  @imagefilter($im, IMG_FILTER_BRIGHTNESS, 5);
  $maxW=2500; $maxH=3500;
  if ($w>$maxW || $h>$maxH){
    $ratio=min($maxW/$w,$maxH/$h);
    $nw=(int)round($w*$ratio); $nh=(int)round($h*$ratio);
    $res=imagecreatetruecolor($nw,$nh);
    imagecopyresampled($res,$im,0,0,0,0,$nw,$nh,$w,$h);
    imagedestroy($im); $im=$res; $w=$nw; $h=$nh;
  }
  ob_start(); imagejpeg($im,null,80); $data=ob_get_clean();
  imagedestroy($im);
  return ['data'=>$data,'w'=>$w,'h'=>$h];
}
function _build_multi_pdf_from_jpegs($pages, $targetPdf){
  $unit=72; $a4w=8.27*$unit; $a4h=11.69*$unit; $dpi=150.0;
  $pdf="%PDF-1.3\n"; $ofs=array(); $objNum=1;
  $ofs[] = strlen($pdf);
  $pdf .= ($objNum)." 0 obj<< /Type /Catalog /Pages 2 0 R >>endobj\n";
  $catalogObj=$objNum; $objNum++;
  $pagesObj=$objNum; $objNum++; $kids=array();
  foreach($pages as $pg){
    $w=$pg['w']; $h=$pg['h']; $imgData=$pg['data'];
    $imgWpt=($w/$dpi)*72.0; $imgHpt=($h/$dpi)*72.0;
    $scale=min($a4w*0.92/$imgWpt,$a4h*0.92/$imgHpt); if($scale<=0)$scale=1;
    $dw=$imgWpt*$scale; $dh=$imgHpt*$scale;
    $x=($a4w-$dw)/2; $y=($a4h-$dh)/2;
    $imgObj=$objNum++; $ofs[] = strlen($pdf);
    $pdf.=$imgObj." 0 obj<< /Type /XObject /Subtype /Image /Width ".intval($w)." /Height ".intval($h)." /ColorSpace /DeviceRGB /BitsPerComponent 8 /Filter /DCTDecode /Length ".strlen($imgData)." >>stream\n".$imgData."\nendstream\nendobj\n";
    $stream="q\n".sprintf('%.2f 0 0 %.2f %.2f %.2f cm',$dw,$dh,$x,$y)."\n/Im0 Do\nQ\n";
    $cntObj=$objNum++; $ofs[] = strlen($pdf);
    $pdf.=$cntObj." 0 obj<< /Length ".strlen($stream)." >>stream\n".$stream."endstream\nendobj\n";
    $pageObj=$objNum++; $ofs[] = strlen($pdf);
    $pdf.=$pageObj." 0 obj<< /Type /Page /Parent ".$pagesObj." 0 R /MediaBox [0 0 ".sprintf('%.2f %.2f',$a4w,$a4h)."] /Resources << /XObject << /Im0 ".$imgObj." 0 R >> /ProcSet [/PDF /ImageC] >> /Contents ".$cntObj." 0 R >>endobj\n";
    $kids[]=$pageObj." 0 R";
  }
  $ofs[] = strlen($pdf);
  $pdf.=$pagesObj." 0 obj<< /Type /Pages /Count ".count($kids)." /Kids [ ".implode(' ',$kids)." ] >>endobj\n";
  $xrefPos=strlen($pdf);
  $pdf.="xref\n0 ".($objNum)."\n0000000000 65535 f \n";
  foreach($ofs as $o){ $pdf.=sprintf("%010d 00000 n \n",$o); }
  $pdf.="trailer<< /Size ".($objNum)." /Root ".$catalogObj." 0 R >>\nstartxref\n".$xrefPos."\n%%EOF";
  return (bool)file_put_contents($targetPdf,$pdf);
}

/* ============ Subida de archivos (opcional) ============ */
$imagen1   = "";
$final_path= "";

$hasUploads = false;
if (isset($_FILES['imagen1']) && is_array($_FILES['imagen1']['name'])) {
  foreach ($_FILES['imagen1']['name'] as $i => $n) {
    if (!empty($n) && (int)$_FILES['imagen1']['size'][$i] > 0 && is_uploaded_file($_FILES['imagen1']['tmp_name'][$i])) { $hasUploads = true; break; }
  }
}

if ($hasUploads){
  $names = $_FILES['imagen1']['name'];
  $tmps  = $_FILES['imagen1']['tmp_name'];
  $sizes = $_FILES['imagen1']['size'];
  $crop_list = _parse_crop_list($_POST['crop_json_list'] ?? '[]');

  // ← ahora dentro de la subcarpeta Mes-Año
  $safePdf   = 'docempl_'.date('Ymd_His').'_'.mt_rand(1000,9999).'.pdf';
  $targetPdf = rtrim($target_dir,'/').'/'.$safePdf;

  $useImagick = class_exists('Imagick');
  if ($useImagick){
    $doc = new Imagick(); $added = 0;
    foreach($names as $i=>$origName){
      if (!$origName) continue;
      $tmpPath=$tmps[$i]; $size=(int)$sizes[$i];
      if ($size<=0 || !is_uploaded_file($tmpPath)) continue;
      if ($size>50000000) continue;
      $ext = strtolower(pathinfo($origName, PATHINFO_EXTENSION));
      $crop = (isset($crop_list[$i]) && is_array($crop_list[$i])) ? $crop_list[$i] : null;

      if ($ext === 'pdf'){
        try { $doc->readImage($tmpPath); $added++; } catch(Exception $e){}
      } else {
        if (_imagick_add_image_page($doc, $tmpPath, $ext, $crop)) $added++;
      }
    }
    if ($added>0){
      $doc->setImageFormat('pdf');
      foreach($doc as $p){
        $p->setImageCompression(Imagick::COMPRESSION_JPEG);
        $p->setImageCompressionQuality(80);
        $p->setImageUnits(Imagick::RESOLUTION_PIXELSPERINCH);
        $p->setImageResolution(150,150);
      }
      $doc->writeImages($targetPdf, true);
      if (file_exists($targetPdf)) $final_path = $targetPdf;
    }
    $doc->clear(); $doc->destroy();

  } else {
    // Sin Imagick
    $onlyImages = true; $singlePdfIndex=-1; $pdfCount=0;
    foreach($names as $i=>$origName){
      $ext = strtolower(pathinfo($origName, PATHINFO_EXTENSION));
      if ($ext === 'pdf'){ $onlyImages=false; $pdfCount++; $singlePdfIndex=$i; }
    }
    if ($pdfCount>1){
      $final_path = '';
    } elseif ($pdfCount===1 && !$onlyImages){
      $tmpPath=$tmps[$singlePdfIndex]; $size=(int)$sizes[$singlePdfIndex];
      if($size>0 && is_uploaded_file($tmpPath)){
        if (!@move_uploaded_file($tmpPath, $targetPdf)) { @copy($tmpPath, $targetPdf); }
        if (file_exists($targetPdf)) $final_path = $targetPdf;
      }
    } else {
      $pages=[];
      foreach($names as $i=>$origName){
        $tmpPath=$tmps[$i]; $size=(int)$sizes[$i];
        if ($size<=0 || !is_uploaded_file($tmpPath)) continue;
        if ($size>50000000) continue;
        $ext = strtolower(pathinfo($origName, PATHINFO_EXTENSION));
        if (!in_array($ext,['jpg','jpeg','png','gif'])) continue;
        $crop = (isset($crop_list[$i]) && is_array($crop_list[$i])) ? $crop_list[$i] : null;
        $gd = _gd_image_to_jpeg_bytes($tmpPath, $ext, $crop);
        if ($gd && isset($gd['data'])){ $pages[] = ['data'=>$gd['data'],'w'=>$gd['w'],'h'=>$gd['h']]; }
      }
      if (!empty($pages)) {
        if (_build_multi_pdf_from_jpegs($pages, $targetPdf) && file_exists($targetPdf)) { $final_path = $targetPdf; }
      }
    }
  }
  $imagen1 = ($final_path && file_exists($final_path)) ? $final_path : "";
}

/* ===== Limpieza inventario ===== */
if ($ideliminar!==""){
  mysqli_query($con,"DELETE from inventario where id='".mysqli_real_escape_string($con,$ideliminar)."'")or die(mysqli_error($con));
}

/* ===== INSERT ===== */
mysqli_query($con,"INSERT INTO ingreso_documentos_empleadosplanilla(
  fecha_documento,
  idempleado,
  categoria,
  descripcion,
  comentario,
  imagen1
) VALUES (
  '".mysqli_real_escape_string($con,$fecha_documento)."',
  '".mysqli_real_escape_string($con,$empleado)."',
  '".mysqli_real_escape_string($con,$categoria)."',
  '".mysqli_real_escape_string($con,$descripcion)."',
  '".mysqli_real_escape_string($con,$comentario)."',
  '".mysqli_real_escape_string($con,$imagen1)."'
)")or die(mysqli_error($con));

/* ===== Redirecciones ===== */
echo "<script>document.location='consulta_documentos_empleadosplanilla.php'</script>";

$idingreso=0; $idarticulo=0;
$q=mysqli_query($con,"select * from ingreso")or die(mysqli_error($con));
while($r=mysqli_fetch_array($q)){ $idingreso=$r['idingreso']; }
$q=mysqli_query($con,"select * from articulo")or die(mysqli_error($con));
while($r=mysqli_fetch_array($q)){ $idarticulo=$r['idarticulo']; }

echo "<script>document.location='paso2.php'</script>";
