<?php
// =====================================================
// add_empleadosplanilla.php — PHP 8.1, con DEBUG seguro
// =====================================================

// 1) Búfer de salida: evita "headers already sent"
ob_start();

// 2) DEBUG: activar con ?debug=1 o input hidden name="debug" value="1"
$__DEBUG = (isset($_REQUEST['debug']) && $_REQUEST['debug'] === '1');

if ($__DEBUG) {
  ini_set('display_errors', '1');
  ini_set('display_startup_errors', '1');
  error_reporting(E_ALL);
  if (function_exists('mysqli_report')) {
    mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
  }
} else {
  ini_set('display_errors', '0');
  error_reporting(E_ALL);
  if (function_exists('mysqli_report')) {
    mysqli_report(MYSQLI_REPORT_OFF);
  }
}

// 3) Manejadores de errores/excepciones
set_exception_handler(function(Throwable $e) use ($__DEBUG) {
  if ($__DEBUG) {
    if (!headers_sent()) header('Content-Type: text/plain; charset=UTF-8');
    http_response_code(500);
    echo "\n[EXCEPTION] ".$e->getMessage()."\n";
    echo "Archivo: ".$e->getFile().":".$e->getLine()."\n";
    echo $e->getTraceAsString()."\n";
  } else {
    http_response_code(500);
  }
  if (ob_get_level()) { ob_end_flush(); }
  exit;
});
set_error_handler(function($severity, $message, $file, $line) use ($__DEBUG) {
  if (!(error_reporting() & $severity)) return;
  throw new ErrorException($message, 0, $severity, $file, $line);
});

// 4) Sesión ANTES de cualquier echo/cabecera
session_start();

// 5) Ahora sí, podemos anunciar el modo debug
if ($__DEBUG) {
  if (!headers_sent()) header('Content-Type: text/plain; charset=UTF-8');
  echo "== MODO DEBUG ACTIVADO ==\n";
}

// 6) App: dependencias y config
include('dbcon.php');
date_default_timezone_set('America/Costa_Rica');

$idsucursal = $_SESSION['idsucursal'] ?? '';

// 7) Helpers para construir valores SQL
// s(): STRING/VARCHAR -> '' si viene vacío (mandar vacío), o 'valor' escapado
function s(mysqli $con, $v): string {
  if ($v === null) $v = '';
  $v = trim((string)$v);
  if ($v === '') return "''";
  return "'".mysqli_real_escape_string($con, $v)."'";
}
// d(): INT -> NULL si vacío/no numérico; número sin comillas si válido
function d($v): string {
  if ($v === null) return "NULL";
  if (is_string($v)) $v = trim($v);
  if ($v === '' || !is_numeric($v)) return "NULL";
  return (string)(int)$v;
}
// f(): DATE -> NULL si vacío; 'YYYY-MM-DD' si trae valor
function f(mysqli $con, $v): string {
  if ($v === null) return "NULL";
  $v = trim((string)$v);
  if ($v === '') return "NULL";
  return "'".mysqli_real_escape_string($con, $v)."'";
}
// m(): MONTO DECIMAL -> NULL si vacío, número válido si viene
function m($v): string {
  if ($v === null) return "0";
  if (is_string($v)) {
    $v = trim($v);
    if ($v === '') return "0";
    $v = str_replace([' ', ','], ['', '.'], $v);
  }
  if (!is_numeric($v)) return "0";
  return (string)$v; // SIN comillas
}


// 8) POST (con defaults para evitar notices)
$idempleado         = $_POST["idempleado"]         ?? '';
$nombre_completo    = $_POST["nombre_completo"]    ?? '';
$tipo_documento     = $_POST["tipo_documento"]     ?? '';
$cedula             = $_POST["cedula"]             ?? '';
$nacionalidad       = $_POST["nacionalidad"]       ?? '';
$sumar              = $_POST["sumar"]              ?? '';    // d('') => NULL
$restar             = $_POST["restar"]             ?? '';    // d('') => NULL
$fecha_nacimiento   = $_POST["fecha_nacimiento"]   ?? null;  // f(null|'') => NULL
$numero_emergencia  = $_POST["numero_emergencia"]  ?? '';
$estado_civil       = $_POST["estado_civil"]       ?? '';
$categoria          = $_POST["categoria"]          ?? '';
$fecha_ingreso      = $_POST["fecha_ingreso"]      ?? '';    // 'YYYY-MM-DD' esperado
$salario_bruto      = $_POST["salario_bruto"]      ?? '';   

// 9) Separar año/mes/día si vino fecha_ingreso
$year_ingreso = $mes_ingreso = $dia_ingreso = '';
if ($fecha_ingreso && strpos($fecha_ingreso, '-') !== false) {
  $parts = explode('-', $fecha_ingreso);
  $year_ingreso = $parts[0] ?? '';
  $mes_ingreso  = $parts[1] ?? '';
  $dia_ingreso  = $parts[2] ?? '';
}

// (variables no críticas; por si tuvieras lógica adicional más adelante)
$stock_ingreso            = $_POST['stock_ingreso']       ?? '';
$precio_compra            = $_POST['precio_compra']       ?? '';
$precio_ventapublico      = $_POST['venta']               ?? '';
$codigo                   = $_POST['codigo']              ?? '';
$stock_minimo             = $_POST['stock_minimo']        ?? '';
$serie                    = $_POST['serie']               ?? '';
$precio_ventadistribuidor = 1;

// 10) Buscar usuario (como tenías)
$idusuario = '';
$nombre    = '';
$apellidos = '';

$q = mysqli_query($con, "SELECT * FROM usuario WHERE idempleado='".mysqli_real_escape_string($con,$idempleado)."' AND idsucursal='".mysqli_real_escape_string($con,$idsucursal)."'");
while ($row = mysqli_fetch_array($q)) {
  $idusuario = $row['idusuario'];
  $nombre    = $row['nombre'];
  $apellidos = $row['apellidos'];
}

// 11) Borrar de inventario si viene ?id= numérico
$ideliminar = $_GET['id'] ?? '';
if ($ideliminar !== '' && ctype_digit((string)$ideliminar)) {
  mysqli_query($con, "DELETE FROM inventario WHERE id='".mysqli_real_escape_string($con,$ideliminar)."'");
}

// 12) Upload opcional (sin echos)
$imagen1    = '';
$target_dir = "Files/Empleados_planilla/";  // asegurar existencia/permisos

if (!empty($_FILES['imagen1']['name'])) {
  $isImg = @getimagesize($_FILES["imagen1"]["tmp_name"]);
  if ($isImg !== false) {
    $baseName    = basename($_FILES["imagen1"]["name"]);
    $uniqueName  = time() . '_' . preg_replace('/\s+/', '_', $baseName);
    $target_file = rtrim($target_dir, '/').'/'.$uniqueName;
    if ($_FILES["imagen1"]["size"] <= 50000000) {
      if (move_uploaded_file($_FILES["imagen1"]["tmp_name"], $target_file)) {
        $imagen1 = $target_file;
      }
    }
  }
}

// 13) INSERT principal (mandando vacío en strings, NULL en ints/fechas si corresponde)
$sql = "INSERT INTO empleados_planilla(
  nombre_completo,
  tipo_documento,
  cedula,
  nacionalidad,
  fecha_nacimiento,
  year_ingreso,
  mes_ingreso,
  dia_ingreso,
  sumar,
  restar,
  estado_civil,
  numero_emergencia,
  categoria,
  imagen1,
  salario_bruto
) VALUES (
  ".s($con,$nombre_completo).",
  ".s($con,$tipo_documento).",
  ".s($con,$cedula).",
  ".s($con,$nacionalidad).",
  ".f($con,$fecha_nacimiento).",
  ".d($year_ingreso).",
  ".d($mes_ingreso).",
  ".d($dia_ingreso).",
  ".d($sumar).",
  ".d($restar).",
  ".s($con,$estado_civil).",
  ".s($con,$numero_emergencia).",
  ".s($con,$categoria).",
  ".s($con,$imagen1).",
  ".m($salario_bruto)."
)";


if ($__DEBUG) {
  echo "\n-- SQL A EJECUTAR --\n".$sql."\n";
}

mysqli_query($con, $sql); // en debug, mysqli_report lanzará excepción si falla

// 14) Salida / Redirección
if ($__DEBUG) {
  echo "\nOK: Insert realizado. (No se redirige en modo debug)\n";
  if (ob_get_level()) { ob_end_flush(); }
  exit;
} else {
  $destino = "consulta_empleadosplanilla.php?idusuario={$idusuario}&idsucursal={$idsucursal}";
  header("Location: $destino");
  if (ob_get_level()) { ob_end_flush(); }
  exit;
}
