<?php
session_start();
include('dbcon.php');

if (!isset($_SESSION['idsucursal'])) {
    die('Sesión expirada.');
}

$idsucursal  = $_SESSION['idsucursal'];
$idrecibido  = isset($_GET["id"]) ? $_GET["id"] : 0; // Para redirección a consulta
// POST esperados
$empleado    = isset($_POST["empleado_nuevo"]) ? $_POST["empleado_nuevo"] : null;
$fecha       = isset($_POST["fecha"]) ? $_POST["fecha"] : null; // (si no lo usas, no pasa nada)
$area        = isset($_POST["area"]) ? $_POST["area"] : null;   // (idem)
$resp1       = isset($_POST["responsabilidad"]) ? $_POST["responsabilidad"] : '';
$resp2       = isset($_POST["responsabilidad2"]) ? $_POST["responsabilidad2"] : '';
$motivo      = isset($_POST["motivo"]) ? $_POST["motivo"] : '';
$fecha_desde = isset($_POST["desde"]) ? $_POST["desde"] : '';
$fecha_hasta = isset($_POST["hasta"]) ? $_POST["hasta"] : '';
$fecha_doc   = isset($_POST["fecha_documento"]) ? $_POST["fecha_documento"] : '';
$cantidad    = isset($_POST["cantidad_dias"]) ? $_POST["cantidad_dias"] : 0;
$id_bd       = isset($_POST["id_bd"]) ? (int)$_POST["id_bd"] : 0;

$responsabilidad = trim($resp1 . ' | ' . $resp2);

date_default_timezone_set('America/Costa_Rica');
$hora_creacion  = date('H:i');
$fecha_creacion = date('Y-m-d');

// Validación mínima
if ($id_bd <= 0) {
    die('ID de registro inválido.');
}
if (!$fecha_desde || !$fecha_hasta || !$fecha_doc || !$empleado) {
    die('Faltan datos requeridos.');
}

// =================== ACTUALIZACIÓN VACACIONES ===================
$sqlUpdate = "UPDATE ingreso_vacaciones SET
                fecha_desde     = ?,
                fecha_hasta     = ?,
                fecha_documento = ?,
                motivo          = ?,
                idempleado      = ?,
                cantidad_dias   = ?
              WHERE id = ?";

if ($stmt = mysqli_prepare($con, $sqlUpdate)) {
    mysqli_stmt_bind_param($stmt, "ssssiii",
        $fecha_desde,
        $fecha_hasta,
        $fecha_doc,
        $motivo,
        $empleado,
        $cantidad,
        $id_bd
    );
    mysqli_stmt_execute($stmt);
    mysqli_stmt_close($stmt);
} else {
    die('Error al preparar actualización de vacaciones: ' . mysqli_error($con));
}

// =================== ACTUALIZACIÓN DE FERIADOS (REEMPLAZO TOTAL) ===================
// Viene desde el formulario como JSON (por ejemplo '["2025-10-08","2025-10-10"]' o '[]')
$ferJson = isset($_POST['feriados_json']) ? $_POST['feriados_json'] : '[]';
$ferArr  = json_decode($ferJson, true);
if (!is_array($ferArr)) { $ferArr = []; }

// 1) Borra todos los feriados actuales del registro
$delSql = "DELETE FROM vacaciones_feriados WHERE idvacacion = ?";
if ($del = mysqli_prepare($con, $delSql)) {
    mysqli_stmt_bind_param($del, "i", $id_bd);
    mysqli_stmt_execute($del);
    mysqli_stmt_close($del);
} else {
    die('Error al preparar borrado de feriados: ' . mysqli_error($con));
}

// 2) Inserta lo que venga (si no viene nada, se quedan en cero)
if (!empty($ferArr)) {
    $insSql = "INSERT INTO vacaciones_feriados (idvacacion, fecha) VALUES (?, ?)";
    if ($ins = mysqli_prepare($con, $insSql)) {
        foreach ($ferArr as $f) {
            // Validar formato YYYY-MM-DD
            if (preg_match('/^\d{4}-\d{2}-\d{2}$/', $f)) {
                mysqli_stmt_bind_param($ins, "is", $id_bd, $f);
                mysqli_stmt_execute($ins);
            }
        }
        mysqli_stmt_close($ins);
    } else {
        die('Error al preparar inserción de feriados: ' . mysqli_error($con));
    }
}

// =================== MANEJO DE IMAGEN (opcional) ===================
$target_dir = "Files/Ingreso_vacaciones/";
if (!is_dir($target_dir)) {
    @mkdir($target_dir, 0775, true);
}

if (!empty($_FILES['imagen1']['name'])) {
    $original   = basename($_FILES["imagen1"]["name"]);
    $ext        = pathinfo($original, PATHINFO_EXTENSION);
    $safeName   = 'vac_' . $id_bd . '_' . time() . '.' . $ext;
    $targetFile = $target_dir . $safeName;

    // Validaciones básicas
    $uploadok = 1;

    // Si es imagen, getimagesize valida. Si es PDF, getimagesize fallará y no lo consideramos error.
    $check = @getimagesize($_FILES["imagen1"]["tmp_name"]);
    if ($check === false && strtolower($ext) !== 'pdf') {
        $uploadok = 0;
    }

    if (file_exists($targetFile)) $uploadok = 0;
    if ($_FILES["imagen1"]["size"] > 50 * 1024 * 1024) $uploadok = 0; // 50MB

    if ($uploadok == 1) {
        if (move_uploaded_file($_FILES["imagen1"]["tmp_name"], $targetFile)) {
            $imagenPath = $targetFile;
            $upImg = "UPDATE ingreso_vacaciones SET imagen1 = ? WHERE id = ?";
            if ($s = mysqli_prepare($con, $upImg)) {
                mysqli_stmt_bind_param($s, "si", $imagenPath, $id_bd);
                mysqli_stmt_execute($s);
                mysqli_stmt_close($s);
            }
        }
    }
}

// =================== REDIRECCIÓN FINAL ===================
$mensaje = urlencode('Registro actualizado satisfactoriamente.');
echo "<script>
    alert('Registro actualizado satisfactoriamente.');
    window.location.href = 'consulta_vacaciones.php?id={$idrecibido}&msg={$mensaje}';
</script>";
exit;
