<?php
// empleados_planilla_update.php
declare(strict_types=1);

if (session_status() === PHP_SESSION_NONE) session_start();

/* ===== DEBUG & LOG ===== */
ini_set('display_errors', '1');            // En producción pon '0'
ini_set('log_errors', '1');
ini_set('error_log', __DIR__ . '/error_empleados_planilla.log');
error_reporting(E_ALL);

/* ===== DB ===== */
require_once __DIR__ . '/dbcon.php';
if (!isset($con) || !($con instanceof mysqli)) {
  http_response_code(500);
  echo "<pre>ERROR: conexión \$con no disponible desde dbcon.php</pre>";
  exit;
}
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
mysqli_set_charset($con, 'utf8mb4');

/* ===== Helpers ===== */
function fail(string $msg, int $code = 500): void {
  http_response_code($code);
  echo "<pre>ERROR: {$msg}</pre>";
  exit;
}
function post(string $k, string $default = ''): string {
  return isset($_POST[$k]) ? trim((string)$_POST[$k]) : $default;
}
function safe_str(?string $v): string {
  return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8');
}

/* ===== Entradas ===== */
$idsucursal        = $_SESSION['idsucursal'] ?? '';
$idrecibido        = post('idenv');                 // ID del registro
$idempleado        = post('idempleado');
$nombre_completo   = post('nombre_completo');
$tipo_documento    = post('tipo_documento');
$cedula            = post('cedula');
$nacionalidad      = post('nacionalidad');
$sumar             = post('sumar');
$restar            = post('restar');
$fecha_nacimiento  = post('fecha_nacimiento');
$numero_emergencia = post('numero_emergencia');
$estado_civil      = post('estado_civil');
$categoria         = post('categoria');             // *** TEXTO ***
$fecha_ingreso     = post('fecha_ingreso');         // "YYYY-MM-DD"
$salario_bruto = post('salario');

/* ===== Validaciones mínimas ===== */
if ($idrecibido === '')        fail('Falta idenv (ID del registro a actualizar).');
if ($idsucursal === '')        fail('Falta $_SESSION["idsucursal"]. ¿Iniciaste sesión?');
if ($nombre_completo === '')   fail('Falta nombre_completo.');
$salario_bruto_num = 0.0;
if ($salario_bruto !== '') {
  $tmp = str_replace([' ', ','], ['', '.'], $salario_bruto);
  $salario_bruto_num = is_numeric($tmp) ? (float)$tmp : 0.0;
}

/* Fecha ingreso (opcional) */
$year_ingreso = $mes_ingreso = $dia_ingreso = null;
if ($fecha_ingreso !== '') {
  $parts = explode('-', $fecha_ingreso);
  if (count($parts) !== 3)       fail('fecha_ingreso con formato inválido. Usa YYYY-MM-DD.');
  [$year_ingreso, $mes_ingreso, $dia_ingreso] = $parts;
  if (!ctype_digit($year_ingreso) || !ctype_digit($mes_ingreso) || !ctype_digit($dia_ingreso)) {
    fail('fecha_ingreso inválida (componentes no numéricos).');
  }
}

/* ===== Normalización de campos numéricos ===== */
$restar_int = ($restar === '' || $restar === null) ? 0 : (int)$restar;
$sumar_int  = ($sumar  === '' || $sumar  === null) ? 0 : (int)$sumar;

$year_i = ($year_ingreso !== null && $year_ingreso !== '' && ctype_digit($year_ingreso)) ? (int)$year_ingreso : null;
$mes_i  = ($mes_ingreso  !== null && $mes_ingreso  !== '' && ctype_digit($mes_ingreso))  ? (int)$mes_ingreso  : null;
$dia_i  = ($dia_ingreso  !== null && $dia_ingreso  !== '' && ctype_digit($dia_ingreso))  ? (int)$dia_ingreso  : null;

/* ===== Variables varias ===== */
date_default_timezone_set('America/Costa_Rica');
$hora_creacion  = date('H:i');
$fecha_creacion = date('Y-m-d');

/* ===== Consultas auxiliares (opcionales) ===== */
try {
  $impuesto = 0;
  $rs = mysqli_query($con, "SELECT * FROM global") or die(mysqli_error($con));
  while ($row = mysqli_fetch_assoc($rs)) { $impuesto = (float)$row['porcentaje_impuesto']; }

  $codigo2 = null;
  $rs = mysqli_query($con, "SELECT * FROM codigosuma ORDER BY id ASC") or die(mysqli_error($con));
  while ($row = mysqli_fetch_assoc($rs)) { $codigo2 = ((int)$row['id']) + 1; }

  $idempleado_sql = mysqli_real_escape_string($con, $idempleado);
  $idsucursal_sql = mysqli_real_escape_string($con, $idsucursal);
  $rs = mysqli_query(
    $con,
    "SELECT * FROM usuario WHERE idempleado='{$idempleado_sql}' AND idsucursal='{$idsucursal_sql}'"
  ) or die(mysqli_error($con));
  $idusuario = null;
  if ($u = mysqli_fetch_assoc($rs)) { $idusuario = $u['idusuario']; }

  $idrec_sql = mysqli_real_escape_string($con, $idrecibido);
  $rs = mysqli_query($con, "SELECT * FROM emailrequest WHERE id='{$idrec_sql}'") or die(mysqli_error($con));
  $idmanager = $idsubmanager = null;
  if ($er = mysqli_fetch_assoc($rs)) {
    $idmanager   = $er['idmanager']    ?? null;
    $idsubmanager= $er['idsubmanager'] ?? null;
  }
} catch (Throwable $e) {
  fail('Error en consultas auxiliares: ' . $e->getMessage());
}

/* ===== Subida de archivo (opcional) ===== */
$target_dir_abs    = rtrim(__DIR__, '/\\') . "/Files/Empleados_planilla/";
$target_dir_public = "Files/Empleados_planilla/";

if (!is_dir($target_dir_abs)) {
  if (!@mkdir($target_dir_abs, 0755, true) && !is_dir($target_dir_abs)) {
    fail('No se pudo crear la carpeta destino: ' . safe_str($target_dir_abs));
  }
}

$hayImagen = (isset($_FILES['imagen1']['name']) && $_FILES['imagen1']['name'] !== '' &&
              isset($_FILES['imagen1']['tmp_name']) && is_uploaded_file($_FILES['imagen1']['tmp_name']));

$imagen2_public = null;
if ($hayImagen) {
  $fileName = basename($_FILES['imagen1']['name']);
  $target_file_abs    = $target_dir_abs . $fileName;
  $target_file_public = $target_dir_public . $fileName;

  $check = @getimagesize($_FILES['imagen1']['tmp_name']);
  if ($check === false) fail('El archivo subido no es una imagen válida.');
  if (file_exists($target_file_abs)) fail('El archivo ya existe: ' . safe_str($fileName));
  if ($_FILES['imagen1']['size'] > 50_000_000) fail('La imagen supera 50MB.');
  if (!@move_uploaded_file($_FILES['imagen1']['tmp_name'], $target_file_abs)) {
    fail('No se pudo mover el archivo subido al destino.');
  }
  $imagen2_public = $target_file_public;
}

/* ===== UPDATE empleados_planilla ===== */
try {
  // Escapar strings
  $nombre_completo_sql   = mysqli_real_escape_string($con, $nombre_completo);
  $cedula_sql            = mysqli_real_escape_string($con, $cedula);
  $tipo_documento_sql    = mysqli_real_escape_string($con, $tipo_documento);
  $nacionalidad_sql      = mysqli_real_escape_string($con, $nacionalidad);
  $numero_emergencia_sql = mysqli_real_escape_string($con, $numero_emergencia);
  $fecha_nacimiento_sql  = mysqli_real_escape_string($con, $fecha_nacimiento);
  $estado_civil_sql      = mysqli_real_escape_string($con, $estado_civil);
  $categoria_sql         = mysqli_real_escape_string($con, $categoria); // *** TEXTO ***

  // SET: numeros sin comillas; categoria como TEXTO con comillas
  $set = "
    nombre_completo   = '{$nombre_completo_sql}',
    cedula            = '{$cedula_sql}',
    tipo_documento    = '{$tipo_documento_sql}',
    nacionalidad      = '{$nacionalidad_sql}',
    numero_emergencia = '{$numero_emergencia_sql}',
    fecha_nacimiento  = '{$fecha_nacimiento_sql}',
    estado_civil      = '{$estado_civil_sql}',
    categoria         = '{$categoria_sql}',
    restar            = {$restar_int},
    sumar             = {$sumar_int},
    salario_bruto = {$salario_bruto_num}

  ";

  if ($fecha_ingreso !== '') {
    $set .= ",
      year_ingreso = " . ($year_i !== null ? $year_i : "NULL") . ",
      mes_ingreso  = " . ($mes_i  !== null ? $mes_i  : "NULL") . ",
      dia_ingreso  = " . ($dia_i  !== null ? $dia_i  : "NULL") . "
    ";
  }

  // Si tu tabla tiene 'imagen', descomenta:
  // if ($imagen2_public !== null) {
  //   $img_sql = mysqli_real_escape_string($con, $imagen2_public);
  //   $set .= ", imagen = '{$img_sql}'";
  // }

  $sql = "UPDATE empleados_planilla SET {$set} WHERE id = '{$idrec_sql}'";
  if (!mysqli_query($con, $sql)) {
    fail('Fallo en UPDATE: ' . mysqli_error($con));
  }

} catch (Throwable $e) {
  fail('Error actualizando empleados_planilla: ' . $e->getMessage());
}

/* ===== (Opcional) Consultas finales no críticas ===== */
try {
  $idingreso = 0; $idarticulo = 0;
  $rs = mysqli_query($con, "SELECT * FROM ingreso") or die(mysqli_error($con));
  while ($row = mysqli_fetch_assoc($rs)) { $idingreso = (int)$row['idingreso']; }

  $rs = mysqli_query($con, "SELECT * FROM articulo") or die(mysqli_error($con));
  while ($row = mysqli_fetch_assoc($rs)) { $idarticulo = (int)$row['idarticulo']; }
} catch (Throwable $e) {
  error_log('Aviso (no crítico): ' . $e->getMessage());
}

/* ===== Éxito: confirm + redirect ===== */
echo "<script>
  var opcion = window.confirm('¡Actualizado correctamente!\\n\\nPresiona Aceptar para continuar o Cancelar para regresar y editar.');
  if (opcion) {
    window.location.href = 'consulta_empleadosplanilla.php?id=" . safe_str($idrecibido) . "';
  } else {
    window.location.href = 'detalle_empleadosplanilla.php?id=" . safe_str($idrecibido) . "';
  }
</script>";
exit;
