<?php
// public_html/colegio/colegio10/rrhh_home/add_aprobar_vacaciones.php
// PHP 5.6 compatible: Actualiza SOLO el status=1 del registro indicado.

session_start();
date_default_timezone_set('America/Costa_Rica');
require_once __DIR__ . '/dbcon.php';

// ---- Validaciones mínimas de sesión (ajusta a tu lógica si necesitas) ----
if (!isset($_SESSION['idsucursal'])) {
    die('Sesión expirada. Vuelve a iniciar sesión.');
}

// ---- Entrada: tomamos el id desde GET (?id=) o, en su defecto, POST (id_bd) ----
$id = 0;
if (isset($_GET['id'])) {
    $id = (int) $_GET['id'];
} elseif (isset($_POST['id_bd'])) {
    $id = (int) $_POST['id_bd'];
}

if ($id <= 0) {
    die('ID de registro inválido.');
}

// ---- UPDATE: SOLO status = 1 ----
$sql = "UPDATE ingreso_vacaciones SET status = ? WHERE id = ?";
if ($stmt = mysqli_prepare($con, $sql)) {
    $status = 1; // Aprobado
    mysqli_stmt_bind_param($stmt, "ii", $status, $id);

    if (!mysqli_stmt_execute($stmt)) {
        mysqli_stmt_close($stmt);
        die('Error al actualizar el status: ' . mysqli_error($con));
    }
    mysqli_stmt_close($stmt);
} else {
    die('Error al preparar la consulta: ' . mysqli_error($con));
}

// ---- Redirección: vuelve a la lista/consulta. Usa idrequerimiento si viene en el enlace ----
$idrequerimiento = isset($_GET['idrequerimiento']) ? (int)$_GET['idrequerimiento'] : 0;
$destino = 'consulta_vacaciones.php';
if ($idrequerimiento > 0) {
    $destino .= '?id=' . $idrequerimiento;
}

// Mensaje simple y redirección
echo "<script>
    alert('Registro aprobado correctamente.');
    window.location.href = '{$destino}';
</script>";
exit;

