<?php
// acceder.php — robusto (PHP 8.1), evita pantalla en blanco
declare(strict_types=1);

// Muestra errores en desarrollo (quítalo cuando todo esté ok)
ini_set('display_errors', '1');
error_reporting(E_ALL);

if (session_status() === PHP_SESSION_NONE) session_start();

// Guardia de sesión
if (empty($_SESSION["idusuario"])) {
  header("Location: index.html?e=nosession");
  exit;
}

// Helpers para salida segura
function h(?string $s): string { return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

// Valores de sesión (con fallback para evitar warnings)
$foto          = $_SESSION["foto"]          ?? '';
$empleado      = $_SESSION["empleado"]      ?? 'Usuario';
$tipo_usuario  = $_SESSION["tipo_usuario"]  ?? '';
$tipo_doc      = $_SESSION["tipo_documento"]?? '';
$num_doc       = $_SESSION["num_documento"] ?? '';
$telefono      = $_SESSION["telefono"]      ?? '';
$direccion     = $_SESSION["direccion"]     ?? '';
$email         = $_SESSION["email"]         ?? '';
$login         = $_SESSION["login"]         ?? '';

// Imagen por defecto si no hay foto
if (!$foto || !preg_match('~\.(png|jpe?g|gif|webp|svg)$~i', $foto)) {
  $foto = 'public/img/user-default.png'; // crea este archivo si no existe
}

// Si la foto viene sin ruta absoluta, asumimos que vive bajo el docroot del subdominio
if ($foto && $foto[0] !== '/' && !preg_match('~^https?://~i', $foto)) {
  $foto = '/' . ltrim($foto, '/');
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>SISTEMA CBCR V1.0</title>
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">

  <!-- CSS -->
  <link rel="stylesheet" href="/public/css/bootstrap.min.css">
  <link rel="stylesheet" href="/public/css/font-awesome.css">
  <link rel="stylesheet" href="/public/css/AdminLTE.min.css">
  <link rel="stylesheet" href="/public/css/blue.css">

  <style>
    html, body { height: 100%; }
    body.login-page{
      background: url('/Files/1.jpg') no-repeat center center fixed;
      -webkit-background-size: cover; -moz-background-size: cover;
      -o-background-size: cover; background-size: cover;
    }
    body.login-page::before{
      content:""; position:fixed; inset:0; background:rgba(255,255,255,.65);
      pointer-events:none; z-index:0;
    }
    .content, .box, .login-box, .widget-user-2 { position:relative; z-index:1; }
    .warn { background:#fff3cd; border:1px solid #ffeeba; padding:.5rem .75rem; border-radius:.25rem; margin-bottom:10px; }
  </style>

  <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->
</head>
<body class="hold-transition login-page">
  <section class="content">
    <div class="row">
      <!-- left column -->
      <div class="col-md-4">
        <div class="box box-primary">
          <div class="box-header with-border">
            <h3 class="box-title">User data:</h3>
          </div>
          <div class="box-body">
            <div class="row">
              <div class="col-xs-12">
                <div class="box box-widget widget-user-2">
                  <div class="widget-user-header bg-yellow">
                    <div class="widget-user-image">
                      <img class="img-circle" src="<?php echo h($foto); ?>" alt="Usuario" onerror="this.src='/public/img/user-default.png'">
                    </div>
                    <h3 class="widget-user-username"><?php echo h($empleado); ?></h3>
                    <h5 class="widget-user-desc"><?php echo h($tipo_usuario); ?></h5>
                  </div>
                  <div class="box-footer no-padding">
                    <ul class="nav nav-stacked">
                      <li><a href="#"><strong>Document:</strong>&nbsp; <?php echo h($tipo_doc.' '.$num_doc); ?>
                        <span class="pull-right badge bg-red"><i class="fa fa-fw fa-book"></i></span></a></li>
                      <li><a href="#"><strong>Phone Number:</strong>&nbsp; <?php echo h($telefono); ?>
                        <span class="pull-right badge bg-blue"><i class="fa fa-fw fa-mobile-phone"></i></span></a></li>
                      <li><a href="#"><strong>Address:</strong>&nbsp; <?php echo h($direccion); ?>
                        <span class="pull-right badge bg-aqua"><i class="fa fa-fw fa-taxi"></i></span></a></li>
                      <li><a href="#"><strong>Email:</strong>&nbsp; <?php echo h($email); ?>
                        <span class="pull-right badge bg-green"><i class="fa fa-fw fa-envelope"></i></span></a></li>
                      <li><a href="#"><strong>User:</strong>&nbsp; <?php echo h($login); ?>
                        <span class="pull-right badge bg-aqua"><i class="fa fa-fw fa-user"></i></span></a></li>
                    </ul>
                  </div>
                </div><!-- /.widget-user -->
              </div>
            </div>
          </div>
          <div class="box-footer">
            <a href="/ajax/UsuarioAjax.php?op=Salir" class="btn btn-danger">Logout</a>
          </div>
        </div>
      </div>

      <!-- right column -->
      <div class="col-md-8">
        <div class="box box-primary">
          <div class="box-header with-border">
            <h3 class="box-title">Access</h3>
          </div>
          <div class="box-body">
            <div id="warnBox" class="warn" style="display:none"></div>

            <div class="box">
              <div class="box-body no-padding">
                <table class="table table-hover" id="tblSucursal">
                  <thead>
                    <tr>
                      <th>Option</th>
                      <th>Place</th>
                      <th>Department</th>
                      <th>Type User</th>
                      <th>Logo</th>
                    </tr>
                  </thead>
                  <tbody id="Sucursal">
                    <!-- filas se cargan por AJAX -->
                  </tbody>
                </table>
              </div>
            </div>

          </div> <!-- /.box-body -->
        </div> <!-- /.box -->
      </div> <!-- /.col-md-8 -->
    </div> <!-- /.row -->
  </section> <!-- /.content -->

  <!-- JS -->
  <script src="/public/js/jquery.min.js"></script>
  <script src="/public/js/bootstrap.min.js"></script>
  <script src="/public/js/icheck.min.js"></script>

<script>
(function(){
  // Rutas ABSOLUTAS en el subdominio hr.jportales.com
  var AJAX_SUCURSAL = "/ajax/SucursalAjax.php?op=listSucursalEmp";
  var AJAX_USUARIO  = "/ajax/UsuarioAjax.php";
  var REDIRECT_URL  = "HomeRRHH.php";   // <- aquí defines a dónde ir después

  function showWarn(html){
    var el = document.getElementById('warnBox');
    if (!el) return;
    el.innerHTML = html;
    el.style.display = 'block';
  }

  function ListadoIngresos(){
    $.post(AJAX_SUCURSAL)
      .done(function(r){
        $("#Sucursal").html(r || '<tr><td colspan="5"><em>Sin datos</em></td></tr>');
      })
      .fail(function(xhr,s,e){
        showWarn("No se pudo cargar <code>listSucursalEmp</code> ("+xhr.status+" "+(e||s)+").");
        console.error("SucursalAjax fail:", xhr.responseText);
        $("#Sucursal").html('<tr><td colspan="5"><em>Error cargando sucursales</em></td></tr>');
      });
  }

  // === FUNCIÓN USADA POR LAS FILAS PARA ENTRAR AL PANEL ===
  window.Acceder = function(
    idusuario, idsucursal, idempleado, empleado, tipo_documento, tipo_usuario,
    num_documento, direccion, telefono, foto, logo, email, login, razon_social,
    mnu_almacen, mnu_compras, mnu_ventas, mnu_mantenimiento, mnu_seguridad,
    mnu_consulta_compras, mnu_consulta_ventas, mnu_admin
  ){
    var data = {
      idusuario:idusuario, idsucursal:idsucursal, idempleado:idempleado,
      empleado:empleado, tipo_documento:tipo_documento, tipo_usuario:tipo_usuario,
      num_documento:num_documento, direccion:direccion, telefono:telefono,
      foto:foto, logo:logo, email:email, login:login, razon_social:razon_social,
      mnu_almacen:mnu_almacen, mnu_compras:mnu_compras, mnu_ventas:mnu_ventas,
      mnu_mantenimiento:mnu_mantenimiento, mnu_seguridad:mnu_seguridad,
      mnu_consulta_compras:mnu_consulta_compras, mnu_consulta_ventas:mnu_consulta_ventas,
      mnu_admin:mnu_admin
    };
    $.post(AJAX_USUARIO + "?op=IngresarPanel", data)
      .done(function(){ window.location.href = REDIRECT_URL; })   // ← ahora va a HomeRRHH.php
      .fail(function(xhr,s,e){
        showWarn("No se pudo ingresar al panel ("+xhr.status+" "+(e||s)+").");
        console.error("IngresarPanel fail:", xhr.responseText);
      });
  };

  // Si usas acceso de superadmin directo
  window.AccederSuperAdmin = function(
    idempleado, idusuario, idsucursal, estadoAdmin, empleado, tipo_documento, direccion,
    telefono, foto, email, login, mnu_almacen, mnu_compras, mnu_ventas, mnu_mantenimiento,
    mnu_seguridad, mnu_consulta_compras, mnu_consulta_ventas, mnu_admin, logo
  ){
    var data = {
      idempleado:idempleado, idusuario:idusuario, idsucursal:idsucursal, estadoAdmin:estadoAdmin,
      empleado:empleado, tipo_documento:tipo_documento, direccion:direccion, telefono:telefono,
      foto:foto, email:email, login:login, mnu_almacen:mnu_almacen, mnu_compras:mnu_compras,
      mnu_ventas:mnu_ventas, mnu_mantenimiento:mnu_mantenimiento, mnu_seguridad:mnu_seguridad,
      mnu_consulta_compras:mnu_consulta_compras, mnu_consulta_ventas:mnu_consulta_ventas,
      mnu_admin:mnu_admin, logo:logo
    };
    $.post(AJAX_USUARIO + "?op=IngresarPanelSuperAdmin", data)
      .done(function(){ window.location.href = "HomeRRHH.php"; }) // ← también a HomeRRHH.php
      .fail(function(xhr,s,e){
        showWarn("No se pudo ingresar como SuperAdmin ("+xhr.status+" "+(e||s)+").");
        console.error("IngresarPanelSuperAdmin fail:", xhr.responseText);
      });
  };

  $(document).ready(function(){ ListadoIngresos(); });
})();
</script>

</body>
</html>
