-- SQL_SECTOR_PLAN.sql
-- Tabla para almacenar planos por sector (arquitectónico/eléctrico), con versionado y publicación.

CREATE TABLE IF NOT EXISTS `sector_plan` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `sector_id` INT NOT NULL,
  `type` ENUM('architectural','electrical','mixed') NOT NULL DEFAULT 'electrical',
  `status` ENUM('draft','published','archived') NOT NULL DEFAULT 'draft',
  `version` INT NOT NULL,
  `svg` LONGTEXT NULL,
  `json` LONGTEXT NULL,
  `scale_px_per_m` DECIMAL(10,4) NULL,
  `thickness_default_m` DECIMAL(10,3) NULL,
  `notes` VARCHAR(255) NULL,
  `updated_by` INT NULL,
  `updated_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  KEY `idx_sector_type_version` (`sector_id`,`type`,`version`),
  KEY `idx_sector_status` (`sector_id`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Regla práctica: solo 1 publicado por sector+tipo (no se fuerza con constraint, se maneja en app).
