# módulo_plano (MVP v0.6) — 2025-10-29 02:42

Este módulo es un **esqueleto funcional** para almacenar, versionar y visualizar planos 2D por **sector**, con
base para plano **arquitectónico** y **eléctrico** (incluye acometida en encabezados y selector de circuitos por sector).

> **Compatibilidad**: PHP 8.1.33, MySQL/MariaDB.  
> **Integración**: pensado para incrustar el visor en `inventario/sector_view.php` vía iframe.

## Estructura
- `editor/` — páginas del editor (arquitectónico y eléctrico) + panel de versiones.
- `viewer/` — visor embebible y pantalla completa.
- `ajax/` — endpoints CRUD de `sector_plan` + meta/circuitos por sector.
- `includes/` — auth, db, helpers, sector_data y renderizado de SVG.
- `assets/` — CSS/JS base (placeholders para crecer).
- `reports/` — reportes mínimos de cargas y dispositivos.
- `templates/` — header/footer y header de impresión con acometida, leyendas, escala.
- `config/` — configuración simple.

## Qué hace hoy (MVP)
1. Crea y guarda planos por `sector_id` y `type` (`architectural` | `electrical`).  
2. Versiona: guarda versiones incrementales; se puede **publicar** una versión.  
3. Muestra el plano publicado del sector en el **visor** (con leyendas y acometida).  
4. Endpoints de **metadatos del sector** y **circuitos por sector** (consultas genéricas con *fallback*).
5. **Reportes básicos**: cargas por circuito y dispositivos 120/220.

## Lo pendiente (para implementar en próximas iteraciones)
- Editor visual completo (muros, puertas/ventanas, chaflán/fillet, símbolos y cableado por colores).  
  Hoy el editor permite gestionar metadatos y pegar **SVG** y **JSON** (escena) manualmente para pruebas.
- Integración exacta con tus tablas de `tablero/circuito/sector_acometida` (endpoints listos para ajustar SQL).

## SQL
- Ver `SQL_SECTOR_PLAN.sql` (adjunto).

## Incrustar en inventario/sector_view.php (ejemplo)
```html
<iframe src="/modulo_plano/viewer/plan_view.php?sector_id=32&type=electrical"
        style="width:100%;height:540px;border:0;"></iframe>
```

## Bitácora
- v0.6: Esqueleto completo (páginas, endpoints, reportes básicos, visor) + SQL y plantillas.
